/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.ref.SoftReference;

class BufferCache<T> {
    SoftReference<T>[] buffers;
    int top = 0;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_17:37:34_PDT_2008";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    BufferCache(int n2) {
        this.buffers = new SoftReference[n2];
    }

    void resize(int n2) {
        SoftReference[] softReferenceArray = new SoftReference[n2];
        System.arraycopy(this.buffers, Math.max(0, this.top - softReferenceArray.length), softReferenceArray, 0, Math.min(this.top, softReferenceArray.length));
        this.buffers = softReferenceArray;
        this.top = Math.min(this.top, this.buffers.length);
    }

    void clear() {
        while (this.top > 0) {
            this.buffers[--this.top] = null;
        }
    }

    void put(T t) {
        if (this.top < this.buffers.length) {
            this.buffers[this.top++] = new SoftReference<T>(t);
        } else {
            int n2 = this.top;
            while (n2 > 0) {
                if (this.buffers[--n2].get() != null) continue;
                this.buffers[n2] = new SoftReference<T>(t);
                return;
            }
        }
    }

    T get() {
        while (this.top > 0) {
            T t = this.buffers[--this.top].get();
            this.buffers[this.top] = null;
            if (t == null) continue;
            return t;
        }
        return null;
    }
}

