package com.jang.addrbook;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AddrController {
	
	//ȸƮ
	@RequestMapping("/addrbook_list.do")
	public ModelAndView addrbook_list(AddrBook ab, AddrBean abdao, ModelAndView mav) throws Exception {
		mav.addObject("addrBookList", abdao.getDBList());
		mav.setViewName("addrbook_list");
		return mav;
	}
	
	//űȸ 
	@RequestMapping("/addrbook_form.do")
	public String addrbookForm() throws Exception {
		return "addrbook_form";
	}
	
	//űȸ insert
		@RequestMapping("/addrbook_insert.do")
		public String addrbookInsert(AddrBook ab, AddrBean abdao) throws Exception {
			abdao.insertDB(ab);
			return "home";
		}
		
	//Ưȸ 
		@RequestMapping("/addrbook_edit_form.do")
		public ModelAndView addrbookOne(AddrBook ab, AddrBean abdao, ModelAndView mav) throws Exception {
			mav.addObject("addrBookOne", abdao.getDB(ab.getAb_id()));
			mav.setViewName("addrbook_edit_form");
			return mav;
		}
		
		//ȸ  update
		@RequestMapping("/addrbook_update.do")
		public String addrbookUpdate(AddrBook ab, AddrBean abdao) throws Exception {
		abdao.updateDB(ab);
		return "redirect:addrbook_list.do";
		}
		
		//ȸ  delete
		@RequestMapping("/addrbook_delete.do")
		public String addrbookDelete(AddrBook ab, AddrBean abdao) throws Exception {
		abdao.deleteDB(ab.getAb_id());
		return "redirect:addrbook_list.do";
		}
		
		
		////Խ
		//ԽǸƮ
		@RequestMapping("/LList.do")
		public ModelAndView LList(LList l, AddrBean abdao, ModelAndView mav) throws Exception {
			mav.addObject("LList", abdao.getDBLList());
			mav.setViewName("LList");
			return mav;
		}
		//۳
		@RequestMapping("/LListContent.do")
		public ModelAndView LListContent(LList l, AddrBean abdao, ModelAndView mav) throws Exception {
			mav.addObject("LListContent", abdao.getDB(l.getL_title()));
			mav.setViewName("LListContent");
			return mav;
		}
		//۾
		@RequestMapping("/LListNew.do")
		public String LListNew() throws Exception {
			return "LListNew";
		}
		@RequestMapping("/LListNewinsert.do")
		public String LListNewinsert(LList l, AddrBean abdao) throws Exception {
			abdao.LListinsertDB(l);
			return "redirect:LList.do";
		}
		//ȸ
		
		
		//
		@RequestMapping("/LListA.do")
		public ModelAndView LListA(LListA a, AddrBean abdao, ModelAndView mav) throws Exception {
			mav.addObject("LListA", abdao.getDBLLList());
			mav.setViewName("LListA");
			return mav;
		}
		//۾
		@RequestMapping("/LListANew.do")
		public String LListANew() throws Exception {
			return "LListANew";
		}
		@RequestMapping("/LListANewinsert.do")
		public String LListANewinsert(LListA l, AddrBean abdao) throws Exception {
			abdao.LListAinsertDB(l);
			return "redirect:LListA.do";
		}
		
		////α
		@RequestMapping("/login.do")
		public String login(AddrBook ab, AddrBean abdao,BindingResult result,Model model) throws Exception {
			if (result.hasFieldErrors("ab_name") || result.hasFieldErrors("ab_email")) {
				model.addAllAttributes(result.getModel());
				return "login";
			}
			return "login";
		}
		
		//
		@RequestMapping("/list.do")
		public ModelAndView list(AddrBook ab, AddrBean abdao, ModelAndView mav) throws Exception {
			mav.addObject("addrBookList", abdao.getDBList());
			mav.setViewName("list");
			return mav;
		}
}
