/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleStatement;

class ResultSetAccessor
extends Accessor {
    static final int maxLength = 16;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Dec_02_19:13:26_PST_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    ResultSetAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        this.init(oracleStatement, 102, 116, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    ResultSetAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 102, 116, s2, false);
        this.initForDescribe(102, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 16;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    @Override
    ResultSet getCursor(int n2) throws SQLException {
        byte[] byArray = this.getBytes(n2);
        OracleStatement oracleStatement = this.statement.connection.RefCursorBytesToStatement(byArray, this.statement);
        oracleStatement.doDescribe(false);
        oracleStatement.prepareAccessors();
        OracleResultSetImpl oracleResultSetImpl = new OracleResultSetImpl(oracleStatement.connection, oracleStatement);
        oracleResultSetImpl.close_statement_on_close = true;
        oracleStatement.currentResultSet = oracleResultSetImpl;
        return oracleResultSetImpl;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.getCursor(n2);
    }
}

