/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.keygen;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.ArrayUtil;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.defaults.DefaultSqlSession;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class Jdbc3KeyGenerator
implements KeyGenerator {
    public static final Jdbc3KeyGenerator INSTANCE = new Jdbc3KeyGenerator();

    @Override
    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
    }

    @Override
    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        this.processBatch(ms, stmt, parameter);
    }

    public void processBatch(MappedStatement ms, Statement stmt, Object parameter) {
        String[] keyProperties = ms.getKeyProperties();
        if (keyProperties == null || keyProperties.length == 0) {
            return;
        }
        try (ResultSet rs = stmt.getGeneratedKeys();){
            Configuration configuration = ms.getConfiguration();
            if (rs.getMetaData().getColumnCount() >= keyProperties.length) {
                Object soleParam = this.getSoleParameter(parameter);
                if (soleParam != null) {
                    this.assignKeysToParam(configuration, rs, keyProperties, soleParam);
                } else {
                    this.assignKeysToOneOfParams(configuration, rs, keyProperties, (Map)parameter);
                }
            }
        }
        catch (Exception e) {
            throw new ExecutorException("Error getting generated key or setting result to parameter object. Cause: " + e, e);
        }
    }

    protected void assignKeysToOneOfParams(Configuration configuration, ResultSet rs, String[] keyProperties, Map<?, ?> paramMap) throws SQLException {
        int firstDot = keyProperties[0].indexOf(46);
        if (firstDot == -1) {
            throw new ExecutorException("Could not determine which parameter to assign generated keys to. Note that when there are multiple parameters, 'keyProperty' must include the parameter name (e.g. 'param.id'). Specified key properties are " + ArrayUtil.toString(keyProperties) + " and available parameters are " + paramMap.keySet());
        }
        String paramName = keyProperties[0].substring(0, firstDot);
        if (!paramMap.containsKey(paramName)) {
            throw new ExecutorException("Could not find parameter '" + paramName + "'. Note that when there are multiple parameters, 'keyProperty' must include the parameter name (e.g. 'param.id'). Specified key properties are " + ArrayUtil.toString(keyProperties) + " and available parameters are " + paramMap.keySet());
        }
        Object param = paramMap.get(paramName);
        String[] modifiedKeyProperties = new String[keyProperties.length];
        for (int i = 0; i < keyProperties.length; ++i) {
            if (keyProperties[i].charAt(firstDot) != '.' || !keyProperties[i].startsWith(paramName)) {
                throw new ExecutorException("Assigning generated keys to multiple parameters is not supported. Note that when there are multiple parameters, 'keyProperty' must include the parameter name (e.g. 'param.id'). Specified key properties are " + ArrayUtil.toString(keyProperties) + " and available parameters are " + paramMap.keySet());
            }
            modifiedKeyProperties[i] = keyProperties[i].substring(firstDot + 1);
        }
        this.assignKeysToParam(configuration, rs, modifiedKeyProperties, param);
    }

    private void assignKeysToParam(Configuration configuration, ResultSet rs, String[] keyProperties, Object param) throws SQLException {
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        ResultSetMetaData rsmd = rs.getMetaData();
        Collection<Object> paramAsCollection = null;
        paramAsCollection = param instanceof Object[] ? Arrays.asList((Object[])param) : (!(param instanceof Collection) ? Arrays.asList(param) : (Collection)param);
        TypeHandler<?>[] typeHandlers = null;
        for (Object obj : paramAsCollection) {
            if (!rs.next()) break;
            MetaObject metaParam = configuration.newMetaObject(obj);
            if (typeHandlers == null) {
                typeHandlers = this.getTypeHandlers(typeHandlerRegistry, metaParam, keyProperties, rsmd);
            }
            this.populateKeys(rs, metaParam, keyProperties, typeHandlers);
        }
    }

    private Object getSoleParameter(Object parameter) {
        if (!(parameter instanceof MapperMethod.ParamMap) && !(parameter instanceof DefaultSqlSession.StrictMap)) {
            return parameter;
        }
        Object soleParam = null;
        for (Object paramValue : ((Map)parameter).values()) {
            if (soleParam == null) {
                soleParam = paramValue;
                continue;
            }
            if (soleParam == paramValue) continue;
            soleParam = null;
            break;
        }
        return soleParam;
    }

    private TypeHandler<?>[] getTypeHandlers(TypeHandlerRegistry typeHandlerRegistry, MetaObject metaParam, String[] keyProperties, ResultSetMetaData rsmd) throws SQLException {
        TypeHandler[] typeHandlers = new TypeHandler[keyProperties.length];
        for (int i = 0; i < keyProperties.length; ++i) {
            if (!metaParam.hasSetter(keyProperties[i])) {
                throw new ExecutorException("No setter found for the keyProperty '" + keyProperties[i] + "' in '" + metaParam.getOriginalObject().getClass().getName() + "'.");
            }
            Class<?> keyPropertyType = metaParam.getSetterType(keyProperties[i]);
            typeHandlers[i] = typeHandlerRegistry.getTypeHandler(keyPropertyType, JdbcType.forCode(rsmd.getColumnType(i + 1)));
        }
        return typeHandlers;
    }

    private void populateKeys(ResultSet rs, MetaObject metaParam, String[] keyProperties, TypeHandler<?>[] typeHandlers) throws SQLException {
        for (int i = 0; i < keyProperties.length; ++i) {
            String property = keyProperties[i];
            TypeHandler<?> th = typeHandlers[i];
            if (th == null) continue;
            Object value = th.getResult(rs, i + 1);
            metaParam.setValue(property, value);
        }
    }
}

