/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;

class DateAccessor
extends DateTimeCommonAccessor {
    static final int maxLength = 7;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Dec_02_19:13:26_PST_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    DateAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        this.init(oracleStatement, 12, 12, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    DateAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 12, 12, s2, false);
        this.initForDescribe(12, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 7;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    @Override
    String getString(int n2) throws SQLException {
        String string = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            int n3 = this.columnIndex + this.byteLength * n2;
            int n4 = ((this.rowSpaceByte[0 + n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
            int n5 = 0;
            n5 = this.rowSpaceByte[4 + n3] - 1;
            string = this.toText(n4, this.rowSpaceByte[2 + n3], this.rowSpaceByte[3 + n3], n5, this.rowSpaceByte[5 + n3] - 1, this.rowSpaceByte[6 + n3] - 1, -1, n5 < 12, null);
        }
        return string;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        Date date = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            if (this.externalType == 0) {
                date = this.statement.connection.mapDateToTimestamp ? this.getTimestamp(n2) : this.getDate(n2);
            } else {
                switch (this.externalType) {
                    case 91: {
                        return this.getDate(n2);
                    }
                    case 92: {
                        return this.getTime(n2);
                    }
                    case 93: {
                        return this.getTimestamp(n2);
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return date;
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getDATE(n2);
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        return this.getObject(n2);
    }

    static String toStr(int n2) {
        return n2 < 10 ? "0" + n2 : Integer.toString(n2);
    }
}

