/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import com.skt.Tmap.TMapView;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class DraggingAnimateThread
implements Runnable {
    private float mCurY;
    private float mCurX;
    private float mVy;
    private float mVx;
    private float mAy;
    private float mAx;
    private byte mDirY;
    private byte mDirX;
    private volatile boolean mStopped;
    private long mTime;
    private boolean mAnimateDrag = true;
    private static final float b = 0.0014f;
    private byte mPhaseOfMoving = (byte)-1;
    private int mEndZ;
    private byte mDirZ;
    private int mIntZ;
    private byte mDirIntZ;
    private float mCurZ;
    private double mMoveLat;
    private double mMoveLon;
    private int mTimeZInt;
    private int mTimeZEnd;
    private int mTimeMove;
    private float mMoveY;
    private float mMoveX;
    private boolean mNotifyListener;
    private volatile Thread mCurThread = null;
    private DraggingCallback mCallback = null;
    private int mTargetZoom = 0;
    private float mTargetRotate = 0.0f;
    private double mTargetLat = 0.0;
    private double mTargetLon = 0.0;
    private TMapView mMapView = null;
    private static BlockingQueue<Integer> queue = new ArrayBlockingQueue<Integer>(3);
    int nextWork = 0;
    boolean isWorkTest = false;
    int workType = 0;
    int WORKTYPE_NONE = 0;
    int WORKTYPE_MOVE = 1;
    int WORKTYPE_ZOOM = 2;
    ArrayList<Integer> testarry = new ArrayList();

    public DraggingAnimateThread(TMapView view) {
        this.mMapView = view;
    }

    @Override
    public void run() {
        this.mCurThread = Thread.currentThread();
        try {
            boolean conditionCheck = true;
            float newZcoor = this.mCurZ;
            int setTime = Math.abs(this.mCurZ - (float)this.mEndZ) > 2.0f ? 20 : 10;
            float gap = Math.abs(this.mCurZ - (float)this.mEndZ) / (float)setTime;
            while (!this.mStopped && conditionCheck) {
                float newYcoor;
                long sleep = 30L;
                Thread.sleep(sleep);
                long currentTime = System.currentTimeMillis();
                int datetime = (int)(currentTime - this.mTime);
                float newXcoor = this.mAnimateDrag && this.mVx > 0.0f ? this.mCurX + (float)this.mDirX * this.mVx * (float)datetime : this.mCurX;
                float f = newYcoor = this.mAnimateDrag && this.mVy > 0.0f ? this.mCurY + (float)this.mDirY * this.mVy * (float)datetime : this.mCurY;
                if (!this.mAnimateDrag) {
                    if (this.mPhaseOfMoving == 0 || this.mPhaseOfMoving == 2) {
                        byte setDir = this.mPhaseOfMoving == 2 ? this.mDirZ : this.mDirIntZ;
                        float setEnd = this.mPhaseOfMoving == 2 ? this.mEndZ : this.mIntZ;
                        if (setDir < 0) {
                            if ((newZcoor -= gap) < setEnd) {
                                newZcoor = setEnd;
                            }
                        } else if ((newZcoor += gap) > setEnd) {
                            newZcoor = setEnd;
                        }
                    } else if (this.mTimeMove > 0) {
                        newYcoor += this.mMoveY * (float)datetime / (float)this.mTimeMove;
                        if (this.mMoveX > 0.0f == (newXcoor += this.mMoveX * (float)datetime / (float)this.mTimeMove) > this.mMoveX) {
                            newXcoor = this.mMoveX;
                        }
                        if (this.mMoveY > 0.0f == newYcoor > this.mMoveY) {
                            newYcoor = this.mMoveY;
                        }
                    }
                }
                if (!this.mStopped && this.mCallback != null) {
                    if (this.mAnimateDrag || this.mPhaseOfMoving == 1) {
                        this.mCallback.drag(this.mCurX, this.mCurY, newXcoor, newYcoor, this.mNotifyListener);
                    } else {
                        this.mCallback.zoom(newZcoor, this.mNotifyListener);
                    }
                }
                this.mTime = currentTime;
                if (this.mAnimateDrag) {
                    this.mVx -= this.mAx * (float)datetime;
                    this.mVy -= this.mAy * (float)datetime;
                    this.mCurX = newXcoor;
                    this.mCurY = newYcoor;
                    conditionCheck = (double)this.mVx > 0.5 || (double)this.mVy > 0.5;
                    continue;
                }
                if (this.mPhaseOfMoving == 0) {
                    this.mCurZ = newZcoor;
                    if (!((double)Math.abs(this.mCurZ - (float)this.mIntZ) < 1.0E-7)) continue;
                    this.mCurX = 0.0f;
                    this.mCurY = 0.0f;
                    this.mPhaseOfMoving = (byte)(this.mPhaseOfMoving + 1);
                    continue;
                }
                if (this.mPhaseOfMoving == 2) {
                    this.mCurZ = newZcoor;
                    boolean bl = conditionCheck = (double)Math.abs(this.mCurZ - (float)this.mIntZ) >= 1.0E-7;
                    if ((float)this.mEndZ != this.mCurZ) continue;
                    conditionCheck = false;
                    continue;
                }
                this.mCurX = newXcoor;
                this.mCurY = newYcoor;
                if (!((double)Math.abs(this.mCurX - this.mMoveX) < 1.0E-7) || !((double)Math.abs(this.mCurY - this.mMoveY) < 1.0E-7)) continue;
                this.mPhaseOfMoving = (byte)(this.mPhaseOfMoving + 1);
                this.mCallback.setTMapPoint(this.mMoveLat, this.mMoveLon, this.mNotifyListener);
            }
            conditionCheck = true;
            while (conditionCheck && this.mCallback != null) {
                float rotationAngle;
                float abs;
                conditionCheck = false;
                if (this.mPhaseOfMoving > 0) {
                    this.mCallback.zoomEnd(this.mEndZ);
                }
                if ((abs = Math.abs(rotationAngle = Math.abs(((rotationAngle = this.mTargetRotate - this.mCallback.getRotateData()) + 360.0f) % 360.0f) < Math.abs((rotationAngle - 360.0f) % 360.0f) ? (rotationAngle + 360.0f) % 360.0f : (rotationAngle - 360.0f) % 360.0f)) > 0.0f) {
                    Thread.sleep(60L);
                    if (abs < 1.0f) {
                        this.mCallback.rotate(this.mTargetRotate);
                    } else {
                        conditionCheck = true;
                        this.mCallback.rotate((abs / 10.0f * Math.signum(rotationAngle) + this.mCallback.getRotateData()) % 360.0f);
                    }
                }
                this.workType = this.WORKTYPE_NONE;
                if (this.nextWork <= 0) continue;
                queue.put(this.nextWork);
                this.isWorkTest = false;
                --this.nextWork;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mCurThread = null;
    }

    public boolean isDraggingAnimating() {
        return this.mCurThread != null;
    }

    public void stopDraggingAnimatingSync() {
        this.mStopped = true;
        this.isWorkTest = false;
        while (this.mCurThread != null) {
            try {
                this.mCurThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void stopDraggingAnimating() {
        this.mStopped = true;
    }

    public void startDraggingZooming(float startZoom, int endzoom) {
        if (this.workType == this.WORKTYPE_NONE || this.workType == this.WORKTYPE_ZOOM) {
            this.workType = this.WORKTYPE_ZOOM;
            this.stopDraggingAnimatingSync();
            this.mTargetZoom = 0;
            this.mNotifyListener = false;
            this.mDirZ = startZoom < (float)endzoom ? (byte)1 : (byte)-1;
            this.mCurZ = startZoom;
            this.mEndZ = endzoom;
            this.mTimeZEnd = 500;
            this.mPhaseOfMoving = (byte)2;
            this.mAnimateDrag = false;
            this.mTime = System.currentTimeMillis();
            this.mStopped = false;
            this.mCallback.zoomStart(Math.round(startZoom), endzoom);
            Thread thread = new Thread((Runnable)this, "Animatable Zooming");
            thread.start();
        } else {
            ++this.nextWork;
            this.isWorkTest = true;
            HasWork c1 = new HasWork(queue, Math.round(startZoom), endzoom, this.WORKTYPE_ZOOM);
            c1.start();
        }
    }

    public void startDraggingMoving(double currentLat, double currentLon, double finishLat, double finishLon, int curZoom, int endZoom, int tileSize, float rotate, boolean notifyListener) {
        if (this.workType == this.WORKTYPE_NONE || this.workType == this.WORKTYPE_MOVE) {
            this.workType = this.WORKTYPE_MOVE;
            this.stopDraggingAnimating();
            this.mTargetLat = finishLat;
            this.mTargetLon = finishLon;
            this.mTargetZoom = endZoom;
            this.mNotifyListener = notifyListener;
            this.mCurZ = curZoom;
            this.mIntZ = curZoom;
            float moveX = (float)((this.mMapView.mapUtils.getTileNumberX(this.mIntZ, currentLon, currentLat) - this.mMapView.mapUtils.getTileNumberX(this.mIntZ, finishLon, finishLat)) * (double)tileSize);
            float moveY = (float)((this.mMapView.mapUtils.getTileNumberY(this.mIntZ, currentLon, currentLat) - this.mMapView.mapUtils.getTileNumberY(this.mIntZ, finishLon, finishLat)) * (double)tileSize);
            if (this.mMapView.map != null && this.mMapView.map.getVIndexOrder() < 0) {
                moveY = -moveY;
            }
            float rad = (float)Math.toRadians(rotate);
            this.mMoveX = (float)(Math.cos(rad) * (double)moveX - Math.sin(rad) * (double)moveY);
            this.mMoveY = (float)(Math.sin(rad) * (double)moveX + Math.cos(rad) * (double)moveY);
            this.mMoveLat = finishLat;
            this.mMoveLon = finishLon;
            this.mDirIntZ = curZoom < this.mIntZ ? (byte)1 : (byte)-1;
            this.mDirZ = this.mIntZ < endZoom ? (byte)1 : (byte)-1;
            this.mEndZ = endZoom;
            this.mTimeZInt = 600;
            this.mTimeZEnd = 500;
            this.mTimeMove = 500;
            this.mAnimateDrag = false;
            this.mPhaseOfMoving = 1;
            this.mCurX = 0.0f;
            this.mCurY = 0.0f;
            this.mTime = System.currentTimeMillis();
            this.mStopped = false;
            this.mCallback.zoomStart(curZoom, endZoom);
            Thread t = new Thread((Runnable)this, "Animatable Moving");
            t.start();
        } else {
            ++this.nextWork;
            this.isWorkTest = true;
            HasWork c1 = new HasWork(queue, currentLat, currentLon, finishLat, finishLon, curZoom, endZoom, tileSize, rotate, notifyListener, this.WORKTYPE_MOVE);
            c1.start();
        }
    }

    public void draggingStart(float velocityX, float velocityY, float startX, float startY, float endX, float endY) {
        this.stopDraggingAnimatingSync();
        this.mTargetZoom = 0;
        this.mNotifyListener = true;
        this.mVx = velocityX;
        this.mVy = velocityY;
        this.mDirX = (byte)(endX > startX ? 1 : -1);
        this.mDirY = (byte)(endY > startY ? 1 : -1);
        this.mAnimateDrag = true;
        this.mAx = this.mVx * 0.0014f;
        this.mAy = this.mVy * 0.0014f;
        this.mTime = System.currentTimeMillis();
        this.mStopped = false;
        Thread t = new Thread((Runnable)this, "Animatable dragging");
        t.start();
    }

    public void rotateStart(float rotate) {
        this.workType = this.WORKTYPE_NONE;
        this.mTargetRotate = rotate;
        if (!this.isDraggingAnimating()) {
            this.mStopped = true;
            this.mPhaseOfMoving = (byte)-1;
            Thread t = new Thread((Runnable)this, "Animatable rotate");
            t.start();
        }
    }

    public int getTargetZoomLevel() {
        return this.mTargetZoom;
    }

    public double getTargetLatitudeData() {
        return this.mTargetLat;
    }

    public double getTargetLongitudeData() {
        return this.mTargetLon;
    }

    public DraggingCallback getCallback() {
        return this.mCallback;
    }

    public void setDraggingCallback(DraggingCallback callback) {
        this.mCallback = callback;
    }

    public static interface DraggingCallback {
        public void zoom(float var1, boolean var2);

        public void zoomStart(int var1, int var2);

        public void zoomEnd(float var1);

        public float getRotateData();

        public void drag(float var1, float var2, float var3, float var4, boolean var5);

        public void rotate(float var1);

        public void setTMapPoint(double var1, double var3, boolean var5);
    }

    class HasWork
    extends Thread {
        private BlockingQueue<Integer> queue;
        private String name;
        int startZoom;
        int endzoom;
        int type;
        double currentLat;
        double currentLon;
        double finishLat;
        double finishLon;
        int tileSize;
        float rotate;
        boolean notifyListener;

        public HasWork(BlockingQueue<Integer> queue, int startZoom, int endzoom, int workType) {
            this.queue = queue;
            this.startZoom = startZoom;
            this.endzoom = endzoom;
            this.type = workType;
        }

        public HasWork(BlockingQueue<Integer> queue, double currentLat, double currentLon, double finishLat, double finishLon, int startZoom, int endzoom, int tileSize, float rotate, boolean notifyListener, int workType) {
            this.queue = queue;
            this.currentLat = currentLat;
            this.currentLon = currentLon;
            this.finishLat = finishLat;
            this.finishLon = finishLon;
            this.startZoom = startZoom;
            this.endzoom = endzoom;
            this.tileSize = tileSize;
            this.rotate = rotate;
            this.notifyListener = notifyListener;
            this.type = workType;
        }

        @Override
        public void run() {
            while (DraggingAnimateThread.this.isWorkTest) {
                try {
                    this.queue.take();
                    if (this.type == DraggingAnimateThread.this.WORKTYPE_ZOOM) {
                        DraggingAnimateThread.this.startDraggingZooming(this.startZoom, this.endzoom);
                        continue;
                    }
                    if (this.type != DraggingAnimateThread.this.WORKTYPE_MOVE) continue;
                    DraggingAnimateThread.this.startDraggingMoving(this.currentLat, this.currentLon, this.finishLat, this.finishLon, DraggingAnimateThread.this.mMapView.getZoom(), DraggingAnimateThread.this.mMapView.getZoom(), this.tileSize, this.rotate, this.notifyListener);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

