/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class LruCacheSave<Key, Value> {
    private final LinkedHashMap<Key, Value> mHashMap;
    private int mSize;
    private int mMaxSize;
    private int mPutCount;
    private int mCreateCount;
    private int mEvictionCount;
    private int mHitCount;
    private int mMissCount;

    public LruCacheSave(int maxSizeCache) {
        if (maxSizeCache <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.mMaxSize = maxSizeCache;
        this.mHashMap = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Value getCache(Key k) {
        Value value;
        if (k == null) {
            throw new NullPointerException("key == null");
        }
        LruCacheSave lruCacheSave = this;
        synchronized (lruCacheSave) {
            value = this.mHashMap.get(k);
            if (value != null) {
                ++this.mHitCount;
                return value;
            }
            ++this.mMissCount;
        }
        Value createdChace = this.createCache(k);
        if (createdChace == null) {
            return null;
        }
        LruCacheSave lruCacheSave2 = this;
        synchronized (lruCacheSave2) {
            ++this.mCreateCount;
            value = this.mHashMap.put(k, createdChace);
            if (value != null) {
                this.mHashMap.put(k, value);
            } else {
                this.mSize += this.safeSizeOfCache(k, createdChace);
            }
        }
        if (value != null) {
            this.entryRemovCache(false, k, createdChace, value);
            return value;
        }
        this.trimToSizeCache(this.mMaxSize);
        return createdChace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Value putCache(Key key, Value value) {
        Value former;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        LruCacheSave lruCacheSave = this;
        synchronized (lruCacheSave) {
            ++this.mPutCount;
            this.mSize += this.safeSizeOfCache(key, value);
            former = this.mHashMap.put(key, value);
            if (former != null) {
                this.mSize -= this.safeSizeOfCache(key, former);
            }
        }
        if (former != null) {
            this.entryRemovCache(false, key, former, value);
        }
        this.trimToSizeCache(this.mMaxSize);
        return former;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSizeCache(int maxSize) {
        while (true) {
            Value value;
            Key key;
            LruCacheSave lruCacheSave = this;
            synchronized (lruCacheSave) {
                if (this.mSize < 0 || this.mHashMap.isEmpty() && this.mSize != 0) {
                    throw new IllegalStateException(String.valueOf(this.getClass().getName()) + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.mSize <= maxSize || this.mHashMap.isEmpty()) {
                    break;
                }
                Map.Entry<Key, Value> evict = this.mHashMap.entrySet().iterator().next();
                key = evict.getKey();
                value = evict.getValue();
                this.mHashMap.remove(key);
                this.mSize -= this.safeSizeOfCache(key, value);
                ++this.mEvictionCount;
            }
            this.entryRemovCache(true, key, value, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Value remove(Key key) {
        Object former;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        LruCacheSave lruCacheSave = this;
        synchronized (lruCacheSave) {
            former = this.mHashMap.remove(key);
            if (former != null) {
                this.mSize -= this.safeSizeOfCache(key, former);
            }
        }
        if (former != null) {
            this.entryRemovCache(false, key, former, null);
        }
        return (Value)former;
    }

    protected void entryRemovCache(boolean leave, Key k, Value oldV, Value newV) {
    }

    protected Value createCache(Key key) {
        return null;
    }

    private int safeSizeOfCache(Key key, Value value) {
        int resultValue = this.cacheSizeValue(key, value);
        if (resultValue < 0) {
            throw new IllegalStateException("Negative size: " + key + "=" + value);
        }
        return resultValue;
    }

    protected int cacheSizeValue(Key key, Value value) {
        return 1024;
    }

    public final void allEvict() {
        this.trimToSizeCache(-1);
    }

    public final synchronized int getEvictionCount() {
        return this.mEvictionCount;
    }

    public final synchronized int getSize() {
        return this.mSize;
    }

    public final synchronized int getMissCount() {
        return this.mMissCount;
    }

    public final synchronized int getHitCount() {
        return this.mHitCount;
    }

    public final synchronized int getPutCount() {
        return this.mPutCount;
    }

    public final synchronized int getCreateCount() {
        return this.mCreateCount;
    }

    public final synchronized int getMaxSize() {
        return this.mMaxSize;
    }

    public final synchronized Map<Key, Value> linkedHashMap() {
        return new LinkedHashMap<Key, Value>(this.mHashMap);
    }

    public final synchronized String toString() {
        int entrance = this.mHitCount + this.mMissCount;
        int percent = entrance != 0 ? 100 * this.mHitCount / entrance : 0;
        return String.format(Locale.US, "LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.mMaxSize, this.mHitCount, this.mMissCount, percent);
    }
}

