/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jpub.runtime.Util;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class MutableArray {
    int length;
    Object[] elements;
    Datum[] datums;
    ARRAY pickled;
    boolean pickledCorrect;
    int sqlType;
    ORADataFactory factory;
    CustomDatumFactory old_factory;
    boolean isNChar;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Dec_02_19:13:26_PST_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    public MutableArray(int n2, ARRAY aRRAY, ORADataFactory oRADataFactory) {
        this.length = -1;
        this.elements = null;
        this.datums = null;
        this.pickled = aRRAY;
        this.pickledCorrect = true;
        this.isNChar = false;
        this.sqlType = n2;
        this.factory = oRADataFactory;
    }

    public MutableArray(int n2, Datum[] datumArray, ORADataFactory oRADataFactory) {
        this.sqlType = n2;
        this.factory = oRADataFactory;
        this.isNChar = false;
        this.setDatumArray(datumArray);
    }

    public MutableArray(int n2, Object[] objectArray, ORADataFactory oRADataFactory) {
        this.sqlType = n2;
        this.factory = oRADataFactory;
        this.isNChar = false;
        this.setObjectArray(objectArray);
    }

    public MutableArray(int n2, double[] dArray, ORADataFactory oRADataFactory) {
        this.sqlType = n2;
        this.factory = oRADataFactory;
        this.isNChar = false;
        this.setArray(dArray);
    }

    public MutableArray(int n2, int[] nArray, ORADataFactory oRADataFactory) {
        this.sqlType = n2;
        this.factory = oRADataFactory;
        this.isNChar = false;
        this.setArray(nArray);
    }

    public MutableArray(int n2, float[] fArray, ORADataFactory oRADataFactory) {
        this.sqlType = n2;
        this.factory = oRADataFactory;
        this.isNChar = false;
        this.setArray(fArray);
    }

    public MutableArray(int n2, short[] sArray, ORADataFactory oRADataFactory) {
        this.sqlType = n2;
        this.factory = oRADataFactory;
        this.isNChar = false;
        this.setArray(sArray);
    }

    public MutableArray(ARRAY aRRAY, int n2, CustomDatumFactory customDatumFactory) {
        this.length = -1;
        this.elements = null;
        this.datums = null;
        this.pickled = aRRAY;
        this.pickledCorrect = true;
        this.sqlType = n2;
        this.old_factory = customDatumFactory;
        this.isNChar = false;
    }

    public MutableArray(Datum[] datumArray, int n2, CustomDatumFactory customDatumFactory) {
        this.sqlType = n2;
        this.old_factory = customDatumFactory;
        this.isNChar = false;
        this.setDatumArray(datumArray);
    }

    public MutableArray(Object[] objectArray, int n2, CustomDatumFactory customDatumFactory) {
        this.sqlType = n2;
        this.old_factory = customDatumFactory;
        this.isNChar = false;
        this.setObjectArray(objectArray);
    }

    public MutableArray(double[] dArray, int n2, CustomDatumFactory customDatumFactory) {
        this.sqlType = n2;
        this.old_factory = customDatumFactory;
        this.isNChar = false;
        this.setArray(dArray);
    }

    public MutableArray(int[] nArray, int n2, CustomDatumFactory customDatumFactory) {
        this.sqlType = n2;
        this.old_factory = customDatumFactory;
        this.isNChar = false;
        this.setArray(nArray);
    }

    public MutableArray(float[] fArray, int n2, CustomDatumFactory customDatumFactory) {
        this.sqlType = n2;
        this.old_factory = customDatumFactory;
        this.isNChar = false;
        this.setArray(fArray);
    }

    public MutableArray(short[] sArray, int n2, CustomDatumFactory customDatumFactory) {
        this.sqlType = n2;
        this.old_factory = customDatumFactory;
        this.isNChar = false;
        this.setArray(sArray);
    }

    public Datum toDatum(Connection connection, String string) throws SQLException {
        if (!this.pickledCorrect) {
            this.pickled = new ARRAY(ArrayDescriptor.createDescriptor(string, connection), connection, this.getDatumArray(connection));
            this.pickledCorrect = true;
        }
        return this.pickled;
    }

    public Datum toDatum(oracle.jdbc.OracleConnection oracleConnection, String string) throws SQLException {
        return this.toDatum((Connection)oracleConnection, string);
    }

    public Datum toDatum(OracleConnection oracleConnection, String string) throws SQLException {
        return this.toDatum((Connection)oracleConnection, string);
    }

    public Object[] getOracleArray() throws SQLException {
        return this.getOracleArray(0L, Integer.MAX_VALUE);
    }

    public Object[] getOracleArray(long l2, int n2) throws SQLException {
        int n3 = this.sliceLength(l2, n2);
        if (n3 < 0) {
            return null;
        }
        Object[] objectArray = null;
        switch (this.sqlType) {
            case -13: {
                objectArray = new BFILE[n3];
                break;
            }
            case 2004: {
                objectArray = new BLOB[n3];
                break;
            }
            case 1: 
            case 12: {
                objectArray = new CHAR[n3];
                break;
            }
            case 2005: {
                objectArray = new CLOB[n3];
                break;
            }
            case 91: {
                objectArray = new DATE[n3];
                break;
            }
            case 93: {
                objectArray = new TIMESTAMP[n3];
                break;
            }
            case -101: {
                objectArray = new TIMESTAMPTZ[n3];
                break;
            }
            case -102: {
                objectArray = new TIMESTAMPLTZ[n3];
                break;
            }
            case -104: {
                objectArray = new INTERVALDS[n3];
                break;
            }
            case -103: {
                objectArray = new INTERVALYM[n3];
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = new NUMBER[n3];
                break;
            }
            case -2: {
                objectArray = new RAW[n3];
                break;
            }
            case 100: {
                objectArray = new BINARY_FLOAT[n3];
                break;
            }
            case 101: {
                objectArray = new BINARY_DOUBLE[n3];
                break;
            }
            case 0: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2007: {
                if (this.old_factory == null) {
                    objectArray = new ORAData[n3];
                    break;
                }
                objectArray = new CustomDatum[n3];
                break;
            }
            default: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 48);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return this.getOracleArray(l2, objectArray);
    }

    public Object[] getOracleArray(long l2, Object[] objectArray) throws SQLException {
        if (objectArray == null) {
            return null;
        }
        int n2 = this.sliceLength(l2, objectArray.length);
        int n3 = (int)l2;
        if (n2 != objectArray.length) {
            return null;
        }
        if (this.sqlType == 2002 || this.sqlType == 2007 || this.sqlType == 2003 || this.sqlType == 2006 || this.sqlType == 0) {
            if (this.old_factory == null) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    objectArray[i2] = this.factory.create(this.getDatumElement(n3++, null), this.sqlType);
                }
            } else {
                for (int i3 = 0; i3 < n2; ++i3) {
                    objectArray[i3] = this.old_factory.create(this.getDatumElement(n3++, null), this.sqlType);
                }
            }
        } else {
            for (int i4 = 0; i4 < n2; ++i4) {
                objectArray[i4] = this.getDatumElement(n3++, null);
            }
        }
        return objectArray;
    }

    public Object[] getOracleArray(Object[] objectArray) throws SQLException {
        return this.getOracleArray(0L, objectArray);
    }

    public Object[] getObjectArray() throws SQLException {
        return this.getObjectArray(0L, Integer.MAX_VALUE);
    }

    public Object[] getObjectArray(long l2, int n2) throws SQLException {
        Object[] objectArray;
        int n3 = this.sliceLength(l2, n2);
        if (n3 < 0) {
            return null;
        }
        switch (this.sqlType) {
            case 1: 
            case 12: {
                objectArray = new String[n3];
                break;
            }
            case 91: {
                objectArray = new Date[n3];
                break;
            }
            case 93: {
                objectArray = new Timestamp[n3];
                break;
            }
            case 2: 
            case 3: {
                objectArray = new BigDecimal[n3];
                break;
            }
            case 6: 
            case 8: {
                objectArray = new Double[n3];
                break;
            }
            case 4: 
            case 5: {
                objectArray = new Integer[n3];
                break;
            }
            case 7: {
                objectArray = new Float[n3];
                break;
            }
            case -2: {
                objectArray = (Object[])new byte[n3][];
                break;
            }
            default: {
                return this.getOracleArray(l2, n2);
            }
        }
        return this.getObjectArray(l2, objectArray);
    }

    public Object[] getObjectArray(long l2, Object[] objectArray) throws SQLException {
        if (objectArray == null) {
            return null;
        }
        int n2 = this.sliceLength(l2, objectArray.length);
        int n3 = (int)l2;
        if (n2 != objectArray.length) {
            return null;
        }
        switch (this.sqlType) {
            case -2: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 93: {
                for (int i2 = 0; i2 < n2; ++i2) {
                    objectArray[i2] = this.getObjectElement(n3++);
                }
                return objectArray;
            }
        }
        return this.getOracleArray(l2, objectArray);
    }

    public Object[] getObjectArray(Object[] objectArray) throws SQLException {
        return this.getObjectArray(0L, objectArray);
    }

    public Object getArray() throws SQLException {
        return this.getArray(0L, Integer.MAX_VALUE);
    }

    public Object getArray(long l2, int n2) throws SQLException {
        int n3 = this.sliceLength(l2, n2);
        int n4 = (int)l2;
        if (n3 < 0) {
            return null;
        }
        switch (this.sqlType) {
            case 6: 
            case 8: 
            case 101: {
                double[] dArray = new double[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    dArray[i2] = (Double)this.getObjectElement(n4++);
                }
                return dArray;
            }
            case 100: {
                float[] fArray = new float[n3];
                for (int i3 = 0; i3 < n3; ++i3) {
                    fArray[i3] = ((Float)this.getObjectElement(n4++)).floatValue();
                }
                return fArray;
            }
            case 4: {
                int[] nArray = new int[n3];
                for (int i4 = 0; i4 < n3; ++i4) {
                    nArray[i4] = (Integer)this.getObjectElement(n4++);
                }
                return nArray;
            }
            case 5: {
                short[] sArray = new short[n3];
                for (int i5 = 0; i5 < n3; ++i5) {
                    sArray[i5] = (short)((Integer)this.getObjectElement(n4++)).intValue();
                }
                return sArray;
            }
            case 7: {
                float[] fArray = new float[n3];
                for (int i6 = 0; i6 < n3; ++i6) {
                    fArray[i6] = ((Float)this.getObjectElement(n4++)).floatValue();
                }
                return fArray;
            }
        }
        return this.getObjectArray(l2, n2);
    }

    public void setOracleArray(Object[] objectArray) {
        if (this.factory == null && this.old_factory == null) {
            this.setDatumArray((Datum[])objectArray);
        } else {
            this.setObjectArray(objectArray);
        }
    }

    public void setOracleArray(Object[] objectArray, long l2) throws SQLException {
        if (this.factory == null && this.old_factory == null) {
            this.setDatumArray((Datum[])objectArray, l2);
        } else {
            this.setObjectArray(objectArray, l2);
        }
    }

    public void setObjectArray(Object[] objectArray) {
        if (objectArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(objectArray.length);
            this.elements = new Object[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                this.elements[i2] = objectArray[i2];
            }
        }
    }

    public void setObjectArray(Object[] objectArray, long l2) throws SQLException {
        if (objectArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, objectArray.length);
        int n3 = (int)l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setObjectElement(objectArray[i2], n3++);
        }
    }

    public void setArray(double[] dArray) {
        if (dArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(dArray.length);
            this.elements = new Object[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                this.elements[i2] = dArray[i2];
            }
        }
    }

    public void setArray(double[] dArray, long l2) throws SQLException {
        if (dArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, dArray.length);
        int n3 = (int)l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setObjectElement(dArray[i2], n3++);
        }
    }

    public void setArray(int[] nArray) {
        if (nArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(nArray.length);
            this.elements = new Object[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                this.elements[i2] = nArray[i2];
            }
        }
    }

    public void setArray(int[] nArray, long l2) throws SQLException {
        if (nArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, nArray.length);
        int n3 = (int)l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setObjectElement(nArray[i2], n3++);
        }
    }

    public void setArray(float[] fArray) {
        if (fArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(fArray.length);
            this.elements = new Object[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                this.elements[i2] = Float.valueOf(fArray[i2]);
            }
        }
    }

    public void setArray(float[] fArray, long l2) throws SQLException {
        if (fArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, fArray.length);
        int n3 = (int)l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setObjectElement(Float.valueOf(fArray[i2]), n3++);
        }
    }

    public void setArray(short[] sArray) {
        if (sArray == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(sArray.length);
            this.elements = new Object[this.length];
            for (int i2 = 0; i2 < this.length; ++i2) {
                this.elements[i2] = (int)sArray[i2];
            }
        }
    }

    public void setArray(short[] sArray, long l2) throws SQLException {
        if (sArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, sArray.length);
        int n3 = (int)l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setObjectElement(sArray[i2], n3++);
        }
    }

    public Object getObjectElement(long l2) throws SQLException {
        Object object = this.getLazyArray()[(int)l2];
        if (object == null) {
            if (this.old_factory == null) {
                Datum datum = this.getLazyOracleArray()[(int)l2];
                this.elements[(int)l2] = object = Util.convertToObject(datum, this.sqlType, this.factory);
                if (Util.isMutable(datum, this.factory)) {
                    this.resetOracleElement(l2);
                }
            } else {
                Datum datum = this.getLazyOracleArray()[(int)l2];
                this.elements[(int)l2] = object = Util.convertToObject(datum, this.sqlType, this.old_factory);
                if (Util.isMutable(datum, this.old_factory)) {
                    this.resetOracleElement(l2);
                }
            }
        }
        return object;
    }

    public Object getOracleElement(long l2) throws SQLException {
        if (this.factory == null && this.old_factory == null) {
            Datum datum = this.getDatumElement(l2, null);
            if (Util.isMutable(datum, this.factory)) {
                this.pickledCorrect = false;
            }
            return datum;
        }
        return this.getObjectElement(l2);
    }

    public void setObjectElement(Object object, long l2) throws SQLException {
        if (object == null) {
            this.getLazyOracleArray();
        }
        this.resetOracleElement(l2);
        this.getLazyArray()[(int)l2] = object;
    }

    public void setOracleElement(Object object, long l2) throws SQLException {
        if (this.factory == null && this.old_factory == null) {
            this.setDatumElement((Datum)object, l2);
        } else {
            this.setObjectElement(object, l2);
        }
    }

    public String getBaseTypeName() throws SQLException {
        return this.pickled.getBaseTypeName();
    }

    public int getBaseType() throws SQLException {
        return this.pickled.getBaseType();
    }

    public ArrayDescriptor getDescriptor() throws SQLException {
        return this.pickled.getDescriptor();
    }

    Datum[] getDatumArray(Connection connection) throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        if (this.datums == null) {
            return null;
        }
        Datum[] datumArray = new Datum[this.length];
        for (int i2 = 0; i2 < this.length; ++i2) {
            datumArray[i2] = this.getDatumElement(i2, connection);
        }
        return datumArray;
    }

    void setDatumArray(Datum[] datumArray) {
        if (datumArray == null) {
            this.setNullArray();
        } else {
            this.length = datumArray.length;
            this.elements = null;
            this.datums = (Datum[])datumArray.clone();
            this.pickled = null;
            this.pickledCorrect = false;
        }
    }

    void setDatumArray(Datum[] datumArray, long l2) throws SQLException {
        if (datumArray == null) {
            return;
        }
        int n2 = this.sliceLength(l2, datumArray.length);
        int n3 = (int)l2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.setDatumElement(datumArray[i2], n3++);
        }
    }

    Datum getDatumElement(long l2, Connection connection) throws SQLException {
        Datum datum = this.getLazyOracleArray()[(int)l2];
        if (datum == null) {
            Object object = this.getLazyArray()[(int)l2];
            this.datums[(int)l2] = datum = Util.convertToOracle(object, connection, this.isNChar);
        }
        return datum;
    }

    void setDatumElement(Datum datum, long l2) throws SQLException {
        this.resetElement(l2);
        this.getLazyOracleArray()[(int)l2] = datum;
        this.pickledCorrect = false;
    }

    void resetElement(long l2) throws SQLException {
        if (this.elements != null) {
            this.elements[(int)l2] = null;
        }
    }

    void setNullArray() {
        this.length = -1;
        this.elements = null;
        this.datums = null;
        this.pickled = null;
        this.pickledCorrect = false;
    }

    void setArrayGeneric(int n2) {
        this.length = n2;
        this.datums = new Datum[n2];
        this.pickled = null;
        this.pickledCorrect = false;
    }

    public int length() throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        return this.length;
    }

    public int sliceLength(long l2, int n2) throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        if (l2 < 0L) {
            return (int)l2;
        }
        return Math.min(this.length - (int)l2, n2);
    }

    void resetOracleElement(long l2) throws SQLException {
        if (this.datums != null) {
            this.datums[(int)l2] = null;
        }
        this.pickledCorrect = false;
    }

    Object[] getLazyArray() throws SQLException {
        if (this.length == -1) {
            this.getLazyOracleArray();
        }
        if (this.elements == null) {
            this.elements = new Object[this.length];
        }
        return this.elements;
    }

    Datum[] getLazyOracleArray() throws SQLException {
        if (this.datums == null) {
            if (this.pickled != null) {
                this.datums = this.pickled.getOracleArray();
                this.length = this.datums.length;
                this.pickledCorrect = true;
                if (this.elements != null) {
                    for (int i2 = 0; i2 < this.length; ++i2) {
                        if (this.elements[i2] == null) continue;
                        this.datums[i2] = null;
                        this.pickledCorrect = false;
                    }
                }
            } else if (this.length >= 0) {
                this.datums = new Datum[this.length];
            }
        }
        return this.datums;
    }

    public void setNChar() {
        this.isNChar = true;
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

