package com.example.admin.s20172285_1119_01;

import android.net.http.HttpResponseCache;
import android.os.Build;
import android.os.StrictMode;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Text;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;

public class MainActivity extends AppCompatActivity {

    private EditText etMessage;
    private Button btnSend;
    private TextView tvRecvData;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        StrictMode.setThreadPolicy(new StrictMode.ThreadPolicy.Builder()
            .detectDiskReads().detectDiskWrites().detectNetwork()
            .penaltyLog().build());

        if(Build.VERSION.SDK_INT>9){
            StrictMode.ThreadPolicy policy=
                    new StrictMode.ThreadPolicy.Builder().permitAll().build();
            StrictMode.setThreadPolicy(policy);
        }

        etMessage=(EditText)findViewById(R.id.et_message);
        btnSend=(Button)findViewById(R.id.btn_sendData);
        tvRecvData=(TextView) findViewById(R.id.tv_recvData);

        btnSend.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String sMessage =etMessage.getText().toString();
                String result = SendByHttp(sMessage);
                String[][] parsedData = jsonParserList(result);
                Toast.makeText(getApplicationContext(),result, Toast.LENGTH_SHORT).show();

                tvRecvData.setText(result);
            }
        });
    }

    private String SendByHttp(String msg) {

        if (msg == null)
            msg = "";

        String URL = "http://192.168.25.110:8080/jsonWebServer/webJson.jsp";

        DefaultHttpClient client = new DefaultHttpClient();
        try {
            HttpPost post = new HttpPost(URL + "?msg=" + msg);

            HttpParams params = client.getParams();
            HttpConnectionParams.setConnectionTimeout(params, 3000);
            HttpConnectionParams.setSoTimeout(params,3000);

            HttpResponse response = client.execute(post);
            BufferedReader bufreader = new BufferedReader(
                    new InputStreamReader(response.getEntity().getContent(),
                            "utf-8"));
            String line =null;
            String result="";

            while((line = bufreader.readLine())!=null){
                result += line;
            }

            return result;
        }catch (Exception e){
            e.printStackTrace();
            client.getConnectionManager().shutdown();
            return "";
        }
    }
    private String[][] jsonParserList(String pRecvServerPage){

        Log.i("서버에서 받은 전체 내용:", pRecvServerPage);

        try{
            JSONObject json =new JSONObject(pRecvServerPage);
            JSONArray jArr= json.getJSONArray("List");

            String[] jsonName= {"msg1","msg2","msg3"};
            String[][] parseredData = new String[jArr.length()][jsonName.length];

            for(int i =0; i< jArr.length(); i++){
                json= jArr.getJSONObject(i);

                for(int j=0; j<jsonName.length;j++){
                    parseredData[i][j] = json.getString(jsonName[j]);
                }
            }

            for(int i=0; i<parseredData.length; i++){
                Log.i("JSON을 분석한 데이터"+i+":", parseredData[i][0]);
                Log.i("JSON을 분석한 데이터"+i+":", parseredData[i][1]);
                Log.i("JSON을 분석한 데이터"+i+":", parseredData[i][2]);
            }

            return parseredData;
        }catch (JSONException e){
            e.printStackTrace();
            return null;
        }
    }
}
