/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.ClientInfoStatus;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import oracle.jdbc.OracleConnectionWrapper;
import oracle.jdbc.driver.ClassRef;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.ClientDataSupport;

public abstract class OracleConnection
extends OracleConnectionWrapper
implements oracle.jdbc.internal.OracleConnection,
ClientDataSupport {
    static int DEFAULT_ROW_PREFETCH = 10;
    static final String svptPrefix = "ORACLE_SVPT_";
    static final int BINARYSTREAM = 0;
    static final int ASCIISTREAM = 1;
    static final int UNICODESTREAM = 2;
    static final int EOJ_NON = 0;
    static final int EOJ_B_TO_A = 1;
    static final int EOJ_B_TO_U = 2;
    static final int EOJ_A_TO_U = 3;
    static final int EOJ_8_TO_A = 4;
    static final int EOJ_8_TO_U = 5;
    static final int EOJ_U_TO_A = 6;
    static final int ASCII_CHARSET = 0;
    static final int NLS_CHARSET = 1;
    static final int CHAR_TO_ASCII = 0;
    static final int CHAR_TO_UNICODE = 1;
    static final int RAW_TO_ASCII = 2;
    static final int RAW_TO_UNICODE = 3;
    static final int UNICODE_TO_CHAR = 4;
    static final int ASCII_TO_CHAR = 5;
    static final int NONE = 6;
    static final int JAVACHAR_TO_CHAR = 7;
    static final int RAW_TO_JAVACHAR = 8;
    static final int CHAR_TO_JAVACHAR = 9;
    static final int JAVACHAR_TO_ASCII = 10;
    static final int JAVACHAR_TO_UNICODE = 11;
    static final byte KOLL1FLG = 4;
    static final byte KOLL2FLG = 5;
    static final byte KOLL3FLG = 6;
    static final byte KOLL4FLG = 7;
    static final byte ALLFLAGS = -1;
    public static final byte KOLBLBLOB = 1;
    public static final byte KOLBLCLOB = 2;
    public static final byte KOLBLNLOB = 4;
    public static final byte KOLBLBFIL = 8;
    public static final byte KOLBLCFIL = 16;
    public static final byte KOLBLNFIL = 32;
    public static final byte KOLBLABS = 64;
    public static final byte KOLBLPXY = -128;
    public static final byte KOLBLPKEY = 1;
    public static final byte KOLBLIMP = 2;
    public static final byte KOLBLIDX = 4;
    public static final byte KOLBLINI = 8;
    public static final byte KOLBLEMP = 16;
    public static final byte KOLBLVIEW = 32;
    public static final byte KOLBL0FRM = 64;
    public static final byte KOLBL1FRM = -128;
    public static final byte KOLBLRDO = 1;
    public static final byte KOLBLPART = 2;
    public static final byte KOLBLCPD = 4;
    public static final byte KOLBLDIL = 8;
    public static final byte KOLBLBUF = 16;
    public static final byte KOLBLBPS = 32;
    public static final byte KOLBLMOD = 64;
    public static final byte KOLBLVAR = -128;
    public static final byte KOLBLTMP = 1;
    public static final byte KOLBLCACHE = 2;
    public static final byte KOLBLOPEN = 8;
    public static final byte KOLBLRDWR = 16;
    public static final byte KOLBLCLI = 32;
    public static final byte KOLBLVLE = 64;
    public static final byte KOLBLLCL = -128;
    static final List<String> RESERVED_NAMESPACES = Arrays.asList("SYS");
    static final Pattern SUPPORTED_NAMESPACE_PATTERN = Pattern.compile("CLIENTCONTEXT");
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Dec_02_19:13:26_PST_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    static boolean containsKey(Map map, Object object) {
        return map.get(object) != null;
    }

    @Override
    public abstract Object getClientData(Object var1);

    @Override
    public abstract Object setClientData(Object var1, Object var2);

    @Override
    public abstract Object removeClientData(Object var1);

    public abstract void setClientIdentifier(String var1) throws SQLException;

    public abstract void clearClientIdentifier(String var1) throws SQLException;

    @Override
    public boolean isValid(int n2) throws SQLException {
        return this.pingDatabase(n2) == 0;
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        this.setClientInfoInternal(string, string2, null);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        Properties properties2 = (Properties)properties.clone();
        for (String string : properties.stringPropertyNames()) {
            String string2 = properties.getProperty(string);
            this.setClientInfoInternal(string, string2, properties2);
            properties2.remove(string);
        }
    }

    void setClientInfoInternal(String string, String string2, Properties properties) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
        if (properties != null) {
            for (String string3 : properties.stringPropertyNames()) {
                hashMap.put(string3, ClientInfoStatus.REASON_UNKNOWN);
            }
        }
        SQLClientInfoException sQLClientInfoException = DatabaseError.createSQLClientInfoException(253, hashMap, null);
        sQLClientInfoException.fillInStackTrace();
        throw sQLClientInfoException;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        if (this.isClosed()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        if (this.isClosed()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return new Properties();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (clazz.isInterface()) {
            return clazz.isInstance(this);
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInterface() && clazz.isInstance(this)) {
            return (T)this;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return this;
    }

    @Override
    public Class getClassForType(String string, Map<String, Class> map) {
        ClassRef classRef;
        Class clazz = map.get(string);
        if (clazz == null && (classRef = OracleDriver.systemTypeMap.get(string)) != null) {
            clazz = classRef.get();
        }
        return clazz;
    }
}

