/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.util.Log;
import com.skt.Tmap.BizCategory;
import com.skt.Tmap.MapUtils;
import com.skt.Tmap.TMapAddressInfo;
import com.skt.Tmap.TMapAutoComplete;
import com.skt.Tmap.TMapLabelInfo;
import com.skt.Tmap.TMapPOIItem;
import com.skt.Tmap.TMapPoint;
import com.skt.Tmap.TMapPolyLine;
import com.skt.Tmap.util.HttpConnect;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TMapData {
    private static boolean blcheck = false;
    private static String baseUrl = null;
    private static String dataUrl = null;
    private double X_MIN = 124.0;
    private double X_MAX = 133.0;
    private double Y_MIN = 32.0;
    private double Y_MAX = 39.0;
    private static Map<String, TMapAutoComplete> autoName = new LinkedHashMap<String, TMapAutoComplete>();
    public static OnResponseCodeInfoCallback responseCodeListener;

    public static void setBaseUrl(String url) {
        baseUrl = url;
        dataUrl = String.valueOf(baseUrl) + "/tmap/";
    }

    private boolean checkBoundary(double lat, double lon) {
        return lat > this.Y_MIN && lat < this.Y_MAX && lon > this.X_MIN && lon < this.X_MAX;
    }

    protected static void checkApiKey(final CheckKeyResultListenerCallback result) {
        new Thread(){

            @Override
            public void run() {
                block14: {
                    StringBuilder uri = new StringBuilder();
                    if (MapUtils.mIsMapOp) {
                        uri.append(dataUrl);
                        uri.append("auth/android?format=json&appKey=");
                        uri.append(MapUtils.mApiKey);
                    } else if (MapUtils.mIsMapPickat) {
                        uri.append(dataUrl);
                        uri.append("auth/android?format=json&appKey=");
                        uri.append(MapUtils.mApiKey);
                    } else {
                        return;
                    }
                    HttpURLConnection urlCon = null;
                    try {
                        try {
                            URL url = new URL(uri.toString());
                            urlCon = (HttpURLConnection)url.openConnection();
                            urlCon.setRequestMethod("GET");
                            if (urlCon.getResponseCode() == 200) {
                                MapUtils.isVerifyApiKey = true;
                                result.onCheckKeyResult("OK");
                                break block14;
                            }
                            BufferedReader bufReader = new BufferedReader(new InputStreamReader(urlCon.getErrorStream()));
                            StringBuffer strBuffer = new StringBuffer();
                            String readLine = null;
                            while ((readLine = bufReader.readLine()) != null) {
                                strBuffer.append(readLine);
                            }
                            bufReader.close();
                            String message = null;
                            try {
                                JSONObject jsonBody = new JSONObject(strBuffer.toString());
                                JSONObject jsonError = jsonBody.getJSONObject("error");
                                message = jsonError.getString("message");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (message == null || message.equals("")) {
                                message = "ApiKey \uc778\uc99d\uc5d0 \uc2e4\ud328 \ud588\uc2b5\ub2c8\ub2e4.";
                            }
                            result.onCheckKeyResult(message);
                        }
                        catch (Exception e) {
                            result.onCheckKeyResult(e.getMessage());
                            urlCon.disconnect();
                        }
                    }
                    finally {
                        urlCon.disconnect();
                    }
                }
            }
        }.start();
    }

    public static synchronized boolean invokeStatistics(final String invokeCate, final boolean bResult) {
        blcheck = false;
        Thread thread = new Thread(){

            @Override
            public void run() {
                InputStream is = null;
                Closeable ir = null;
                String invokeResult = "fa";
                if (bResult) {
                    invokeResult = "su";
                }
                String uri = String.valueOf(dataUrl) + "invokeStatistics?version=1&format=xml&" + "invokeCate=" + invokeCate + "&invokeResult=" + invokeResult;
                HttpURLConnection urlCon = null;
                try {
                    try {
                        URL url = new URL(uri.toString());
                        urlCon = (HttpURLConnection)url.openConnection();
                        urlCon.setRequestMethod("GET");
                        urlCon.setRequestProperty("appKey", MapUtils.mApiKey);
                        if (urlCon.getResponseCode() == 200) {
                            is = urlCon.getInputStream();
                            DocumentBuilder dom = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                            Document doc = dom.parse(is);
                            NodeList list = doc.getElementsByTagName("result");
                            String result = list.item(0).getFirstChild().getNodeValue();
                            if (result.equals("success")) {
                                blcheck = true;
                            }
                            if (is != null) {
                                MapUtils.closeStream(is);
                            }
                            if (ir != null) {
                                MapUtils.closeStream(ir);
                            }
                        } else {
                            blcheck = false;
                        }
                    }
                    catch (SAXException e) {
                        blcheck = false;
                        urlCon.disconnect();
                    }
                    catch (Exception e) {
                        blcheck = false;
                        urlCon.disconnect();
                    }
                }
                finally {
                    urlCon.disconnect();
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return blcheck;
    }

    protected static void checkInitMap() {
        new Thread(){

            @Override
            public void run() {
                HttpURLConnection urlCon = null;
                try {
                    StringBuilder uri = new StringBuilder();
                    if (!MapUtils.mIsMapOp) {
                        return;
                    }
                    uri.append(dataUrl);
                    uri.append("auth/android?format=json&appKey=");
                    uri.append("MapUtils.mApiKey");
                    try {
                        URL url = new URL(uri.toString());
                        urlCon = (HttpURLConnection)url.openConnection();
                        urlCon.setRequestMethod("GET");
                        urlCon.getResponseCode();
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                    catch (IOException iOException) {}
                }
                finally {
                    urlCon.disconnect();
                }
            }
        }.start();
    }

    public static void findReverseLabel(final TMapPoint tmappoint, final int zoom, final findReverseLabelCallBack callback) {
        new Thread(){

            @Override
            public void run() {
                Document doc = null;
                TMapLabelInfo labelitem = new TMapLabelInfo();
                StringBuilder uri = new StringBuilder();
                int reqLevel = zoom < 15 ? 15 : (zoom > 19 ? 19 : zoom);
                try {
                    uri.append(dataUrl);
                    uri.append("geo/reverseLabel?version=1&format=xml&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&bizAppId=1");
                    uri.append("&centerLat=").append(tmappoint.getLatitude());
                    uri.append("&centerLon=").append(tmappoint.getLongitude());
                    uri.append("&reqLevel=").append(reqLevel);
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "findReverseLabel");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("poiInfo");
                        int i = 0;
                        while (i < list.getLength()) {
                            Element item = (Element)list.item(i);
                            labelitem.id = HttpConnect.getContentFromNode(item, "id");
                            labelitem.labelLat = HttpConnect.getContentFromNode(item, "poiLat");
                            labelitem.labelLon = HttpConnect.getContentFromNode(item, "poiLon");
                            labelitem.labelName = HttpConnect.getContentFromNode(item, "name");
                            ++i;
                        }
                    }
                    callback.onReverseLabelCallBack(labelitem);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public String convertGpsToAddress(double lat, double lon) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        if (!this.checkBoundary(lat, lon)) {
            Log.w((String)"SKT", (String)"convertGpsToAddress \uc758 \uc694\uccad \uc88c\ud45c\uac00 \ud5c8\uc6a9\ubc94\uc704\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.");
            return null;
        }
        String Address = null;
        Document doc = null;
        String strLat = URLEncoder.encode(Double.toString(lat), "UTF-8");
        String strLon = URLEncoder.encode(Double.toString(lon), "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("geo/reversegeocoding?version=1&coordType=WGS84GEO&addressType=A02&format=xml");
        uri.append("&lat=").append(strLat);
        uri.append("&lon=").append(strLon);
        doc = TMapData.getDownloadFromUrl(uri.toString(), "convertGpsToAddress");
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("addressInfo");
            int i = 0;
            while (i < list.getLength()) {
                Element item = (Element)list.item(i);
                Address = HttpConnect.getContentFromNode(item, "fullAddress");
                ++i;
            }
        } else {
            Address = null;
        }
        return Address;
    }

    public void convertGpsToAddress(final double lat, final double lon, final ConvertGPSToAddressListenerCallback addressListener) {
        if (!this.checkBoundary(lat, lon)) {
            Log.w((String)"SKT", (String)"convertGpsToAddress \uc758 \uc694\uccad \uc88c\ud45c\uac00 \ud5c8\uc6a9\ubc94\uc704\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.");
            addressListener.onConvertToGPSToAddress(null);
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    String Address = null;
                    Document doc = null;
                    String strLat = URLEncoder.encode(Double.toString(lat), "UTF-8");
                    String strLon = URLEncoder.encode(Double.toString(lon), "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("geo/reversegeocoding?version=1&coordType=WGS84GEO&addressType=A02&format=xml");
                    uri.append("&lat=").append(strLat);
                    uri.append("&lon=").append(strLon);
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "convertGpsToAddress");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("addressInfo");
                        int i = 0;
                        while (i < list.getLength()) {
                            Element item = (Element)list.item(i);
                            Address = HttpConnect.getContentFromNode(item, "fullAddress");
                            ++i;
                        }
                    } else {
                        Address = null;
                    }
                    addressListener.onConvertToGPSToAddress(Address);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public TMapAddressInfo reverseGeocoding(double lat, double lon, String addressType) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        if (!this.checkBoundary(lat, lon)) {
            Log.w((String)"SKT", (String)"reverseGeocoding \uc758 \uc694\uccad \uc88c\ud45c\uac00 \ud5c8\uc6a9\ubc94\uc704\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.");
            return null;
        }
        Document doc = null;
        TMapAddressInfo info = new TMapAddressInfo();
        String strLat = URLEncoder.encode(Double.toString(lat), "UTF-8");
        String strLon = URLEncoder.encode(Double.toString(lon), "UTF-8");
        String strType = URLEncoder.encode(addressType, "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("geo/reversegeocoding?version=1&coordType=WGS84GEO&format=xml");
        uri.append("&lat=").append(strLat);
        uri.append("&lon=").append(strLon);
        uri.append("&addressType=").append(strType);
        doc = TMapData.getDownloadFromUrl(uri.toString(), "reverseGeocoding");
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("addressInfo");
            int i = 0;
            while (i < list.getLength()) {
                Element item = (Element)list.item(i);
                info.strFullAddress = HttpConnect.getContentFromNode(item, "fullAddress");
                info.strAddressType = HttpConnect.getContentFromNode(item, "addressType");
                info.strCity_do = HttpConnect.getContentFromNode(item, "city_do");
                info.strGu_gun = HttpConnect.getContentFromNode(item, "gu_gun");
                info.strLegalDong = HttpConnect.getContentFromNode(item, "legalDong");
                info.strLegalDongCode = HttpConnect.getContentFromNode(item, "legalDongCode");
                info.strRi = HttpConnect.getContentFromNode(item, "ri");
                info.strRoadName = HttpConnect.getContentFromNode(item, "roadName");
                info.strBuildingIndex = HttpConnect.getContentFromNode(item, "buildingIndex");
                info.strBuildingName = HttpConnect.getContentFromNode(item, "buildingName");
                info.strMappingDistance = HttpConnect.getContentFromNode(item, "mappingDistance");
                info.strRoadCode = HttpConnect.getContentFromNode(item, "roadCode");
                info.strBunji = HttpConnect.getContentFromNode(item, "bunji");
                ++i;
            }
        } else {
            info = null;
        }
        return info;
    }

    public void reverseGeocoding(final double lat, final double lon, final String addressType, final reverseGeocodingListenerCallback addressListener) {
        if (!this.checkBoundary(lat, lon)) {
            Log.w((String)"SKT", (String)"reverseGeocoding \uc758 \uc694\uccad \uc88c\ud45c\uac00 \ud5c8\uc6a9\ubc94\uc704\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.");
            addressListener.onReverseGeocoding(null);
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    TMapAddressInfo info = new TMapAddressInfo();
                    Document doc = null;
                    String strLat = URLEncoder.encode(Double.toString(lat), "UTF-8");
                    String strLon = URLEncoder.encode(Double.toString(lon), "UTF-8");
                    String strType = URLEncoder.encode(addressType, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("geo/reversegeocoding?version=1&coordType=WGS84GEO&format=xml");
                    uri.append("&lat=").append(strLat);
                    uri.append("&lon=").append(strLon);
                    uri.append("&addressType=").append(strType);
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "reverseGeocoding");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("addressInfo");
                        int i = 0;
                        while (i < list.getLength()) {
                            Element item = (Element)list.item(i);
                            info.strFullAddress = HttpConnect.getContentFromNode(item, "fullAddress");
                            info.strAddressType = HttpConnect.getContentFromNode(item, "addressType");
                            info.strCity_do = HttpConnect.getContentFromNode(item, "city_do");
                            info.strGu_gun = HttpConnect.getContentFromNode(item, "gu_gun");
                            info.strLegalDong = HttpConnect.getContentFromNode(item, "legalDong");
                            info.strLegalDongCode = HttpConnect.getContentFromNode(item, "legalDongCode");
                            info.strRi = HttpConnect.getContentFromNode(item, "ri");
                            info.strRoadName = HttpConnect.getContentFromNode(item, "roadName");
                            info.strBuildingIndex = HttpConnect.getContentFromNode(item, "buildingIndex");
                            info.strBuildingName = HttpConnect.getContentFromNode(item, "buildingName");
                            info.strMappingDistance = HttpConnect.getContentFromNode(item, "mappingDistance");
                            info.strRoadCode = HttpConnect.getContentFromNode(item, "roadCode");
                            info.strBunji = HttpConnect.getContentFromNode(item, "bunji");
                            ++i;
                        }
                    } else {
                        info = null;
                    }
                    addressListener.onReverseGeocoding(info);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public ArrayList<TMapPOIItem> findAllPOI(String data) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
        String encodedData = URLEncoder.encode(data, "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=xml");
        uri.append("&searchKeyword=").append(encodedData);
        doc = TMapData.getDownloadFromUrl(uri.toString(), "findAllPOI");
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("poi");
            if (list.getLength() < 1) {
                allpoi = null;
            } else {
                int i = 0;
                while (i < list.getLength()) {
                    TMapPOIItem poiitem = new TMapPOIItem();
                    Element item = (Element)list.item(i);
                    poiitem.id = HttpConnect.getContentFromNode(item, "id");
                    poiitem.name = HttpConnect.getContentFromNode(item, "name");
                    poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                    poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                    poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                    poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                    poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                    poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                    poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                    poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                    poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                    poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                    poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                    poiitem.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                    poiitem.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                    poiitem.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                    poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                    poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                    poiitem.detailInfoFlag = HttpConnect.getContentFromNode(item, "detailInfoFlag");
                    poiitem.desc = HttpConnect.getContentFromNode(item, "desc");
                    poiitem.distance = HttpConnect.getContentFromNode(item, "distance");
                    poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                    allpoi.add(poiitem);
                    ++i;
                }
            }
        } else {
            return null;
        }
        return allpoi;
    }

    public ArrayList<TMapPOIItem> findAllPOI(String data, int nSearchCount) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
        String encodedData = URLEncoder.encode(data, "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=xml");
        uri.append("&searchKeyword=").append(encodedData);
        if (nSearchCount <= 0) {
            nSearchCount = 20;
        } else if (nSearchCount > 200) {
            nSearchCount = 200;
        }
        uri.append("&count=").append(nSearchCount);
        doc = TMapData.getDownloadFromUrl(uri.toString(), "findAllPOI");
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("poi");
            int i = 0;
            while (i < list.getLength()) {
                TMapPOIItem poiitem = new TMapPOIItem();
                Element item = (Element)list.item(i);
                poiitem.id = HttpConnect.getContentFromNode(item, "id");
                poiitem.name = HttpConnect.getContentFromNode(item, "name");
                poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                poiitem.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                poiitem.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                poiitem.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                poiitem.detailInfoFlag = HttpConnect.getContentFromNode(item, "detailInfoFlag");
                poiitem.desc = HttpConnect.getContentFromNode(item, "desc");
                poiitem.distance = HttpConnect.getContentFromNode(item, "distance");
                poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                allpoi.add(poiitem);
                ++i;
            }
        }
        return allpoi;
    }

    public void findAllPOI(final String data, final FindAllPOIListenerCallback findAllPoiListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
                    String encodedData = URLEncoder.encode(data, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=xml");
                    uri.append("&searchKeyword=").append(encodedData);
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "findAllPOI");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("poi");
                        int i = 0;
                        while (i < list.getLength()) {
                            TMapPOIItem poiitem = new TMapPOIItem();
                            Element item = (Element)list.item(i);
                            poiitem.id = HttpConnect.getContentFromNode(item, "id");
                            poiitem.name = HttpConnect.getContentFromNode(item, "name");
                            poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                            poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                            poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                            poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                            poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                            poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                            poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                            poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                            poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                            poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                            poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                            poiitem.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                            poiitem.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                            poiitem.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                            poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                            poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                            poiitem.detailInfoFlag = HttpConnect.getContentFromNode(item, "detailInfoFlag");
                            poiitem.desc = HttpConnect.getContentFromNode(item, "desc");
                            poiitem.distance = HttpConnect.getContentFromNode(item, "distance");
                            poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                            allpoi.add(poiitem);
                            ++i;
                        }
                    }
                    findAllPoiListener.onFindAllPOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void findAllPOI(final String data, final int nSearchCount, final FindAllPOIListenerCallback findAllPoiListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
                    String encodedData = URLEncoder.encode(data, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=xml");
                    uri.append("&searchKeyword=").append(encodedData);
                    if (nSearchCount <= 0) {
                        uri.append("&count=").append(20);
                    } else if (nSearchCount > 200) {
                        uri.append("&count=").append(200);
                    } else {
                        uri.append("&count=").append(nSearchCount);
                    }
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "findAllPOI");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("poi");
                        int i = 0;
                        while (i < list.getLength()) {
                            TMapPOIItem poiitem = new TMapPOIItem();
                            Element item = (Element)list.item(i);
                            poiitem.id = HttpConnect.getContentFromNode(item, "id");
                            poiitem.name = HttpConnect.getContentFromNode(item, "name");
                            poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                            poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                            poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                            poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                            poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                            poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                            poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                            poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                            poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                            poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                            poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                            poiitem.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                            poiitem.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                            poiitem.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                            poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                            poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                            poiitem.detailInfoFlag = HttpConnect.getContentFromNode(item, "detailInfoFlag");
                            poiitem.desc = HttpConnect.getContentFromNode(item, "desc");
                            poiitem.distance = HttpConnect.getContentFromNode(item, "distance");
                            poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                            allpoi.add(poiitem);
                            ++i;
                        }
                    }
                    findAllPoiListener.onFindAllPOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public ArrayList<TMapPOIItem> findAddressPOI(String data) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
        String encodedData = URLEncoder.encode(data, "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=xml");
        uri.append("&searchKeyword=").append(encodedData);
        doc = TMapData.getDownloadFromUrl(uri.toString(), "findAddressPOI");
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("poi");
            if (list.getLength() < 1) {
                allpoi = null;
            } else {
                int i = 0;
                while (i < list.getLength()) {
                    TMapPOIItem poiitem = new TMapPOIItem();
                    Element item = (Element)list.item(i);
                    poiitem.id = HttpConnect.getContentFromNode(item, "id");
                    poiitem.name = HttpConnect.getContentFromNode(item, "name");
                    poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                    poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                    poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                    poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                    poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                    poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                    poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                    poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                    poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                    poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                    poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                    poiitem.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                    poiitem.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                    poiitem.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                    poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                    poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                    poiitem.detailInfoFlag = HttpConnect.getContentFromNode(item, "detailInfoFlag");
                    poiitem.desc = HttpConnect.getContentFromNode(item, "desc");
                    poiitem.distance = HttpConnect.getContentFromNode(item, "distance");
                    poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                    allpoi.add(poiitem);
                    ++i;
                }
            }
        } else {
            allpoi = null;
        }
        return allpoi;
    }

    public ArrayList<TMapPOIItem> findAddressPOI(String data, int nSearchCount) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
        String encodedData = URLEncoder.encode(data, "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=xml");
        uri.append("&searchKeyword=").append(encodedData);
        if (nSearchCount <= 0) {
            nSearchCount = 20;
        } else if (nSearchCount > 200) {
            nSearchCount = 200;
        }
        uri.append("&count=").append(nSearchCount);
        doc = TMapData.getDownloadFromUrl(uri.toString(), "findAddressPOI");
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("poi");
            if (list.getLength() < 1) {
                allpoi = null;
            } else {
                int i = 0;
                while (i < list.getLength()) {
                    TMapPOIItem poiitem = new TMapPOIItem();
                    Element item = (Element)list.item(i);
                    poiitem.id = HttpConnect.getContentFromNode(item, "id");
                    poiitem.name = HttpConnect.getContentFromNode(item, "name");
                    poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                    poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                    poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                    poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                    poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                    poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                    poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                    poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                    poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                    poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                    poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                    poiitem.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                    poiitem.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                    poiitem.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                    poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                    poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                    poiitem.detailInfoFlag = HttpConnect.getContentFromNode(item, "detailInfoFlag");
                    poiitem.desc = HttpConnect.getContentFromNode(item, "desc");
                    poiitem.distance = HttpConnect.getContentFromNode(item, "distance");
                    poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                    allpoi.add(poiitem);
                    ++i;
                }
            }
        } else {
            allpoi = null;
        }
        return allpoi;
    }

    public void findAddressPOI(final String data, final FindAddressPOIListenerCallback findAddressPOIListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
                    String encodedData = URLEncoder.encode(data, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=xml");
                    uri.append("&searchKeyword=").append(encodedData);
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "findAddressPOI");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("poi");
                        int i = 0;
                        while (i < list.getLength()) {
                            TMapPOIItem poiitem = new TMapPOIItem();
                            Element item = (Element)list.item(i);
                            poiitem.id = HttpConnect.getContentFromNode(item, "id");
                            poiitem.name = HttpConnect.getContentFromNode(item, "name");
                            poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                            poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                            poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                            poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                            poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                            poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                            poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                            poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                            poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                            poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                            poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                            poiitem.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                            poiitem.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                            poiitem.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                            poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                            poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                            poiitem.detailInfoFlag = HttpConnect.getContentFromNode(item, "detailInfoFlag");
                            poiitem.desc = HttpConnect.getContentFromNode(item, "desc");
                            poiitem.distance = HttpConnect.getContentFromNode(item, "distance");
                            poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                            allpoi.add(poiitem);
                            ++i;
                        }
                    } else {
                        allpoi = null;
                    }
                    findAddressPOIListener.onFindAddressPOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void findAddressPOI(final String data, final int nSearchCount, final FindAddressPOIListenerCallback findAddressPOIListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
                    String encodedData = URLEncoder.encode(data, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=xml");
                    uri.append("&searchKeyword=").append(encodedData);
                    if (nSearchCount <= 0) {
                        uri.append("&count=").append(20);
                    } else if (nSearchCount > 200) {
                        uri.append("&count=").append(200);
                    } else {
                        uri.append("&count=").append(nSearchCount);
                    }
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "findAddressPOI");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("poi");
                        int i = 0;
                        while (i < list.getLength()) {
                            TMapPOIItem poiitem = new TMapPOIItem();
                            Element item = (Element)list.item(i);
                            poiitem.id = HttpConnect.getContentFromNode(item, "id");
                            poiitem.name = HttpConnect.getContentFromNode(item, "name");
                            poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                            poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                            poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                            poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                            poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                            poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                            poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                            poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                            poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                            poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                            poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                            poiitem.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                            poiitem.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                            poiitem.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                            poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                            poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                            poiitem.detailInfoFlag = HttpConnect.getContentFromNode(item, "detailInfoFlag");
                            poiitem.desc = HttpConnect.getContentFromNode(item, "desc");
                            poiitem.distance = HttpConnect.getContentFromNode(item, "distance");
                            poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                            allpoi.add(poiitem);
                            ++i;
                        }
                    } else {
                        allpoi = null;
                    }
                    findAddressPOIListener.onFindAddressPOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public ArrayList<TMapPOIItem> findTitlePOI(String data) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
        String encodedData = URLEncoder.encode(data, "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=xml");
        uri.append("&searchKeyword=").append(encodedData);
        doc = TMapData.getDownloadFromUrl(uri.toString(), "findTitlePOI");
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("poi");
            int i = 0;
            while (i < list.getLength()) {
                TMapPOIItem poiitem = new TMapPOIItem();
                Element item = (Element)list.item(i);
                poiitem.id = HttpConnect.getContentFromNode(item, "id");
                poiitem.name = HttpConnect.getContentFromNode(item, "name");
                poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                poiitem.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                poiitem.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                poiitem.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                poiitem.detailInfoFlag = HttpConnect.getContentFromNode(item, "detailInfoFlag");
                poiitem.desc = HttpConnect.getContentFromNode(item, "desc");
                poiitem.distance = HttpConnect.getContentFromNode(item, "distance");
                poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                allpoi.add(poiitem);
                ++i;
            }
        } else {
            allpoi = null;
        }
        return allpoi;
    }

    public ArrayList<TMapPOIItem> findTitlePOI(String data, int nSearchCount) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
        String encodedData = URLEncoder.encode(data, "UTF-8");
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=xml");
        uri.append("&searchKeyword=").append(encodedData);
        if (nSearchCount <= 0) {
            nSearchCount = 20;
        } else if (nSearchCount > 200) {
            nSearchCount = 200;
        }
        uri.append("&count=").append(nSearchCount);
        doc = TMapData.getDownloadFromUrl(uri.toString(), "findTitlePOI");
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("poi");
            int i = 0;
            while (i < list.getLength()) {
                TMapPOIItem poiitem = new TMapPOIItem();
                Element item = (Element)list.item(i);
                poiitem.id = HttpConnect.getContentFromNode(item, "id");
                poiitem.name = HttpConnect.getContentFromNode(item, "name");
                poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                poiitem.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                poiitem.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                poiitem.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                poiitem.detailInfoFlag = HttpConnect.getContentFromNode(item, "detailInfoFlag");
                poiitem.desc = HttpConnect.getContentFromNode(item, "desc");
                poiitem.distance = HttpConnect.getContentFromNode(item, "distance");
                poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                allpoi.add(poiitem);
                ++i;
            }
        } else {
            allpoi = null;
        }
        return allpoi;
    }

    public void findTitlePOI(final String data, final FindTitlePOIListenerCallback findTitlePOIListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
                    String encodedData = URLEncoder.encode(data, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=xml");
                    uri.append("&searchKeyword=").append(encodedData);
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "findTitlePOI");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("poi");
                        int i = 0;
                        while (i < list.getLength()) {
                            TMapPOIItem poiitem = new TMapPOIItem();
                            Element item = (Element)list.item(i);
                            poiitem.id = HttpConnect.getContentFromNode(item, "id");
                            poiitem.name = HttpConnect.getContentFromNode(item, "name");
                            poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                            poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                            poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                            poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                            poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                            poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                            poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                            poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                            poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                            poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                            poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                            poiitem.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                            poiitem.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                            poiitem.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                            poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                            poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                            poiitem.detailInfoFlag = HttpConnect.getContentFromNode(item, "detailInfoFlag");
                            poiitem.desc = HttpConnect.getContentFromNode(item, "desc");
                            poiitem.distance = HttpConnect.getContentFromNode(item, "distance");
                            poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                            allpoi.add(poiitem);
                            ++i;
                        }
                    }
                    findTitlePOIListener.onFindTitlePOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void findTitlePOI(final String data, final int nSearchCount, final FindTitlePOIListenerCallback findTitlePOIListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
                    String encodedData = URLEncoder.encode(data, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois?version=1&searchType=all&resCoordType=WGS84GEO&format=xml");
                    uri.append("&searchKeyword=").append(encodedData);
                    if (nSearchCount <= 0) {
                        uri.append("&count=").append(20);
                    } else if (nSearchCount > 200) {
                        uri.append("&count=").append(200);
                    } else {
                        uri.append("&count=").append(nSearchCount);
                    }
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "findTitlePOI");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("poi");
                        int i = 0;
                        while (i < list.getLength()) {
                            TMapPOIItem poiitem = new TMapPOIItem();
                            Element item = (Element)list.item(i);
                            poiitem.id = HttpConnect.getContentFromNode(item, "id");
                            poiitem.name = HttpConnect.getContentFromNode(item, "name");
                            poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                            poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                            poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                            poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                            poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                            poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                            poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                            poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                            poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                            poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                            poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                            poiitem.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                            poiitem.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                            poiitem.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                            poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                            poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                            poiitem.detailInfoFlag = HttpConnect.getContentFromNode(item, "detailInfoFlag");
                            poiitem.desc = HttpConnect.getContentFromNode(item, "desc");
                            poiitem.distance = HttpConnect.getContentFromNode(item, "distance");
                            poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                            allpoi.add(poiitem);
                            ++i;
                        }
                    } else {
                        allpoi = null;
                    }
                    findTitlePOIListener.onFindTitlePOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public ArrayList<TMapPOIItem> findAroundNamePOI(TMapPoint tmappoint, String categoryName) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois/search/around?version=1&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&searchType=name&format=xml");
        String utf8name = URLEncoder.encode(categoryName, "UTF-8");
        uri.append("&categories=").append(utf8name);
        uri.append("&centerLat=").append(tmappoint.getLatitude());
        uri.append("&centerLon=").append(tmappoint.getLongitude());
        doc = TMapData.getDownloadFromUrl(uri.toString(), "findAroundNamePOI");
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("poi");
            int i = 0;
            while (i < list.getLength()) {
                TMapPOIItem poiitem = new TMapPOIItem();
                Element item = (Element)list.item(i);
                poiitem.id = HttpConnect.getContentFromNode(item, "id");
                poiitem.name = HttpConnect.getContentFromNode(item, "name");
                poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                poiitem.roadName = HttpConnect.getContentFromNode(item, "roadName");
                poiitem.buildingNo1 = HttpConnect.getContentFromNode(item, "buildingNo1");
                poiitem.buildingNo2 = HttpConnect.getContentFromNode(item, "buildingNo2");
                poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                poiitem.merchanFlag = HttpConnect.getContentFromNode(item, "merchanFlag");
                poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                allpoi.add(poiitem);
                ++i;
            }
        }
        return allpoi;
    }

    public ArrayList<TMapPOIItem> findAroundNamePOI(TMapPoint tmappoint, String categoryName, int nRadius, int nSearchCount) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois/search/around?version=1&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&searchType=name&format=xml");
        String utf8name = URLEncoder.encode(categoryName, "UTF-8");
        uri.append("&categories=").append(utf8name);
        uri.append("&centerLat=").append(tmappoint.getLatitude());
        uri.append("&centerLon=").append(tmappoint.getLongitude());
        if (nRadius < 1) {
            nRadius = 1;
        } else if (nRadius > 33) {
            nRadius = 33;
        }
        uri.append("&radius=").append(nRadius);
        if (nSearchCount <= 0) {
            nSearchCount = 20;
        } else if (nSearchCount > 200) {
            nSearchCount = 200;
        }
        uri.append("&count=").append(nSearchCount);
        doc = TMapData.getDownloadFromUrl(uri.toString(), "findAroundNamePOI");
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("poi");
            if (list.getLength() == 0) {
                allpoi = null;
            } else {
                int i = 0;
                while (i < list.getLength()) {
                    TMapPOIItem poiitem = new TMapPOIItem();
                    Element item = (Element)list.item(i);
                    poiitem.id = HttpConnect.getContentFromNode(item, "id");
                    poiitem.name = HttpConnect.getContentFromNode(item, "name");
                    poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                    poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                    poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                    poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                    poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                    poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                    poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                    poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                    poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                    poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                    poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                    poiitem.roadName = HttpConnect.getContentFromNode(item, "roadName");
                    poiitem.buildingNo1 = HttpConnect.getContentFromNode(item, "buildingNo1");
                    poiitem.buildingNo2 = HttpConnect.getContentFromNode(item, "buildingNo2");
                    poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                    poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                    poiitem.merchanFlag = HttpConnect.getContentFromNode(item, "merchanFlag");
                    poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                    allpoi.add(poiitem);
                    ++i;
                }
            }
        }
        return allpoi;
    }

    public void findAroundNamePOI(final TMapPoint tmappoint, final String categoryName, final FindAroundNamePOIListenerCallback findAroundNamePoiListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois/search/around?version=1&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                    String utf8name = URLEncoder.encode(categoryName, "UTF-8");
                    uri.append("&categories=").append(utf8name);
                    uri.append("&centerLat=").append(tmappoint.getLatitude());
                    uri.append("&centerLon=").append(tmappoint.getLongitude());
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "findAroundNamePOI");
                    if (doc == null) {
                        allpoi = null;
                    } else {
                        NodeList list = doc.getElementsByTagName("poi");
                        if (list.getLength() < 1) {
                            allpoi = null;
                        } else {
                            int i = 0;
                            while (i < list.getLength()) {
                                TMapPOIItem poiitem = new TMapPOIItem();
                                Element item = (Element)list.item(i);
                                poiitem.id = HttpConnect.getContentFromNode(item, "id");
                                poiitem.name = HttpConnect.getContentFromNode(item, "name");
                                poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                                poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                                poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                                poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                                poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                                poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                                poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                                poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                                poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                                poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                                poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                                poiitem.roadName = HttpConnect.getContentFromNode(item, "roadName");
                                poiitem.buildingNo1 = HttpConnect.getContentFromNode(item, "buildingNo1");
                                poiitem.buildingNo2 = HttpConnect.getContentFromNode(item, "buildingNo2");
                                poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                                poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                                poiitem.merchanFlag = HttpConnect.getContentFromNode(item, "merchanFlag");
                                poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                                allpoi.add(poiitem);
                                ++i;
                            }
                        }
                    }
                    findAroundNamePoiListener.onFindAroundNamePOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void findAroundNamePOI(final TMapPoint tmappoint, final String categoryName, final int nRadius, final int nSearchCount, final FindAroundNamePOIListenerCallback findAroundNamePoiListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois/search/around?version=1&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                    String utf8name = URLEncoder.encode(categoryName, "UTF-8");
                    uri.append("&categories=").append(utf8name);
                    uri.append("&centerLat=").append(tmappoint.getLatitude());
                    uri.append("&centerLon=").append(tmappoint.getLongitude());
                    if (nRadius < 0) {
                        uri.append("&radius=").append(1);
                    } else if (nRadius > 33) {
                        uri.append("&radius=").append(33);
                    } else {
                        uri.append("&radius=").append(nRadius);
                    }
                    if (nSearchCount <= 0) {
                        uri.append("&count=").append(20);
                    } else if (nSearchCount > 200) {
                        uri.append("&count=").append(200);
                    } else {
                        uri.append("&count=").append(nSearchCount);
                    }
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "findAroundNamePOI");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("poi");
                        if (list.getLength() < 1) {
                            allpoi = null;
                        } else {
                            int i = 0;
                            while (i < list.getLength()) {
                                TMapPOIItem poiitem = new TMapPOIItem();
                                Element item = (Element)list.item(i);
                                poiitem.id = HttpConnect.getContentFromNode(item, "id");
                                poiitem.name = HttpConnect.getContentFromNode(item, "name");
                                poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                                poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                                poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                                poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                                poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                                poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                                poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                                poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                                poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                                poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                                poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                                poiitem.roadName = HttpConnect.getContentFromNode(item, "roadName");
                                poiitem.buildingNo1 = HttpConnect.getContentFromNode(item, "buildingNo1");
                                poiitem.buildingNo2 = HttpConnect.getContentFromNode(item, "buildingNo2");
                                poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                                poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                                poiitem.merchanFlag = HttpConnect.getContentFromNode(item, "merchanFlag");
                                poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                                allpoi.add(poiitem);
                                ++i;
                            }
                        }
                    } else {
                        allpoi = null;
                    }
                    findAroundNamePoiListener.onFindAroundNamePOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void findAroundNamePOI(final TMapPoint tmappoint, final String codeType, final String multiPoint, final String categoryName, final int nRadius, final int nSearchCount, final FindAroundNamePOIListenerCallback findAroundNamePoiListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois/search/around?version=1&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                    uri.append("&codeType=").append(codeType);
                    uri.append("&multiPoint=").append(multiPoint);
                    String utf8name = URLEncoder.encode(categoryName, "UTF-8");
                    uri.append("&categories=").append(utf8name);
                    uri.append("&centerLat=").append(tmappoint.getLatitude());
                    uri.append("&centerLon=").append(tmappoint.getLongitude());
                    if (nRadius < 0) {
                        uri.append("&radius=").append(1);
                    } else if (nRadius > 33) {
                        uri.append("&radius=").append(33);
                    } else {
                        uri.append("&radius=").append(nRadius);
                    }
                    if (nSearchCount <= 0) {
                        uri.append("&count=").append(20);
                    } else if (nSearchCount > 200) {
                        uri.append("&count=").append(200);
                    } else {
                        uri.append("&count=").append(nSearchCount);
                    }
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "findAroundNamePOI");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("poi");
                        if (list.getLength() < 1) {
                            allpoi = null;
                        } else {
                            int i = 0;
                            while (i < list.getLength()) {
                                TMapPOIItem poiitem = new TMapPOIItem();
                                Element item = (Element)list.item(i);
                                poiitem.id = HttpConnect.getContentFromNode(item, "id");
                                poiitem.name = HttpConnect.getContentFromNode(item, "name");
                                poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                                poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                                poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                                poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                                poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                                poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                                poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                                poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                                poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                                poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                                poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                                poiitem.roadName = HttpConnect.getContentFromNode(item, "roadName");
                                poiitem.buildingNo1 = HttpConnect.getContentFromNode(item, "buildingNo1");
                                poiitem.buildingNo2 = HttpConnect.getContentFromNode(item, "buildingNo2");
                                poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                                poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                                poiitem.merchanFlag = HttpConnect.getContentFromNode(item, "merchanFlag");
                                poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                                allpoi.add(poiitem);
                                ++i;
                            }
                        }
                    } else {
                        allpoi = null;
                    }
                    findAroundNamePoiListener.onFindAroundNamePOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public ArrayList<BizCategory> getBizCategory() throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        ArrayList<BizCategory> bizcategory = new ArrayList<BizCategory>();
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("poi/categories?version=1&format=xml");
        doc = TMapData.getDownloadFromUrl(uri.toString(), "getBizCategory");
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("bizCategory");
            int i = 0;
            while (i < list.getLength()) {
                BizCategory category = new BizCategory();
                Element item = (Element)list.item(i);
                category.upperBizCode = HttpConnect.getContentFromNode(item, "upperBizCode");
                category.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                category.middleBizCode = HttpConnect.getContentFromNode(item, "middleBizCode");
                category.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                bizcategory.add(category);
                ++i;
            }
        }
        return bizcategory;
    }

    public void getBizCategory(final BizCategoryListenerCallback BizCategoryListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    ArrayList<BizCategory> bizcategory = new ArrayList<BizCategory>();
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("poi/categories?version=1&format=xml");
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "getBizCategory");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("bizCategory");
                        int i = 0;
                        while (i < list.getLength()) {
                            BizCategory category = new BizCategory();
                            Element item = (Element)list.item(i);
                            category.upperBizCode = HttpConnect.getContentFromNode(item, "upperBizCode");
                            category.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                            category.middleBizCode = HttpConnect.getContentFromNode(item, "middleBizCode");
                            category.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                            bizcategory.add(category);
                            ++i;
                        }
                    }
                    BizCategoryListener.onGetBizCategory(bizcategory);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void getBizCategory(final String codeType, final BizCategoryListenerCallback BizCategoryListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    ArrayList<BizCategory> bizcategory = new ArrayList<BizCategory>();
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("poi/categories?version=1&format=xml");
                    uri.append("&codeType=").append(codeType);
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "getBizCategory");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("bizCategory");
                        int i = 0;
                        while (i < list.getLength()) {
                            BizCategory category = new BizCategory();
                            Element item = (Element)list.item(i);
                            category.upperBizCode = HttpConnect.getContentFromNode(item, "upperBizCode");
                            category.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                            category.middleBizCode = HttpConnect.getContentFromNode(item, "middleBizCode");
                            category.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                            category.lowerBizCode = HttpConnect.getContentFromNode(item, "lowerBizCode");
                            category.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                            bizcategory.add(category);
                            ++i;
                        }
                    }
                    BizCategoryListener.onGetBizCategory(bizcategory);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public TMapPolyLine findPathData(TMapPoint startpoint, TMapPoint endpoint) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        TMapPolyLine polyline = new TMapPolyLine();
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("routes?version=1");
        StringBuilder content = new StringBuilder();
        content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
        content.append("&startY=").append(startpoint.getLatitude());
        content.append("&startX=").append(startpoint.getLongitude());
        content.append("&endY=").append(endpoint.getLatitude());
        content.append("&endX=").append(endpoint.getLongitude());
        doc = TMapData.getDownloadFromPostUrl("findPathData", uri.toString(), content.toString(), false);
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("LineString");
            int i = 0;
            while (i < list.getLength()) {
                Element item = (Element)list.item(i);
                String str = HttpConnect.getContentFromNode(item, "coordinates");
                if (str != null) {
                    String[] str2 = str.split(" ");
                    int k = 0;
                    while (k < str2.length) {
                        try {
                            String[] str3 = str2[k].split(",");
                            TMapPoint point = new TMapPoint(Double.parseDouble(str3[1]), Double.parseDouble(str3[0]));
                            polyline.addLinePoint(point);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        return polyline;
    }

    public void findPathData(final TMapPoint startpoint, final TMapPoint endpoint, final FindPathDataListenerCallback findPathDataListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    TMapPolyLine polyline = new TMapPolyLine();
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("routes?version=1&format=xml");
                    StringBuilder content = new StringBuilder();
                    content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO");
                    content.append("&startY=").append(startpoint.getLatitude());
                    content.append("&startX=").append(startpoint.getLongitude());
                    content.append("&endY=").append(endpoint.getLatitude());
                    content.append("&endX=").append(endpoint.getLongitude());
                    doc = TMapData.getDownloadFromPostUrl("findPathData", uri.toString(), content.toString(), false);
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("LineString");
                        int i = 0;
                        while (i < list.getLength()) {
                            Element item = (Element)list.item(i);
                            String str = HttpConnect.getContentFromNode(item, "coordinates");
                            if (str != null) {
                                String[] str2 = str.split(" ");
                                int k = 0;
                                while (k < str2.length) {
                                    try {
                                        String[] str3 = str2[k].split(",");
                                        TMapPoint point = new TMapPoint(Double.parseDouble(str3[1]), Double.parseDouble(str3[0]));
                                        polyline.addLinePoint(point);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    ++k;
                                }
                            }
                            ++i;
                        }
                    }
                    findPathDataListener.onFindPathData(polyline);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public TMapPolyLine findPathDataWithType(TMapPathType type, TMapPoint startpoint, TMapPoint endpoint) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        TMapPolyLine polyline = new TMapPolyLine();
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        if (TMapPathType.CAR_PATH == type) {
            uri.append("routes?version=1");
        } else if (TMapPathType.PEDESTRIAN_PATH == type) {
            uri.append("routes/pedestrian?version=1");
        }
        StringBuilder content = new StringBuilder();
        content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
        content.append("&startY=").append(startpoint.getLatitude());
        content.append("&startX=").append(startpoint.getLongitude());
        content.append("&endY=").append(endpoint.getLatitude());
        content.append("&endX=").append(endpoint.getLongitude());
        content.append("&startName=").append(URLEncoder.encode("\ucd9c\ubc1c\uc9c0", "UTF-8"));
        content.append("&endName=").append(URLEncoder.encode("\ub3c4\ucc29\uc9c0", "UTF-8"));
        doc = TMapData.getDownloadFromPostUrl("findPathDataWithType", uri.toString(), content.toString(), false);
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("LineString");
            int i = 0;
            while (i < list.getLength()) {
                Element item = (Element)list.item(i);
                String str = HttpConnect.getContentFromNode(item, "coordinates");
                if (str != null) {
                    String[] str2 = str.split(" ");
                    int k = 0;
                    while (k < str2.length) {
                        try {
                            String[] str3 = str2[k].split(",");
                            TMapPoint point = new TMapPoint(Double.parseDouble(str3[1]), Double.parseDouble(str3[0]));
                            polyline.addLinePoint(point);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        return polyline;
    }

    public void findPathDataWithType(final TMapPathType type, final TMapPoint startpoint, final TMapPoint endpoint, final FindPathDataListenerCallback findPathDataListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    TMapPolyLine polyline = new TMapPolyLine();
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    if (TMapPathType.CAR_PATH == type) {
                        uri.append("routes?version=1");
                    } else if (TMapPathType.PEDESTRIAN_PATH == type) {
                        uri.append("routes/pedestrian?version=1");
                    }
                    StringBuilder content = new StringBuilder();
                    content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                    content.append("&startY=").append(startpoint.getLatitude());
                    content.append("&startX=").append(startpoint.getLongitude());
                    content.append("&endY=").append(endpoint.getLatitude());
                    content.append("&endX=").append(endpoint.getLongitude());
                    content.append("&startName=").append(URLEncoder.encode("\ucd9c\ubc1c\uc9c0", "UTF-8"));
                    content.append("&endName=").append(URLEncoder.encode("\ub3c4\ucc29\uc9c0", "UTF-8"));
                    doc = TMapData.getDownloadFromPostUrl("findPathDataWithType", uri.toString(), content.toString(), false);
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("LineString");
                        int i = 0;
                        while (i < list.getLength()) {
                            Element item = (Element)list.item(i);
                            String str = HttpConnect.getContentFromNode(item, "coordinates");
                            if (str != null) {
                                String[] str2 = str.split(" ");
                                int k = 0;
                                while (k < str2.length) {
                                    try {
                                        String[] str3 = str2[k].split(",");
                                        TMapPoint point = new TMapPoint(Double.parseDouble(str3[1]), Double.parseDouble(str3[0]));
                                        polyline.addLinePoint(point);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    ++k;
                                }
                            }
                            ++i;
                        }
                    }
                    findPathDataListener.onFindPathData(polyline);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public Document findPathDataAll(TMapPoint startpoint, TMapPoint endpoint) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("routes?version=1");
        StringBuilder content = new StringBuilder();
        content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
        content.append("&startY=").append(startpoint.getLatitude());
        content.append("&startX=").append(startpoint.getLongitude());
        content.append("&endY=").append(endpoint.getLatitude());
        content.append("&endX=").append(endpoint.getLongitude());
        doc = TMapData.getDownloadFromPostUrl("findPathDataAll", uri.toString(), content.toString(), false);
        return doc;
    }

    public void findPathDataAll(final TMapPoint startpoint, final TMapPoint endpoint, final FindPathDataAllListenerCallback findPathDataAllListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("routes?version=1");
                    StringBuilder content = new StringBuilder();
                    content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                    content.append("&startY=").append(startpoint.getLatitude());
                    content.append("&startX=").append(startpoint.getLongitude());
                    content.append("&endY=").append(endpoint.getLatitude());
                    content.append("&endX=").append(endpoint.getLongitude());
                    doc = TMapData.getDownloadFromPostUrl("findPathDataAll", uri.toString(), content.toString(), false);
                    findPathDataAllListener.onFindPathDataAll(doc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public Document findPathDataAllType(TMapPathType type, TMapPoint startpoint, TMapPoint endpoint) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        if (TMapPathType.CAR_PATH == type) {
            uri.append("routes?version=1");
        } else if (TMapPathType.PEDESTRIAN_PATH == type) {
            uri.append("routes/pedestrian?version=1");
        }
        StringBuilder content = new StringBuilder();
        content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
        content.append("&startY=").append(startpoint.getLatitude());
        content.append("&startX=").append(startpoint.getLongitude());
        content.append("&endY=").append(endpoint.getLatitude());
        content.append("&endX=").append(endpoint.getLongitude());
        content.append("&startName=").append(URLEncoder.encode("\ucd9c\ubc1c\uc9c0", "UTF-8"));
        content.append("&endName=").append(URLEncoder.encode("\ub3c4\ucc29\uc9c0", "UTF-8"));
        doc = TMapData.getDownloadFromPostUrl("findPathDataAllType", uri.toString(), content.toString(), false);
        return doc;
    }

    public void findPathDataAllType(final TMapPathType type, final TMapPoint startpoint, final TMapPoint endpoint, final FindPathDataAllListenerCallback findPathDataAllListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    if (TMapPathType.CAR_PATH == type) {
                        uri.append("routes?version=1");
                    } else if (TMapPathType.PEDESTRIAN_PATH == type) {
                        uri.append("routes/pedestrian?version=1");
                    }
                    StringBuilder content = new StringBuilder();
                    content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                    content.append("&startY=").append(startpoint.getLatitude());
                    content.append("&startX=").append(startpoint.getLongitude());
                    content.append("&endY=").append(endpoint.getLatitude());
                    content.append("&endX=").append(endpoint.getLongitude());
                    content.append("&startName=").append(URLEncoder.encode("\ucd9c\ubc1c\uc9c0", "UTF-8"));
                    content.append("&endName=").append(URLEncoder.encode("\ub3c4\ucc29\uc9c0", "UTF-8"));
                    doc = TMapData.getDownloadFromPostUrl("findPathDataAllType", uri.toString(), content.toString(), false);
                    findPathDataAllListener.onFindPathDataAll(doc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public TMapPolyLine findPathDataWithType(TMapPathType type, TMapPoint startpoint, TMapPoint endpoint, ArrayList<TMapPoint> passList, int searchOption) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        TMapPolyLine polyline = new TMapPolyLine();
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        if (TMapPathType.CAR_PATH == type) {
            uri.append("routes?version=1");
        } else if (TMapPathType.PEDESTRIAN_PATH == type) {
            uri.append("routes/pedestrian?version=1");
        }
        StringBuilder content = new StringBuilder();
        content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
        content.append("&startY=").append(startpoint.getLatitude());
        content.append("&startX=").append(startpoint.getLongitude());
        content.append("&endY=").append(endpoint.getLatitude());
        content.append("&endX=").append(endpoint.getLongitude());
        content.append("&startName=").append(URLEncoder.encode("\ucd9c\ubc1c\uc9c0", "UTF-8"));
        content.append("&endName=").append(URLEncoder.encode("\ub3c4\ucc29\uc9c0", "UTF-8"));
        content.append("&searchOption=").append(searchOption);
        String strPass = null;
        String strPassList = "";
        if (passList != null && passList.size() > 0) {
            int i = 0;
            while (i < passList.size()) {
                strPass = String.valueOf(passList.get(i).getLongitude()) + "," + passList.get(i).getLatitude();
                if (i != passList.size() - 1) {
                    strPass = String.valueOf(strPass) + "_";
                }
                strPassList = String.valueOf(strPassList) + strPass;
                ++i;
            }
            content.append("&passList=").append(URLEncoder.encode(strPassList, "UTF-8"));
        }
        if ((doc = TMapData.getDownloadFromPostUrl("findPathDataWithType", uri.toString(), content.toString(), false)) != null) {
            NodeList placemark = doc.getElementsByTagName("Placemark");
            int i = 0;
            while (i < placemark.getLength()) {
                String str;
                String lineIndex;
                Element item = (Element)placemark.item(i);
                String pointType = HttpConnect.getContentFromNode(item, "tmap:pointType");
                if (pointType != null) {
                    TMapPoint point;
                    String[] coord2;
                    String pointCoord;
                    if (TMapPathType.CAR_PATH == type) {
                        if (pointType.matches("B.*") && (pointCoord = HttpConnect.getContentFromNode(item, "coordinates")) != null) {
                            try {
                                coord2 = pointCoord.split(",");
                                point = new TMapPoint(Double.parseDouble(coord2[1]), Double.parseDouble(coord2[0]));
                                polyline.addPassPoint(point);
                            }
                            catch (Exception coord2) {}
                        }
                    } else if (TMapPathType.PEDESTRIAN_PATH == type && pointType.matches("PP.*") && (pointCoord = HttpConnect.getContentFromNode(item, "coordinates")) != null) {
                        try {
                            coord2 = pointCoord.split(",");
                            point = new TMapPoint(Double.parseDouble(coord2[1]), Double.parseDouble(coord2[0]));
                            polyline.addPassPoint(point);
                        }
                        catch (Exception coord3) {
                            // empty catch block
                        }
                    }
                }
                if ((lineIndex = HttpConnect.getContentFromNode(item, "tmap:lineIndex")) != null && (str = HttpConnect.getContentFromNode(item, "coordinates")) != null) {
                    String[] str2 = str.split(" ");
                    int k = 0;
                    while (k < str2.length) {
                        try {
                            String[] str3 = str2[k].split(",");
                            TMapPoint point = new TMapPoint(Double.parseDouble(str3[1]), Double.parseDouble(str3[0]));
                            polyline.addLinePoint(point);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        return polyline;
    }

    public void findPathDataWithType(final TMapPathType type, final TMapPoint startpoint, final TMapPoint endpoint, final ArrayList<TMapPoint> passList, final int searchOption, final FindPathDataListenerCallback findPathDataListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    TMapPolyLine polyline = new TMapPolyLine();
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    if (TMapPathType.CAR_PATH == type) {
                        uri.append("routes?version=1");
                    } else if (TMapPathType.PEDESTRIAN_PATH == type) {
                        uri.append("routes/pedestrian?version=1");
                    }
                    StringBuilder content = new StringBuilder();
                    content.append("reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                    content.append("&startY=").append(startpoint.getLatitude());
                    content.append("&startX=").append(startpoint.getLongitude());
                    content.append("&endY=").append(endpoint.getLatitude());
                    content.append("&endX=").append(endpoint.getLongitude());
                    content.append("&startName=").append(URLEncoder.encode("\ucd9c\ubc1c\uc9c0", "UTF-8"));
                    content.append("&endName=").append(URLEncoder.encode("\ub3c4\ucc29\uc9c0", "UTF-8"));
                    content.append("&searchOption=").append(searchOption);
                    String strPass = null;
                    String strPassList = "";
                    if (passList != null && passList.size() > 0) {
                        int i = 0;
                        while (i < passList.size()) {
                            strPass = String.valueOf(((TMapPoint)passList.get(i)).getLongitude()) + "," + ((TMapPoint)passList.get(i)).getLatitude();
                            if (i != passList.size() - 1) {
                                strPass = String.valueOf(strPass) + "_";
                            }
                            strPassList = String.valueOf(strPassList) + strPass;
                            ++i;
                        }
                        content.append("&passList=").append(URLEncoder.encode(strPassList, "UTF-8"));
                    }
                    if ((doc = TMapData.getDownloadFromPostUrl("findPathDataWithType", uri.toString(), content.toString(), false)) != null) {
                        NodeList placemark = doc.getElementsByTagName("Placemark");
                        int i = 0;
                        while (i < placemark.getLength()) {
                            String str;
                            String lineIndex;
                            Element item = (Element)placemark.item(i);
                            String pointType = HttpConnect.getContentFromNode(item, "tmap:pointType");
                            if (pointType != null) {
                                TMapPoint point;
                                String[] coord2;
                                String pointCoord;
                                if (TMapPathType.CAR_PATH == type) {
                                    if (pointType.matches("B.*") && (pointCoord = HttpConnect.getContentFromNode(item, "coordinates")) != null) {
                                        try {
                                            coord2 = pointCoord.split(",");
                                            point = new TMapPoint(Double.parseDouble(coord2[1]), Double.parseDouble(coord2[0]));
                                            polyline.addPassPoint(point);
                                        }
                                        catch (Exception coord2) {}
                                    }
                                } else if (TMapPathType.PEDESTRIAN_PATH == type && pointType.matches("PP.*") && (pointCoord = HttpConnect.getContentFromNode(item, "coordinates")) != null) {
                                    try {
                                        coord2 = pointCoord.split(",");
                                        point = new TMapPoint(Double.parseDouble(coord2[1]), Double.parseDouble(coord2[0]));
                                        polyline.addPassPoint(point);
                                    }
                                    catch (Exception coord3) {
                                        // empty catch block
                                    }
                                }
                            }
                            if ((lineIndex = HttpConnect.getContentFromNode(item, "tmap:lineIndex")) != null && (str = HttpConnect.getContentFromNode(item, "coordinates")) != null) {
                                String[] str2 = str.split(" ");
                                int k = 0;
                                while (k < str2.length) {
                                    try {
                                        String[] str3 = str2[k].split(",");
                                        TMapPoint point = new TMapPoint(Double.parseDouble(str3[1]), Double.parseDouble(str3[0]));
                                        polyline.addLinePoint(point);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    ++k;
                                }
                            }
                            ++i;
                        }
                    }
                    findPathDataListener.onFindPathData(polyline);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public TMapPolyLine findMultiPointPathData(TMapPoint startpoint, TMapPoint endpoint, ArrayList<TMapPoint> passList, int searchOption) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        TMapPolyLine polyline = new TMapPolyLine();
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("routes/routeSequential30?version=1&format=xml");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm", Locale.US);
        String strRequestTime = dateFormat.format(new Date(System.currentTimeMillis()));
        StringBuilder content = new StringBuilder();
        content.append("{");
        content.append("\t\"searchOption\" : \"" + searchOption + "\",");
        content.append("\t\"reqCoordType\" : \"WGS84GEO\",");
        content.append("\t\"resCoordType\" : \"WGS84GEO\",");
        content.append("\t\"startName\" : \"\ucd9c\ubc1c\",");
        content.append("\t\"startX\" : \"" + startpoint.getLongitude() + "\",");
        content.append("\t\"startY\" : \"" + startpoint.getLatitude() + "\",");
        content.append("\t\"startTime\" : \"" + strRequestTime + "\",");
        content.append("\t\"endName\" : \"\ub3c4\ucc29\",");
        content.append("\t\"endX\" : \"" + endpoint.getLongitude() + "\",");
        content.append("\t\"endY\" : \"" + endpoint.getLatitude() + "\",");
        content.append("\t\"viaPoints\" : ");
        content.append("\t[");
        int i = 0;
        while (i < passList.size()) {
            content.append("\t    { ");
            content.append("\t\t\"viaPointId\" : \"via" + i + "\",");
            content.append("\t\t\"viaPointName\" : \"via" + i + "\",");
            content.append("\t\t\"viaX\" : \"" + passList.get(i).getLongitude() + "\",");
            content.append("\t\t\"viaY\" : \"" + passList.get(i).getLatitude() + "\"");
            content.append("\t    }");
            if (i < passList.size() - 1) {
                content.append(",");
            }
            ++i;
        }
        content.append("\t] \t");
        content.append("}");
        doc = TMapData.getDownloadFromPostUrl("findMultiPointPathData", uri.toString(), content.toString(), true);
        if (doc != null) {
            NodeList placemark = doc.getElementsByTagName("Placemark");
            int i2 = 0;
            while (i2 < placemark.getLength()) {
                Element elementLineString;
                String strCoordinates;
                Element item = (Element)placemark.item(i2);
                String nodeType = HttpConnect.getContentFromNode(item, "tmap:nodeType");
                if (nodeType.equals("LINE") && (strCoordinates = HttpConnect.getContentFromNode(elementLineString = (Element)item.getElementsByTagName("LineString").item(0), "coordinates")) != null) {
                    try {
                        String[] arrCoordinates = strCoordinates.split(" ");
                        int j = 0;
                        while (j < arrCoordinates.length) {
                            String[] arrCoordinate = arrCoordinates[j].split(",");
                            TMapPoint point = new TMapPoint(Double.parseDouble(arrCoordinate[1]), Double.parseDouble(arrCoordinate[0]));
                            polyline.addLinePoint(point);
                            ++j;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i2;
            }
        }
        return polyline;
    }

    public void findMultiPointPathData(final TMapPoint startpoint, final TMapPoint endpoint, final ArrayList<TMapPoint> passList, final int searchOption, final FindPathDataListenerCallback findPathDataListener) {
        new Thread(){

            @Override
            public void run() {
                Document doc = null;
                TMapPolyLine polyline = new TMapPolyLine();
                StringBuilder uri = new StringBuilder();
                uri.append(dataUrl);
                uri.append("routes/routeSequential30?version=1&format=xml");
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm", Locale.US);
                String strRequestTime = dateFormat.format(new Date(System.currentTimeMillis()));
                StringBuilder content = new StringBuilder();
                content.append("{");
                content.append("\t\"searchOption\" : \"" + searchOption + "\",");
                content.append("\t\"reqCoordType\" : \"WGS84GEO\",");
                content.append("\t\"resCoordType\" : \"WGS84GEO\",");
                content.append("\t\"startName\" : \"\ucd9c\ubc1c\",");
                content.append("\t\"startX\" : \"" + startpoint.getLongitude() + "\",");
                content.append("\t\"startY\" : \"" + startpoint.getLatitude() + "\",");
                content.append("\t\"startTime\" : \"" + strRequestTime + "\",");
                content.append("\t\"endName\" : \"\ub3c4\ucc29\",");
                content.append("\t\"endX\" : \"" + endpoint.getLongitude() + "\",");
                content.append("\t\"endY\" : \"" + endpoint.getLatitude() + "\",");
                content.append("\t\"viaPoints\" : ");
                content.append("\t[");
                int i = 0;
                while (i < passList.size()) {
                    content.append("\t    { ");
                    content.append("\t\t\"viaPointId\" : \"via" + i + "\",");
                    content.append("\t\t\"viaPointName\" : \"via" + i + "\",");
                    content.append("\t\t\"viaX\" : \"" + ((TMapPoint)passList.get(i)).getLongitude() + "\",");
                    content.append("\t\t\"viaY\" : \"" + ((TMapPoint)passList.get(i)).getLatitude() + "\"");
                    content.append("\t    }");
                    if (i < passList.size() - 1) {
                        content.append(",");
                    }
                    ++i;
                }
                content.append("\t] \t");
                content.append("}");
                doc = TMapData.getDownloadFromPostUrl("findMultiPointPathData", uri.toString(), content.toString(), true);
                if (doc != null) {
                    NodeList placemark = doc.getElementsByTagName("Placemark");
                    int i2 = 0;
                    while (i2 < placemark.getLength()) {
                        Element elementLineString;
                        String strCoordinates;
                        Element item = (Element)placemark.item(i2);
                        String nodeType = HttpConnect.getContentFromNode(item, "tmap:nodeType");
                        if (nodeType.equals("LINE") && (strCoordinates = HttpConnect.getContentFromNode(elementLineString = (Element)item.getElementsByTagName("LineString").item(0), "coordinates")) != null) {
                            try {
                                String[] arrCoordinates = strCoordinates.split(" ");
                                int j = 0;
                                while (j < arrCoordinates.length) {
                                    String[] arrCoordinate = arrCoordinates[j].split(",");
                                    TMapPoint point = new TMapPoint(Double.parseDouble(arrCoordinate[1]), Double.parseDouble(arrCoordinate[0]));
                                    polyline.addLinePoint(point);
                                    ++j;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        ++i2;
                    }
                }
                findPathDataListener.onFindPathData(polyline);
            }
        }.start();
    }

    public ArrayList<TMapPOIItem> findAroundKeywordPOI(TMapPoint tmappoint, String keywordName, int nRadius, int nSearchCount) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        Document doc = null;
        ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("pois?version=1&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
        uri.append("&centerLat=").append(tmappoint.getLatitude());
        uri.append("&centerLon=").append(tmappoint.getLongitude());
        uri.append("&searchtypCd=R");
        if (nRadius < 0) {
            uri.append("&radius=").append(1);
        } else if (nRadius > 33) {
            uri.append("&radius=").append(33);
        } else {
            uri.append("&radius=").append(nRadius);
        }
        if (nSearchCount <= 0) {
            uri.append("&count=").append(20);
        } else if (nSearchCount > 200) {
            uri.append("&count=").append(200);
        } else {
            uri.append("&count=").append(nSearchCount);
        }
        String utf8name = URLEncoder.encode(keywordName, "UTF-8");
        uri.append("&searchKeyword=").append(utf8name);
        doc = TMapData.getDownloadFromUrl(uri.toString(), "findAroundKeywordPOI");
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("poi");
            int i = 0;
            while (i < list.getLength()) {
                TMapPOIItem poiitem = new TMapPOIItem();
                Element item = (Element)list.item(i);
                poiitem.id = HttpConnect.getContentFromNode(item, "id");
                poiitem.name = HttpConnect.getContentFromNode(item, "name");
                poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                poiitem.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                poiitem.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                poiitem.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                poiitem.detailInfoFlag = HttpConnect.getContentFromNode(item, "detailInfoFlag");
                poiitem.desc = HttpConnect.getContentFromNode(item, "desc");
                poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                allpoi.add(poiitem);
                ++i;
            }
        }
        return allpoi;
    }

    public void findAroundKeywordPOI(final TMapPoint tmappoint, final String keywordName, final int nRadius, final int nSearchCount, final FindAroundKeywordPOIListenerCallback findAroundKeywordPoiListener) {
        new Thread(){

            @Override
            public void run() {
                Document doc = null;
                ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
                try {
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois?version=1&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                    uri.append("&centerLat=").append(tmappoint.getLatitude());
                    uri.append("&centerLon=").append(tmappoint.getLongitude());
                    uri.append("&searchtypCd=R");
                    if (nRadius < 0) {
                        uri.append("&radius=").append(1);
                    } else if (nRadius > 33) {
                        uri.append("&radius=").append(33);
                    } else {
                        uri.append("&radius=").append(nRadius);
                    }
                    if (nSearchCount <= 0) {
                        uri.append("&count=").append(20);
                    } else if (nSearchCount > 200) {
                        uri.append("&count=").append(200);
                    } else {
                        uri.append("&count=").append(nSearchCount);
                    }
                    String utf8name = URLEncoder.encode(keywordName, "UTF-8");
                    uri.append("&searchKeyword=").append(utf8name);
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "findAroundKeywordPOI");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                if (doc != null) {
                    NodeList list = doc.getElementsByTagName("poi");
                    int i = 0;
                    while (i < list.getLength()) {
                        TMapPOIItem poiitem = new TMapPOIItem();
                        Element item = (Element)list.item(i);
                        poiitem.id = HttpConnect.getContentFromNode(item, "id");
                        poiitem.name = HttpConnect.getContentFromNode(item, "name");
                        poiitem.telNo = HttpConnect.getContentFromNode(item, "telNo");
                        poiitem.frontLat = HttpConnect.getContentFromNode(item, "frontLat");
                        poiitem.frontLon = HttpConnect.getContentFromNode(item, "frontLon");
                        poiitem.noorLat = HttpConnect.getContentFromNode(item, "noorLat");
                        poiitem.noorLon = HttpConnect.getContentFromNode(item, "noorLon");
                        poiitem.upperAddrName = HttpConnect.getContentFromNode(item, "upperAddrName");
                        poiitem.middleAddrName = HttpConnect.getContentFromNode(item, "middleAddrName");
                        poiitem.lowerAddrName = HttpConnect.getContentFromNode(item, "lowerAddrName");
                        poiitem.detailAddrName = HttpConnect.getContentFromNode(item, "detailAddrName");
                        poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                        poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                        poiitem.upperBizName = HttpConnect.getContentFromNode(item, "upperBizName");
                        poiitem.middleBizName = HttpConnect.getContentFromNode(item, "middleBizName");
                        poiitem.lowerBizName = HttpConnect.getContentFromNode(item, "lowerBizName");
                        poiitem.rpFlag = HttpConnect.getContentFromNode(item, "rpFlag");
                        poiitem.parkFlag = HttpConnect.getContentFromNode(item, "parkFlag");
                        poiitem.detailInfoFlag = HttpConnect.getContentFromNode(item, "detailInfoFlag");
                        poiitem.desc = HttpConnect.getContentFromNode(item, "desc");
                        poiitem.radius = HttpConnect.getContentFromNode(item, "radius");
                        allpoi.add(poiitem);
                        ++i;
                    }
                }
                findAroundKeywordPoiListener.onFindAroundKeywordPOI(allpoi);
            }
        }.start();
    }

    public Document findTimeMachineCarPath(HashMap<String, String> pathInfo, Date date, ArrayList<TMapPoint> wayPoint) {
        Document doc = null;
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("routes/prediction?version=1");
        uri.append("&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
        uri.append("&callback=application/xml");
        String strStName = null;
        String strStlat = null;
        String strStlon = null;
        String strGolat = null;
        String strGolon = null;
        String strGoName = null;
        String strType = null;
        for (Map.Entry<String, String> e : pathInfo.entrySet()) {
            if (e.getKey().contains("rStName")) {
                strStName = e.getValue();
                continue;
            }
            if (e.getKey().contains("rStlat")) {
                strStlat = e.getValue();
                continue;
            }
            if (e.getKey().contains("rStlon")) {
                strStlon = e.getValue();
                continue;
            }
            if (e.getKey().contains("rGoName")) {
                strGoName = e.getValue();
                continue;
            }
            if (e.getKey().contains("rGolat")) {
                strGolat = e.getValue();
                continue;
            }
            if (e.getKey().contains("rGolon")) {
                strGolon = e.getValue();
                continue;
            }
            if (!e.getKey().contains("type")) continue;
            strType = e.getValue();
        }
        JSONStringer stringer = null;
        try {
            HashMap<String, Object> pkt = new HashMap<String, Object>();
            LinkedHashMap<String, String> data1 = new LinkedHashMap<String, String>();
            data1.put("name", strStName);
            data1.put("lat", strStlat);
            data1.put("lon", strStlon);
            LinkedHashMap<String, String> data2 = new LinkedHashMap<String, String>();
            data2.put("name", strGoName);
            data2.put("lat", strGolat);
            data2.put("lon", strGolon);
            pkt.put("departure", data1);
            pkt.put("destination", data2);
            pkt.put("predictionType", strType);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            String nowAsString = df.format(date);
            pkt.put("predictionTime", nowAsString);
            if (wayPoint != null && wayPoint.size() > 0) {
                JSONObject obj = new JSONObject();
                JSONArray req = new JSONArray();
                int i = 0;
                while (i < wayPoint.size()) {
                    JSONObject reqObj = new JSONObject();
                    reqObj.put("lon", wayPoint.get(i).getLongitude());
                    reqObj.put("lat", wayPoint.get(i).getLatitude());
                    req.put((Object)reqObj);
                    ++i;
                }
                obj.put("wayPoint", (Object)req);
                pkt.put("wayPoints", obj);
            }
            stringer = new JSONStringer();
            stringer.object();
            stringer.key("routesInfo");
            this.toJSON(pkt, stringer);
            stringer.endObject();
        }
        catch (JSONException e) {
            return null;
        }
        doc = TMapData.getDownloadFromPostUrl("findTimeMachineCarPath", uri.toString(), stringer.toString(), true);
        return doc;
    }

    public void findTimeMachineCarPath(final HashMap<String, String> pathInfo, final Date date, final ArrayList<TMapPoint> wayPoint, final FindTimeMachineCarPathListenerCallback findTimeMachineCarPathListener) {
        new Thread(){

            @Override
            public void run() {
                Document doc = null;
                StringBuilder uri = new StringBuilder();
                uri.append(dataUrl);
                uri.append("routes/prediction?version=1");
                uri.append("&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                uri.append("&callback=application/xml");
                String strStName = null;
                String strStlat = null;
                String strStlon = null;
                String strGolat = null;
                String strGolon = null;
                String strGoName = null;
                String strType = null;
                for (Map.Entry e : pathInfo.entrySet()) {
                    if (((String)e.getKey()).contains("rStName")) {
                        strStName = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rStlat")) {
                        strStlat = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rStlon")) {
                        strStlon = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rGoName")) {
                        strGoName = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rGolat")) {
                        strGolat = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rGolon")) {
                        strGolon = (String)e.getValue();
                        continue;
                    }
                    if (!((String)e.getKey()).contains("type")) continue;
                    strType = (String)e.getValue();
                }
                JSONStringer stringer = null;
                try {
                    HashMap<String, Object> pkt = new HashMap<String, Object>();
                    LinkedHashMap<String, String> data1 = new LinkedHashMap<String, String>();
                    data1.put("name", strStName);
                    data1.put("lat", strStlat);
                    data1.put("lon", strStlon);
                    LinkedHashMap<String, String> data2 = new LinkedHashMap<String, String>();
                    data2.put("name", strGoName);
                    data2.put("lat", strGolat);
                    data2.put("lon", strGolon);
                    pkt.put("departure", data1);
                    pkt.put("destination", data2);
                    pkt.put("predictionType", strType);
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                    String nowAsString = df.format(date);
                    pkt.put("predictionTime", nowAsString);
                    if (wayPoint != null && wayPoint.size() > 0) {
                        JSONObject obj = new JSONObject();
                        JSONArray req = new JSONArray();
                        int i = 0;
                        while (i < wayPoint.size()) {
                            JSONObject reqObj = new JSONObject();
                            reqObj.put("lon", ((TMapPoint)wayPoint.get(i)).getLongitude());
                            reqObj.put("lat", ((TMapPoint)wayPoint.get(i)).getLatitude());
                            req.put((Object)reqObj);
                            ++i;
                        }
                        obj.put("wayPoint", (Object)req);
                        pkt.put("wayPoints", obj);
                    }
                    stringer = new JSONStringer();
                    stringer.object();
                    stringer.key("routesInfo");
                    TMapData.this.toJSON(pkt, stringer);
                    stringer.endObject();
                }
                catch (JSONException e) {
                    return;
                }
                doc = TMapData.getDownloadFromPostUrl("findTimeMachineCarPath", uri.toString(), stringer.toString(), true);
                findTimeMachineCarPathListener.onFindTimeMachineCarPath(doc);
            }
        }.start();
    }

    public Document findTimeMachineCarPath(HashMap<String, String> pathInfo, Date date, ArrayList<TMapPoint> wayPoint, String searchOption) {
        Document doc = null;
        StringBuilder uri = new StringBuilder();
        uri.append(dataUrl);
        uri.append("routes/prediction?version=1");
        uri.append("&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
        uri.append("&callback=application/xml");
        String strStName = null;
        String strStlat = null;
        String strStlon = null;
        String strGolat = null;
        String strGolon = null;
        String strGoName = null;
        String strType = null;
        for (Map.Entry<String, String> e : pathInfo.entrySet()) {
            if (e.getKey().contains("rStName")) {
                strStName = e.getValue();
                continue;
            }
            if (e.getKey().contains("rStlat")) {
                strStlat = e.getValue();
                continue;
            }
            if (e.getKey().contains("rStlon")) {
                strStlon = e.getValue();
                continue;
            }
            if (e.getKey().contains("rGoName")) {
                strGoName = e.getValue();
                continue;
            }
            if (e.getKey().contains("rGolat")) {
                strGolat = e.getValue();
                continue;
            }
            if (e.getKey().contains("rGolon")) {
                strGolon = e.getValue();
                continue;
            }
            if (!e.getKey().contains("type")) continue;
            strType = e.getValue();
        }
        JSONStringer stringer = null;
        try {
            HashMap<String, Object> pkt = new HashMap<String, Object>();
            LinkedHashMap<String, String> data1 = new LinkedHashMap<String, String>();
            data1.put("name", strStName);
            data1.put("lat", strStlat);
            data1.put("lon", strStlon);
            LinkedHashMap<String, String> data2 = new LinkedHashMap<String, String>();
            data2.put("name", strGoName);
            data2.put("lat", strGolat);
            data2.put("lon", strGolon);
            pkt.put("departure", data1);
            pkt.put("destination", data2);
            pkt.put("predictionType", strType);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            String nowAsString = df.format(date);
            pkt.put("predictionTime", nowAsString);
            if (wayPoint != null && wayPoint.size() > 0) {
                JSONObject obj = new JSONObject();
                JSONArray req = new JSONArray();
                int i = 0;
                while (i < wayPoint.size()) {
                    JSONObject reqObj = new JSONObject();
                    reqObj.put("lon", wayPoint.get(i).getLongitude());
                    reqObj.put("lat", wayPoint.get(i).getLatitude());
                    req.put((Object)reqObj);
                    ++i;
                }
                obj.put("wayPoint", (Object)req);
                pkt.put("wayPoints", obj);
            }
            pkt.put("searchOption", searchOption);
            stringer = new JSONStringer();
            stringer.object();
            stringer.key("routesInfo");
            this.toJSON(pkt, stringer);
            stringer.endObject();
        }
        catch (JSONException e) {
            return null;
        }
        doc = TMapData.getDownloadFromPostUrl("findTimeMachineCarPath", uri.toString(), stringer.toString(), true);
        return doc;
    }

    public void findTimeMachineCarPath(final HashMap<String, String> pathInfo, final Date date, final ArrayList<TMapPoint> wayPoint, final String searchOption, final FindTimeMachineCarPathListenerCallback findTimeMachineCarPathListener) {
        new Thread(){

            @Override
            public void run() {
                Document doc = null;
                StringBuilder uri = new StringBuilder();
                uri.append(dataUrl);
                uri.append("routes/prediction?version=1");
                uri.append("&reqCoordType=WGS84GEO&resCoordType=WGS84GEO&format=xml");
                uri.append("&callback=application/xml");
                String strStName = null;
                String strStlat = null;
                String strStlon = null;
                String strGolat = null;
                String strGolon = null;
                String strGoName = null;
                String strType = null;
                for (Map.Entry e : pathInfo.entrySet()) {
                    if (((String)e.getKey()).contains("rStName")) {
                        strStName = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rStlat")) {
                        strStlat = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rStlon")) {
                        strStlon = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rGoName")) {
                        strGoName = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rGolat")) {
                        strGolat = (String)e.getValue();
                        continue;
                    }
                    if (((String)e.getKey()).contains("rGolon")) {
                        strGolon = (String)e.getValue();
                        continue;
                    }
                    if (!((String)e.getKey()).contains("type")) continue;
                    strType = (String)e.getValue();
                }
                JSONStringer stringer = null;
                try {
                    HashMap<String, Object> pkt = new HashMap<String, Object>();
                    LinkedHashMap<String, String> data1 = new LinkedHashMap<String, String>();
                    data1.put("name", strStName);
                    data1.put("lat", strStlat);
                    data1.put("lon", strStlon);
                    LinkedHashMap<String, String> data2 = new LinkedHashMap<String, String>();
                    data2.put("name", strGoName);
                    data2.put("lat", strGolat);
                    data2.put("lon", strGolon);
                    pkt.put("departure", data1);
                    pkt.put("destination", data2);
                    pkt.put("predictionType", strType);
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                    String nowAsString = df.format(date);
                    pkt.put("predictionTime", nowAsString);
                    if (wayPoint != null && wayPoint.size() > 0) {
                        JSONObject obj = new JSONObject();
                        JSONArray req = new JSONArray();
                        int i = 0;
                        while (i < wayPoint.size()) {
                            JSONObject reqObj = new JSONObject();
                            reqObj.put("lon", ((TMapPoint)wayPoint.get(i)).getLongitude());
                            reqObj.put("lat", ((TMapPoint)wayPoint.get(i)).getLatitude());
                            req.put((Object)reqObj);
                            ++i;
                        }
                        obj.put("wayPoint", (Object)req);
                        pkt.put("wayPoints", obj);
                    }
                    pkt.put("searchOption", searchOption);
                    stringer = new JSONStringer();
                    stringer.object();
                    stringer.key("routesInfo");
                    TMapData.this.toJSON(pkt, stringer);
                    stringer.endObject();
                }
                catch (JSONException e) {
                    return;
                }
                doc = TMapData.getDownloadFromPostUrl("findTimeMachineCarPath", uri.toString(), stringer.toString(), true);
                findTimeMachineCarPathListener.onFindTimeMachineCarPath(doc);
            }
        }.start();
    }

    private void addAutoName(String id, TMapAutoComplete name) {
        if (autoName.size() > 9) {
            Iterator<String> iterator = autoName.keySet().iterator();
            autoName.remove(iterator.next());
        }
        autoName.put(id, name);
    }

    private TMapAutoComplete getAutoName(String id) {
        return autoName.get(id);
    }

    public ArrayList<String> autoComplete(String keywordName) throws MalformedURLException, IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        TMapAutoComplete poiitem = new TMapAutoComplete();
        String name = null;
        Document doc = null;
        try {
            StringBuilder uri = new StringBuilder();
            uri.append(dataUrl);
            uri.append("poi/autoComplete?version=1&format=xml");
            String utf8name = URLEncoder.encode(keywordName, "UTF-8");
            uri.append("&searchKeyword=").append(utf8name);
            doc = TMapData.getDownloadFromUrl(uri.toString(), "autoComplete");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("suggestions");
            int i = 0;
            while (i < list.getLength()) {
                Element item = (Element)list.item(i);
                name = HttpConnect.getContentFromNode(item, "keyword");
                poiitem.addName(name);
                ++i;
            }
        }
        return poiitem.getNameArry();
    }

    public void autoComplete(final String keywordName, final AutoCompleteListenerCallback autoCompleteListener) {
        new Thread(){

            @Override
            public void run() {
                TMapAutoComplete autoComplete = null;
                autoComplete = TMapData.this.getAutoName(keywordName);
                ArrayList<String> nameArry = null;
                if (autoComplete != null) {
                    nameArry = autoComplete.getNameArry();
                    autoCompleteListener.onAutoComplete(nameArry);
                } else {
                    Document doc = null;
                    String name = null;
                    TMapAutoComplete poiitem = new TMapAutoComplete();
                    try {
                        StringBuilder uri = new StringBuilder();
                        uri.append(dataUrl);
                        uri.append("poi/autoComplete?version=1&format=xml");
                        String utf8name = URLEncoder.encode(keywordName, "UTF-8");
                        uri.append("&searchKeyword=").append(utf8name);
                        doc = TMapData.getDownloadFromUrl(uri.toString(), "autoComplete");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("suggestions");
                        int i = 0;
                        while (i < list.getLength()) {
                            Element item = (Element)list.item(i);
                            name = HttpConnect.getContentFromNode(item, "keyword");
                            poiitem.addName(name);
                            ++i;
                        }
                    }
                    TMapData.this.addAutoName(keywordName, poiitem);
                    autoCompleteListener.onAutoComplete(poiitem.getNameArry());
                }
            }
        }.start();
    }

    public void findPoiAreaDataByName(final int count, final int page, final String data, final FindAllPOIListenerCallback findAllPoiListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
                    String encodedData = URLEncoder.encode(data, "UTF-8");
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("poi/findPoiAreaDataByName?version=1&addressType=all&resCoordType=WGS84GEO&format=xml");
                    if (count < 1) {
                        uri.append("&count=").append(1);
                    } else if (count > 200) {
                        uri.append("&count=").append(200);
                    } else {
                        uri.append("&count=").append(count);
                    }
                    if (count < 1) {
                        uri.append("&page=").append(1);
                    } else if (count > 200) {
                        uri.append("&page=").append(200);
                    } else {
                        uri.append("&page=").append(page);
                    }
                    uri.append("&area_dong=").append(encodedData);
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "findPoiAreaDataByName");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("dongInfo");
                        int i = 0;
                        while (i < list.getLength()) {
                            TMapPOIItem poiitem = new TMapPOIItem();
                            Element item = (Element)list.item(i);
                            poiitem.name = HttpConnect.getContentFromNode(item, "address");
                            poiitem.noorLat = HttpConnect.getContentFromNode(item, "resLat");
                            poiitem.noorLon = HttpConnect.getContentFromNode(item, "resLon");
                            allpoi.add(poiitem);
                            ++i;
                        }
                    }
                    findAllPoiListener.onFindAllPOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void findPOIDetailInfo(final String poiId, final FindAllPOIListenerCallback findAllPoiListener) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Document doc = null;
                    ArrayList<TMapPOIItem> allpoi = new ArrayList<TMapPOIItem>();
                    StringBuilder uri = new StringBuilder();
                    uri.append(dataUrl);
                    uri.append("pois/");
                    uri.append(poiId);
                    uri.append("?version=1&resCoordType=WGS84GEO&format=xml");
                    doc = TMapData.getDownloadFromUrl(uri.toString(), "findPOIDetailInfo");
                    if (doc != null) {
                        NodeList list = doc.getElementsByTagName("poiDetailInfo");
                        int i = 0;
                        while (i < list.getLength()) {
                            TMapPOIItem poiitem = new TMapPOIItem();
                            Element item = (Element)list.item(i);
                            poiitem.id = HttpConnect.getContentFromNode(item, "id");
                            poiitem.name = HttpConnect.getContentFromNode(item, "name");
                            poiitem.bizCatName = HttpConnect.getContentFromNode(item, "bizCatName");
                            poiitem.telNo = HttpConnect.getContentFromNode(item, "tel");
                            poiitem.noorLat = HttpConnect.getContentFromNode(item, "lat");
                            poiitem.noorLon = HttpConnect.getContentFromNode(item, "lon");
                            poiitem.address = HttpConnect.getContentFromNode(item, "address");
                            poiitem.firstNo = HttpConnect.getContentFromNode(item, "firstNo");
                            poiitem.secondNo = HttpConnect.getContentFromNode(item, "secondNo");
                            poiitem.zipCode = HttpConnect.getContentFromNode(item, "zipCode");
                            poiitem.homepageURL = HttpConnect.getContentFromNode(item, "homepageURL");
                            poiitem.routeInfo = HttpConnect.getContentFromNode(item, "routeInfo");
                            poiitem.additionalInfo = HttpConnect.getContentFromNode(item, "additionalInfo");
                            poiitem.desc = HttpConnect.getContentFromNode(item, "desc");
                            allpoi.add(poiitem);
                            ++i;
                        }
                    }
                    findAllPoiListener.onFindAllPOI(allpoi);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public void setResponseCodeInfoCallBack(OnResponseCodeInfoCallback listener) {
        responseCodeListener = listener;
    }

    private static Document getDownloadFromUrl(String url, String apiName) {
        Document doc = null;
        URLConnection con = HttpConnect.getDownloadFromUrl(url);
        try {
            HttpURLConnection urlCon = (HttpURLConnection)con;
            if (responseCodeListener != null) {
                responseCodeListener.responseCodeInfo(apiName, urlCon.getResponseCode(), url);
            }
            if (con != null && (doc = HttpConnect.getDocument(con)) == null && urlCon.getResponseCode() != 200) {
                if (urlCon.getResponseMessage().equals("Unauthorized")) {
                    Log.w((String)"SKT", (String)"\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 API Key \uc785\ub2c8\ub2e4.");
                } else if (urlCon.getResponseMessage().equals("Bad Request")) {
                    Log.w((String)"SKT", (String)"\uc694\uccad \ub370\uc774\ud130 \uc624\ub958\uc785\ub2c8\ub2e4.");
                } else {
                    Log.w((String)"SKT", (String)urlCon.getResponseMessage());
                }
            }
        }
        catch (IOException e) {
            return doc;
        }
        return doc;
    }

    private static Document getDownloadFromPostUrl(String apiName, String url, String contents, boolean conTypeJason) {
        Document doc = null;
        URLConnection con = HttpConnect.getDownloadFromPostUrl(url, contents, conTypeJason);
        try {
            HttpURLConnection urlCon = (HttpURLConnection)con;
            if (responseCodeListener != null) {
                responseCodeListener.responseCodeInfo(apiName, urlCon.getResponseCode(), String.valueOf(url) + "/" + contents);
            }
            if (con != null && (doc = HttpConnect.getDocument(con)) == null && urlCon.getResponseCode() != 200) {
                if (urlCon.getResponseMessage().equals("Unauthorized")) {
                    Log.w((String)"SKT", (String)"\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 API Key \uc785\ub2c8\ub2e4.");
                } else if (urlCon.getResponseMessage().equals("Bad Request")) {
                    Log.w((String)"SKT", (String)"\uc694\uccad \ub370\uc774\ud130 \uc624\ub958\uc785\ub2c8\ub2e4.");
                } else {
                    Log.w((String)"SKT", (String)urlCon.getResponseMessage());
                }
            }
        }
        catch (IOException e) {
            return doc;
        }
        return doc;
    }

    private void toJSON(Map<?, ?> map, JSONStringer stringer) throws JSONException {
        stringer.object();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            stringer.key(String.valueOf(entry.getKey()));
            this.toJSONValue(entry.getValue(), stringer);
        }
        stringer.endObject();
    }

    private void toJSONValue(Object value, JSONStringer stringer) throws JSONException {
        if (value == null) {
            stringer.value(null);
        } else if (value instanceof Collection) {
            this.toJSON((Collection)value, stringer);
        } else if (value instanceof Map) {
            this.toJSON((Map)value, stringer);
        } else if (value.getClass().isArray()) {
            if (value.getClass().getComponentType().isPrimitive()) {
                stringer.array();
                if (value instanceof byte[]) {
                    byte[] byArray = (byte[])value;
                    int n = byArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte b = byArray[n2];
                        stringer.value((long)b);
                        ++n2;
                    }
                } else if (value instanceof short[]) {
                    short[] sArray = (short[])value;
                    int n = sArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        short s = sArray[n3];
                        stringer.value((long)s);
                        ++n3;
                    }
                } else if (value instanceof int[]) {
                    int[] nArray = (int[])value;
                    int n = nArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        int i = nArray[n4];
                        stringer.value((long)i);
                        ++n4;
                    }
                } else if (value instanceof float[]) {
                    float[] fArray = (float[])value;
                    int n = fArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        float f = fArray[n5];
                        stringer.value((double)f);
                        ++n5;
                    }
                } else if (value instanceof double[]) {
                    double[] dArray = (double[])value;
                    int n = dArray.length;
                    int n6 = 0;
                    while (n6 < n) {
                        double d = dArray[n6];
                        stringer.value(d);
                        ++n6;
                    }
                } else if (value instanceof char[]) {
                    char[] cArray = (char[])value;
                    int n = cArray.length;
                    int n7 = 0;
                    while (n7 < n) {
                        char c = cArray[n7];
                        stringer.value((long)c);
                        ++n7;
                    }
                } else if (value instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value;
                    int n = blArray.length;
                    int n8 = 0;
                    while (n8 < n) {
                        boolean b = blArray[n8];
                        stringer.value(b);
                        ++n8;
                    }
                }
                stringer.endArray();
            } else {
                this.toJSON((Object[])value, stringer);
            }
        } else {
            stringer.value(value);
        }
    }

    private void toJSON(Object[] array, JSONStringer stringer) throws JSONException {
        stringer.array();
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            this.toJSONValue(value, stringer);
            ++n2;
        }
        stringer.endArray();
    }

    private void toJSON(Collection<?> collection, JSONStringer stringer) throws JSONException {
        stringer.array();
        for (Object value : collection) {
            this.toJSONValue(value, stringer);
        }
        stringer.endArray();
    }

    public static interface AutoCompleteListenerCallback {
        public void onAutoComplete(ArrayList<String> var1);
    }

    public static interface BizCategoryListenerCallback {
        public void onGetBizCategory(ArrayList<BizCategory> var1);
    }

    protected static interface CheckKeyResultListenerCallback {
        public void onCheckKeyResult(String var1);
    }

    public static interface ConvertGPSToAddressListenerCallback {
        public void onConvertToGPSToAddress(String var1);
    }

    public static interface FindAddressPOIListenerCallback {
        public void onFindAddressPOI(ArrayList<TMapPOIItem> var1);
    }

    public static interface FindAllPOIListenerCallback {
        public void onFindAllPOI(ArrayList<TMapPOIItem> var1);
    }

    public static interface FindAroundKeywordPOIListenerCallback {
        public void onFindAroundKeywordPOI(ArrayList<TMapPOIItem> var1);
    }

    public static interface FindAroundNamePOIListenerCallback {
        public void onFindAroundNamePOI(ArrayList<TMapPOIItem> var1);
    }

    public static interface FindPathDataAllListenerCallback {
        public void onFindPathDataAll(Document var1);
    }

    public static interface FindPathDataListenerCallback {
        public void onFindPathData(TMapPolyLine var1);
    }

    public static interface FindTimeMachineCarPathListenerCallback {
        public void onFindTimeMachineCarPath(Document var1);
    }

    public static interface FindTitlePOIListenerCallback {
        public void onFindTitlePOI(ArrayList<TMapPOIItem> var1);
    }

    public static interface OnResponseCodeInfoCallback {
        public void responseCodeInfo(String var1, int var2, String var3);
    }

    public static enum TMapPathType {
        CAR_PATH,
        PEDESTRIAN_PATH;

    }

    public static interface findReverseLabelCallBack {
        public void onReverseLabelCallBack(TMapLabelInfo var1);
    }

    public static interface reverseGeocodingListenerCallback {
        public void onReverseGeocoding(TMapAddressInfo var1);
    }
}

