/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import com.skt.Tmap.TMapView;
import java.util.Date;

public class TrackingThread
implements Runnable {
    private TMapView view = null;
    private volatile Thread currentThread = null;
    private volatile boolean stopped;
    private Date lastCheckTime = new Date();

    public TrackingThread(TMapView view) {
        this.view = view;
    }

    @Override
    public void run() {
        this.currentThread = Thread.currentThread();
        try {
            while (!this.stopped) {
                Thread.sleep(1000L);
                long TimeGap = (new Date().getTime() - this.lastCheckTime.getTime()) / 1000L;
                if (TimeGap < 2L) continue;
                this.view.setCenterPoint(this.view.getLocationPoint().getLongitude(), this.view.getLocationPoint().getLatitude());
                this.lastCheckTime = new Date();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.currentThread = null;
    }

    public void startTracking() {
        this.finishThread();
        this.stopped = false;
        if (this.currentThread == null) {
            Thread thread = new Thread(this);
            thread.start();
        }
    }

    public void stopTracking() {
        this.finishThread();
    }

    public boolean isTracking() {
        return !this.stopped;
    }

    public void finishThread() {
        this.stopped = true;
        while (this.currentThread != null) {
            try {
                this.currentThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.currentThread = null;
    }
}

