/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.skt.Tmap.ITileOrigin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MapTileDownloader {
    public static final int TILE_DOWNLOAD_THREADS = 18;
    public static final int TILE_DOWNLOAD_SECONDS_TO_WORK = 25;
    private ThreadPoolExecutor mThreadPoolExecutor = null;
    private List<IMapDownloaderCallback> mCallback = new ArrayList<IMapDownloaderCallback>();
    private Set<String> mCurrentDownload = null;

    public MapTileDownloader() {
        if (this.mThreadPoolExecutor == null) {
            int nCorePoolSize = Runtime.getRuntime().availableProcessors();
            this.mThreadPoolExecutor = new ThreadPoolExecutor(nCorePoolSize, 18, 25L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }
        this.mThreadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        this.mCurrentDownload = Collections.synchronizedSet(new HashSet());
    }

    public MapTileDownloader(int numberOfThreads) {
        if (this.mThreadPoolExecutor == null) {
            int nCorePoolSize = Runtime.getRuntime().availableProcessors();
            this.mThreadPoolExecutor = new ThreadPoolExecutor(nCorePoolSize, numberOfThreads, 25L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }
        this.mThreadPoolExecutor.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        this.mCurrentDownload = Collections.synchronizedSet(new HashSet());
    }

    public void threadPoolShutDown() {
        this.mThreadPoolExecutor.shutdown();
    }

    public void addDownloaderMapCallback(IMapDownloaderCallback callback) {
        this.mCallback.add(callback);
    }

    public void removeDownloaderMapCallback(IMapDownloaderCallback callback) {
        if (this.mCallback.size() > 0) {
            this.mCallback.remove(callback);
        }
    }

    public List<IMapDownloaderCallback> getDownloaderMapCallback() {
        return this.mCallback;
    }

    public boolean isFileCurrentDownload(String string) {
        return this.mCurrentDownload.contains(string);
    }

    public boolean isDownLoding() {
        return !this.mCurrentDownload.isEmpty();
    }

    public int getRemainingCount() {
        return (int)this.mThreadPoolExecutor.getTaskCount();
    }

    public void refuseAllPreviousDataRequests() {
        while (!this.mThreadPoolExecutor.getQueue().isEmpty()) {
            this.mThreadPoolExecutor.getQueue().poll();
        }
    }

    public void downloadRequest(DownloadRequest downloadRequest) {
        if (downloadRequest.url == null) {
            return;
        }
        try {
            if (!this.isFileCurrentDownload(downloadRequest.url)) {
                this.mThreadPoolExecutor.execute(new DownloadMapWorker(downloadRequest));
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void requestToFileDownload(DownloadRequest request) {
        if (request.filepath == null) {
            return;
        }
        try {
            if (!this.isFileCurrentDownload(request.filepath)) {
                this.mThreadPoolExecutor.execute(new DownloadFileWorker(request));
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class DownloadFileWorker
    implements Runnable,
    Comparable<DownloadFileWorker> {
        private DownloadRequest request;

        private DownloadFileWorker(DownloadRequest request) {
            this.request = request;
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            if (this.request != null && this.request.url != null) {
                block13: {
                    if (MapTileDownloader.this.mCurrentDownload.contains(this.request.filepath)) {
                        return;
                    }
                    MapTileDownloader.this.mCurrentDownload.add(this.request.filepath);
                    FileInputStream fileInputStream = null;
                    try {
                        File file = new File(this.request.filepath);
                        fileInputStream = new FileInputStream(file);
                        BitmapFactory.Options options = new BitmapFactory.Options();
                        options.inPurgeable = true;
                        options.inDither = true;
                        this.request.fileToSave = BitmapFactory.decodeStream((InputStream)fileInputStream);
                        fileInputStream.close();
                    }
                    catch (OutOfMemoryError e) {
                        this.request.setError(true);
                        this.request.memoryErr = true;
                        MapTileDownloader.this.mCurrentDownload.remove(this.request.filepath);
                        break block13;
                    }
                    catch (IOException e) {
                        this.request.setError(true);
                        break block13;
                    }
                    catch (Exception e) {
                        this.request.setError(true);
                        MapTileDownloader.this.mCurrentDownload.remove(this.request.filepath);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        break block13;
                    }
                    {
                        finally {
                            MapTileDownloader.this.mCurrentDownload.remove(this.request.filepath);
                        }
                    }
                    MapTileDownloader.this.mCurrentDownload.remove(this.request.filepath);
                }
                if (this.request.matchzoom) {
                    for (IMapDownloaderCallback c : new ArrayList(MapTileDownloader.this.mCallback)) {
                        c.tileDownloaded(this.request);
                    }
                }
            }
        }

        @Override
        public int compareTo(DownloadFileWorker another) {
            return 0;
        }
    }

    private class DownloadMapWorker
    implements Runnable,
    Comparable<DownloadMapWorker> {
        private DownloadRequest request = null;

        private DownloadMapWorker(DownloadRequest request) {
            if (request != null) {
                this.request = request;
            }
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[DOLOOP]], but top level block is 24[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public int compareTo(DownloadMapWorker o) {
            return 0;
        }
    }

    public class DownloadRequest {
        public Bitmap fileToSave = null;
        public final int zoom;
        public final int xTile;
        public final int yTile;
        public final String url;
        public boolean error = false;
        public boolean memoryErr = false;
        public final ITileOrigin tileSource;
        public final int type;
        public int retry = 0;
        public String filepath = "";
        public boolean matchzoom = true;

        public DownloadRequest(String url, Bitmap fileToSave, int xTile, int yTile, int zoom, ITileOrigin tileSource, int _type) {
            this.url = url;
            this.fileToSave = fileToSave;
            this.xTile = xTile;
            this.yTile = yTile;
            this.zoom = zoom;
            this.tileSource = tileSource;
            this.type = _type;
        }

        public DownloadRequest(String url, Bitmap fileToSave, ITileOrigin tileSource, int _type) {
            this.url = url;
            this.fileToSave = fileToSave;
            this.xTile = -1;
            this.yTile = -1;
            this.zoom = -1;
            this.tileSource = tileSource;
            this.type = _type;
        }

        public void setError(boolean error) {
            this.error = error;
        }
    }

    static class FlushedInputStream
    extends FilterInputStream {
        public FlushedInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public long skip(long n) throws IOException {
            long totalBytesSkipped = 0L;
            while (totalBytesSkipped < n) {
                long bytesSkipped = this.in.skip(n - totalBytesSkipped);
                if (bytesSkipped == 0L) {
                    int b = this.read();
                    if (b < 0) break;
                    bytesSkipped = 1L;
                }
                totalBytesSkipped += bytesSkipped;
            }
            return totalBytesSkipped;
        }
    }

    public static interface IMapDownloaderCallback {
        public void tileDownloaded(DownloadRequest var1);
    }

    public class TileLoadDownloadRequest
    extends DownloadRequest {
        public final String tileId;
        public final File dirWithTiles;
        public final ITileOrigin tileSource;
        public final int type;

        public TileLoadDownloadRequest(File dirWithTiles, String url, Bitmap fileToSave, String tileId, ITileOrigin source, int tileX, int tileY, int zoom, int _type) {
            super(url, fileToSave, tileX, tileY, zoom, source, _type);
            this.dirWithTiles = dirWithTiles;
            this.tileSource = source;
            this.tileId = tileId;
            this.type = _type;
        }
    }
}

