/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import com.skt.Tmap.TMapData;
import com.skt.Tmap.TMapPoint;
import com.skt.Tmap.TileSourceManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Properties;

public class MapUtils {
    public static String mApiKey = null;
    public static String mVersion = null;
    protected static boolean isVerifyApiKey = false;
    public static boolean mIsMapOp = false;
    public static boolean mIsMapPickat = false;
    private static boolean mIsMapInit = false;
    public static String mStrTileType = null;
    public static final String anCertifi = "anCertifi";
    public static final String anTileKoHd = "anTileKoHd";
    public static final String anTileKoSd = "anTileKoSd";
    public static final String anTileEnHd = "anTileEnHd";
    public static final String anTileCnHd = "anTileCnHd";
    public static final String anTileKoHc = "anTileKoHc";
    public static final String anTileBi = "anTileBi";
    public static final String anTileRtti = "anTileRtti";
    public int TileType = 2;
    private static double mMaxLon = 157.5;
    private static double mMinLon = 112.5;
    private static double mMaxLat = 55.776573;
    private static double mMinLat = 21.943045;

    public static void setInitMap(Context context) {
        if (!mIsMapInit) {
            mIsMapInit = true;
            Properties props = MapUtils.getProperties(context);
            String tileUrl = props.getProperty("tileUrl");
            String restUrl = props.getProperty("restUrl");
            String sdkType = props.getProperty("sdkType");
            String version = props.getProperty("version");
            TileSourceManager.setBaseUrl(tileUrl);
            TMapData.setBaseUrl(restUrl);
            mVersion = version;
            if ("OP".equalsIgnoreCase(sdkType)) {
                mIsMapOp = true;
            } else if ("Pickat".equalsIgnoreCase(sdkType)) {
                mIsMapPickat = true;
            } else {
                isVerifyApiKey = true;
            }
        }
    }

    public static void setTileType(String type) {
        mStrTileType = type;
    }

    private static Properties getProperties(Context context) {
        InputStream inputStream = null;
        try {
            AssetManager assetManager = context.getAssets();
            inputStream = assetManager.open("properties/config.properties");
            Properties props = new Properties();
            props.load(inputStream);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            Log.e((String)"IOException occur", (String)e.toString());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    Log.e((String)"IOException occur", (String)e.toString());
                }
            }
        }
        return null;
    }

    public static void closeStream(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static double getDistance(TMapPoint l, double latitude, double longitude) {
        return MapUtils.getDistance(l.getLatitude(), l.getLongitude(), latitude, longitude);
    }

    public static double getDistance(double lat1, double lon1, double lat2, double lon2) {
        double R = 6371.0;
        double dLat = Math.toRadians(lat2 - lat1);
        double dLon = Math.toRadians(lon2 - lon1);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return R * c * 1000.0;
    }

    public static double getDistance(TMapPoint l1, TMapPoint l2) {
        return MapUtils.getDistance(l1.getLatitude(), l1.getLongitude(), l2.getLatitude(), l2.getLongitude());
    }

    public static TMapPoint getWeightCenter(Collection<TMapPoint> nodes) {
        if (nodes.isEmpty()) {
            return null;
        }
        double longitude = 0.0;
        double latitude = 0.0;
        for (TMapPoint n : nodes) {
            longitude += n.getLongitude();
            latitude += n.getLatitude();
        }
        return new TMapPoint(latitude / (double)nodes.size(), longitude / (double)nodes.size());
    }

    public static double checkLongitude(double longitude) {
        while (longitude < -180.0 || longitude > 180.0) {
            if (longitude < 0.0) {
                longitude += 360.0;
                continue;
            }
            longitude -= 360.0;
        }
        return longitude;
    }

    public static double checkLatitude(double latitude) {
        while (latitude < -90.0 || latitude > 90.0) {
            if (latitude < 0.0) {
                latitude += 180.0;
                continue;
            }
            latitude -= 180.0;
        }
        return latitude;
    }

    public static double boundaryInLongitude(float zoom, double longitude) {
        if (zoom < 4.0f || longitude < mMinLon || longitude > mMaxLon) {
            int cnt = (int)Math.pow(2.0, zoom - 2.0f);
            double xTile = 3 * cnt;
            double minLon = MapUtils.getLongitudeFromTile(zoom, xTile + 1.0);
            double maxLon = MapUtils.getLongitudeFromTile(zoom, xTile + (double)cnt - 1.0);
            if (longitude < minLon || longitude > maxLon) {
                longitude = longitude < minLon ? minLon + 1.0E-4 : maxLon - 1.0E-4;
            }
        }
        return longitude;
    }

    protected static void setboundaryLon(float zoom) {
        int cnt = (int)Math.pow(2.0, zoom - 2.0f);
        double xTile = 3 * cnt;
        mMinLon = MapUtils.getLongitudeFromTile(zoom, xTile + 1.0);
        mMaxLon = MapUtils.getLongitudeFromTile(zoom, xTile + (double)cnt - 1.0);
    }

    protected static void setboundaryLat(float zoom) {
        int cnt = (int)Math.pow(2.0, zoom - 2.0f);
        int yTile = (int)Math.pow(2.0, zoom - 1.0f);
        mMinLat = Math.abs(MapUtils.getLatitudeTile(zoom, yTile + 1));
        mMaxLat = Math.abs(MapUtils.getLatitudeTile(zoom, yTile + cnt - 1));
    }

    public static double boundaryInLatitude(float zoom, double latitude) {
        if (zoom < 4.0f || latitude < mMinLat || latitude > mMaxLat) {
            int cnt = (int)Math.pow(2.0, zoom - 2.0f);
            int yTile = (int)Math.pow(2.0, zoom - 1.0f);
            double minLat = Math.abs(MapUtils.getLatitudeTile(zoom, yTile + 1));
            double maxLat = Math.abs(MapUtils.getLatitudeTile(zoom, yTile + cnt - 1));
            if (latitude < minLat || latitude > maxLat) {
                latitude = latitude < minLat ? minLat + 1.0E-4 : maxLat - 1.0E-4;
            }
        }
        return latitude;
    }

    public double getTileNumberX(float zoom, double longitude, double latitude) {
        longitude = MapUtils.checkLongitude(longitude);
        return (longitude + 180.0) / 360.0 * MapUtils.getPowZoom(zoom);
    }

    public double getTileNumberY(float zoom, double longitude, double latitude) {
        double eval = Math.log(Math.tan(Math.toRadians(latitude = MapUtils.checkLatitude(latitude))) + 1.0 / Math.cos(Math.toRadians(latitude)));
        if (Double.isInfinite(eval) || Double.isNaN(eval)) {
            latitude = latitude < 0.0 ? -89.9 : 89.9;
            eval = Math.log(Math.tan(Math.toRadians(latitude)) + 1.0 / Math.cos(Math.toRadians(latitude)));
        }
        double result = (1.0 - eval / Math.PI) / 2.0 * MapUtils.getPowZoom(zoom);
        return result;
    }

    public static double getLongitudeFromTile(float zoom, double x) {
        return x / MapUtils.getPowZoom(zoom) * 360.0 - 180.0;
    }

    public double getLongitudeFromTile(float zoom, double x, double y) {
        return x / MapUtils.getPowZoom(zoom) * 360.0 - 180.0;
    }

    public static double getPowZoom(float zoom) {
        if (zoom >= 0.0f && (double)zoom - Math.floor(zoom) < (double)0.05f) {
            return 1 << (int)zoom;
        }
        return Math.pow(2.0, zoom);
    }

    public static double getLatitudeTile(float zoom, double y) {
        int signValue = y < 0.0 ? -1 : 1;
        double resultValue = Math.atan((double)signValue * Math.sinh(Math.PI * (1.0 - 2.0 * y / MapUtils.getPowZoom(zoom)))) * 180.0 / Math.PI;
        return resultValue;
    }

    public double getLatitudeTile(float zoom, double x, double y) {
        return Math.atan(Math.sinh(Math.PI * (1.0 - 2.0 * y / MapUtils.getPowZoom(zoom)))) * 180.0 / Math.PI;
    }

    public int getLengthXMeters(float zoom, double latitude, double longitude, double meters, float tileSize, int widthOfDisplay) {
        double tileX = this.getTileNumberX(zoom, longitude, latitude);
        double tileY = this.getTileNumberY(zoom, longitude, latitude);
        double tileLeft = tileX - (double)widthOfDisplay / (2.0 * (double)tileSize);
        double tileRight = tileX + (double)widthOfDisplay / (2.0 * (double)tileSize);
        double dist = MapUtils.getDistance(latitude, this.getLongitudeFromTile(zoom, tileLeft, tileY), latitude, this.getLongitudeFromTile(zoom, tileRight, tileY));
        return (int)((double)widthOfDisplay / dist * meters);
    }

    public int getPixelX(int z, double lon1, double lon2, int size) {
        return (int)((this.getTileNumberX(z, lon1, 0.0) - this.getTileNumberX(z, lon2, 0.0)) * (double)size);
    }

    public int getPixelY(int z, double lat1, double lat2, int size) {
        return (int)((this.getTileNumberY(z, 0.0, lat1) - this.getTileNumberY(z, 0.0, lat2)) * (double)size);
    }

    public static String getFormattedDistance(int meters) {
        if (meters >= 100000) {
            return String.valueOf(meters / 1000) + " " + "KM";
        }
        if (meters >= 10000) {
            return MessageFormat.format("{0,number,#.#} KM", Float.valueOf((float)meters / 1000.0f));
        }
        if (meters > 1500) {
            return MessageFormat.format("{0,number,#.#} KM", Float.valueOf((float)meters / 1000.0f));
        }
        if (meters > 900) {
            return MessageFormat.format("{0,number,#.##} KM", Float.valueOf((float)meters / 1000.0f));
        }
        return String.valueOf(meters) + " " + "M";
    }
}

