/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.graphics.Canvas;
import android.graphics.CornerPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.skt.Tmap.MapUtils;
import com.skt.Tmap.TMapCircle;
import com.skt.Tmap.TMapLayer;
import com.skt.Tmap.TMapView;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class TMapCircleLayer
implements TMapLayer {
    public Map<String, TMapCircle> mCircles = new LinkedHashMap<String, TMapCircle>();
    private TMapView view = null;
    private DisplayMetrics dm = null;
    private Paint paintCircle_FILL = null;
    private Paint paintCircle_STROKE = null;
    private Paint paintRadius = null;
    private Paint paintRadiusText = null;

    @Override
    public void initLayer(TMapView view) {
        this.view = view;
        this.dm = new DisplayMetrics();
        WindowManager wmgr = (WindowManager)view.getContext().getSystemService("window");
        wmgr.getDefaultDisplay().getMetrics(this.dm);
        this.paintCircle_FILL = new Paint();
        this.paintCircle_FILL.setStyle(Paint.Style.FILL);
        this.paintCircle_STROKE = new Paint();
        this.paintCircle_STROKE.setStyle(Paint.Style.STROKE);
        this.paintRadius = new Paint();
        this.paintRadius.setColor(-65536);
        this.paintRadius.setStyle(Paint.Style.FILL);
        this.paintRadius.setAlpha(100);
        this.paintRadius.setPathEffect((PathEffect)new CornerPathEffect(16.0f));
        this.paintRadiusText = new Paint();
        this.paintRadiusText.setColor(-16777216);
        this.paintRadiusText.setTextSize(20.0f);
        this.paintRadiusText.setStyle(Paint.Style.STROKE);
        this.paintRadiusText.setTypeface(Typeface.create(null, (int)1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Canvas canvas, RectF latlonRect, boolean nightMode) {
        Map<String, TMapCircle> map = this.mCircles;
        synchronized (map) {
            ArrayList<String> list = new ArrayList<String>(this.mCircles.keySet());
            int i = 0;
            while (i < list.size()) {
                this.paintCircle_FILL.setColor(this.mCircles.get(list.get(i)).getAreaColor());
                this.paintCircle_FILL.setAlpha(this.mCircles.get(list.get(i)).getAreaAlpha());
                this.paintCircle_STROKE.setColor(this.mCircles.get(list.get(i)).getLineColor());
                this.paintCircle_STROKE.setAlpha(this.mCircles.get(list.get(i)).getLineAlpha());
                this.paintCircle_STROKE.setStrokeWidth(this.mCircles.get(list.get(i)).getCircleWidth());
                int x = this.view.getMapXForPoint(this.mCircles.get((Object)list.get((int)i)).longitude, this.mCircles.get((Object)list.get((int)i)).latitude);
                int y = this.view.getMapYForPoint(this.mCircles.get((Object)list.get((int)i)).longitude, this.mCircles.get((Object)list.get((int)i)).latitude);
                float r = (float)this.mCircles.get(list.get(i)).getRadius();
                int radius = this.view.mapUtils.getLengthXMeters(this.view.getZoom(), this.view.getLatitude(), this.view.getLongitude(), r, this.view.getTileSize(), this.view.getWidth());
                canvas.drawCircle((float)x, (float)y, (float)radius, this.paintCircle_FILL);
                canvas.drawCircle((float)x, (float)y, (float)radius, this.paintCircle_STROKE);
                if (this.mCircles.get(list.get(i)).getRadiusVisible()) {
                    canvas.drawText(MapUtils.getFormattedDistance((int)r), (float)(x + radius - 70), (float)(y + 10), this.paintRadiusText);
                }
                ++i;
            }
        }
    }

    @Override
    public void destroyTMapLayer() {
    }

    @Override
    public boolean onTouchEvent(PointF point) {
        return false;
    }

    @Override
    public boolean onLongPressEvent(PointF point) {
        return false;
    }

    @Override
    public boolean drawInScreenPixels() {
        return false;
    }
}

