/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.content.Context;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import com.skt.Tmap.TMapPoint;

public class TMapGpsManager {
    private Context Tcontext;
    public static final String GPS_PROVIDER = "gps";
    public static final String NETWORK_PROVIDER = "network";
    public static final String LOCATION_SERVICE = "location";
    private double latitude = 0.0;
    private double longitude = 0.0;
    private String ProviderType = "gps";
    private long minTime = 1000L;
    private float minDistance = 5.0f;
    private int satellite = 0;
    private LocationManager LocationService;
    private onLocationChangedCallback Callback = null;
    private LocationListener GpsListener = new LocationListener(){

        public void onLocationChanged(Location location) {
            TMapGpsManager.this.latitude = location.getLatitude();
            TMapGpsManager.this.longitude = location.getLongitude();
            if (TMapGpsManager.this.Callback != null) {
                TMapGpsManager.this.Callback.onLocationChange(location);
            }
        }

        public void onProviderDisabled(String provider) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }
    };
    GpsStatus.NmeaListener m_nmea_listener = new GpsStatus.NmeaListener(){

        public void onNmeaReceived(long timestamp, String nmea) {
            try {
                String[] str_temp = nmea.split(",");
                if (str_temp[0].equals("$GPGGA") && !str_temp[7].toString().trim().equals("")) {
                    if (str_temp[7].indexOf(".") == -1) {
                        TMapGpsManager.this.satellite = Integer.parseInt(str_temp[7]);
                    } else {
                        TMapGpsManager.this.satellite = Integer.parseInt(str_temp[7].substring(0, str_temp[7].indexOf(".")));
                    }
                }
            }
            catch (Exception e) {
                TMapGpsManager.this.satellite = 0;
            }
        }
    };

    public TMapGpsManager(Context context) {
        this.Tcontext = context;
        this.LocationService = (LocationManager)context.getSystemService(LOCATION_SERVICE);
        try {
            this.Callback = (onLocationChangedCallback)context;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean setLocationCallback() {
        try {
            this.Callback = (onLocationChangedCallback)this.Tcontext;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void OpenGps() {
        if (this.ProviderType.equals(GPS_PROVIDER)) {
            this.LocationService.requestLocationUpdates(GPS_PROVIDER, this.minTime, this.minDistance, this.GpsListener);
        } else {
            this.LocationService.requestLocationUpdates(NETWORK_PROVIDER, this.minTime, this.minDistance, this.GpsListener);
        }
        this.LocationService.addNmeaListener(this.m_nmea_listener);
    }

    public void CloseGps() {
        this.LocationService.removeUpdates(this.GpsListener);
    }

    public void setProvider(String type) {
        this.ProviderType = type;
    }

    public String getProvider() {
        return this.ProviderType;
    }

    public void setMinTime(long mintime) {
        this.minTime = mintime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public void setMinDistance(float mindistance) {
        this.minDistance = mindistance;
    }

    public float getMinDistance() {
        return this.minDistance;
    }

    public TMapPoint getLocation() {
        return new TMapPoint(this.latitude, this.longitude);
    }

    public int getSatellite() {
        return this.satellite;
    }

    public static interface onLocationChangedCallback {
        public void onLocationChange(Location var1);
    }
}

