package com.example.admin.s20172285_1008_02;

        import android.graphics.Color;
        import android.location.Location;
        import android.location.LocationListener;
        import android.media.ExifInterface;
        import android.support.v7.app.AppCompatActivity;
        import android.os.Bundle;
        import android.util.Log;
        import android.view.View;
        import android.widget.Button;
        import android.widget.LinearLayout;
        import android.widget.Toast;

        import com.skt.Tmap.TMapData;
        import com.skt.Tmap.TMapGpsManager;
        import com.skt.Tmap.TMapMarkerItem;
        import com.skt.Tmap.TMapPOIItem;
        import com.skt.Tmap.TMapPoint;
        import com.skt.Tmap.TMapPolyLine;
        import com.skt.Tmap.TMapView;

        import java.io.File;
        import java.io.IOException;
        import java.util.ArrayList;

public class MainActivity extends AppCompatActivity implements TMapView.OnLongClickListenerCallback,
        LocationListener,TMapGpsManager.onLocationChangedCallback{
    private TMapView tMapView= null;
    TMapGpsManager gps =null;
    public static String mApikey = null;
    public static String mBizAppID=null;
    private static final String TAG ="Test Temp";

    TMapData tMapData;
    TMapPoint point2;
    Double IntnewLati;
    Double IntnewLong;

    ExifInterface exif =null;
    File photo;
    Button btn;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        LinearLayout liner =(LinearLayout) findViewById(R.id.linear);
        btn=(Button) findViewById(R.id.btn);

        tMapView=new TMapView(this);
        mApikey="20f65378-ed7f-4148-ac91-bfff34cca044";
        tMapView.setSKTMapApiKey(mApikey);
        liner.addView(tMapView);
        setContentView(liner);

        tMapView.setZoomLevel(16);
        tMapView.setCompassMode(true);
        tMapView.setSightVisible(true);
        tMapView.setMapPosition(TMapView.POSITION_NAVI);
        tMapView.setTrackingMode(true);

        gps=new TMapGpsManager(MainActivity.this);
        gps.setMinTime(1);
        gps.setMinDistance(1);
        gps.setProvider(gps.NETWORK_PROVIDER);
        gps.OpenGps();

        IntnewLati = tMapView.getLatitude();
        IntnewLong = tMapView.getLongitude();

        tMapData = new TMapData();

        String newFilename = "storage/emulated/0/DCIM/Camera/pos01.jpg";
        photo=new File(newFilename);

        btn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try{
                    exif= new ExifInterface(photo.getCanonicalPath());
                    String lati =exif.getAttribute(ExifInterface.TAG_GPS_LATITUDE);
                    String longi =exif.getAttribute(ExifInterface.TAG_GPS_LONGITUDE);

                    String latiArray[] = lati.split(",");
                    String latiAArray0[] = latiArray[0].split("/");
                    String latiAArray1[] = latiArray[1].split("/");
                    String latiAArray2[] = latiArray[2].split("/");

                    String longiArray[] = longi.split(",");
                    String longiAArray0[] = longiArray[0].split("/");
                    String longiAArray1[] = longiArray[1].split("/");
                    String longiAArray2[] = longiArray[2].split("/");

                    IntnewLati = Double.parseDouble(latiAArray0[0])+
                            Double.parseDouble(latiAArray1[0])/60
                            +Double.parseDouble(latiAArray2[0])/3600;

                    IntnewLong = Double.parseDouble(longiAArray0[0])+
                            Double.parseDouble(longiAArray1[0])/60
                            +Double.parseDouble(longiAArray2[0])/3600;

                    String StrnewLati = String.valueOf(IntnewLati);
                    String StrnewLong = String.valueOf(IntnewLong);


                    Toast.makeText(getApplicationContext(),StrnewLati+ ","+
                            StrnewLong, Toast.LENGTH_SHORT).show();
                }catch (IOException e){
                    e.printStackTrace();
                }
            }
        });
    }


    @Override
    public void onLocationChanged(Location location){

    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras){

    }

    @Override
    public void onProviderEnabled(String provider){

    }

    @Override
    public void onProviderDisabled(String provider){

    }

    @Override
    public void onLongPressEvent(ArrayList<TMapMarkerItem>arrayList,
                                 ArrayList<TMapPOIItem> arrayList1, TMapPoint tMapPoint){

    }

    @Override
    public void onLocationChange(Location location){
        tMapView.setCenterPoint(location.getLongitude(), location.getLatitude());
        tMapView.setLocationPoint(location.getLongitude(), location.getLatitude());

        btn.callOnClick();

        TMapPoint point1 = tMapView.getCenterPoint();

        point2 =new TMapPoint(IntnewLati,IntnewLong);

        Toast.makeText(getApplicationContext(), "위치변경됨", Toast.LENGTH_SHORT).show();

        tMapData.findPathDataWithType(TMapData.TMapPathType.CAR_PATH,
                point1, point2, new TMapData.FindPathDataListenerCallback() {
                    @Override
                    public void onFindPathData(TMapPolyLine polyLine) {
                        polyLine.setLineWidth(20);
                        polyLine.setOutLineColor(Color.LTGRAY);
                        tMapView.addTMapPath(polyLine);
                    }
                });

        tMapData.setResponseCodeInfoCallBack(new TMapData.OnResponseCodeInfoCallback() {
            @Override
            public void responseCodeInfo(String s, int i, String s1) {
                Log.d(TAG, Thread.currentThread().getStackTrace()[2].getFileName()+"/"+
                Thread.currentThread().getStackTrace()[2].getMethodName()+"/"+
                Thread.currentThread().getStackTrace()[2].getLineNumber()+
                " : API is "+s+ "ResponseCode is "+ i);
            }
        });
    }
}
