<%@ page language="java" contentType="text/html; charset=UTF-8"
    pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>    

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Insert title here</title>
</head>
<body>

<fmt:formatNumber value="123456789" type="number" />
<fmt:formatNumber value="1000" type="currency" currencySymbol="$" />
<fmt:formatNumber value="0.5" type="percent" />
<fmt:formatNumber value="3.141592" pattern=".0"/>

<c:set var="today" value="<%= new java.util.Date()  %>"></c:set>
\${today} = ${today}<br>
<fmt:formatDate value="${today}" type="date"/>
<fmt:formatDate value="${today}" type="time"/>
<fmt:formatDate value="${today}" type="both"/>
<fmt:formatDate value="${today}" type="both" pattern="yyyy-MM-dd HH*mm*ss"/>


<jsp:useBean id="now" class="java.util.Date"/>

<pre>

<!-- 물체=> 같은시간에 있는 사용지역을 묶어서 처리-->
defalt:<c:out value="${now}"></c:out>
Korea KST: <fmt:formatDate value="${now}" type="both" dateStyle="full" timeStyle="full"/>

<fmt:timeZone value="GMT_8">
NewYork GMT-8:<fmt:formatDate value="${now}" type="both" dateStyle="full" timeStyle="full"/>
</fmt:timeZone>

</pre>

<!-- 해당국가의 날짜와 시간을 출력 => setlocale -->
<c:set var="now" value="<%=new java.util.Date() %>" />

<pre>
톰캣지정 기본 로케일: <%=response.getLocale() %>

<fmt:setLocale value="ko_kr"/>
한국식 로케일: <%=response.getLocale() %>
한국식 통화기호: <fmt:formatNumber value="10000" type="currency"/>
한국식 날짜 : <fmt:formatDate value="${now}" type="both"/>

<fmt:setLocale value="en_us"/>
미국식 로케일: <%=response.getLocale() %>
미국식 통화기호: <fmt:formatNumber value="10000" type="currency"/>
미국식 날짜 : <fmt:formatDate value="${now}" type="both"/>

</pre>

<!-- 입력 폼에서 한글이 깨지지 않고 읽어오기 -->
<form method="post" action="fmt_2.jsp">

이름: <input type="text" name="name">
<input type="submit" value="전송">
</form>
</body>
</html>