/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.WindowManager;
import com.skt.Tmap.ITileOrigin;
import com.skt.Tmap.LruCacheSave;
import com.skt.Tmap.MapTileDownloader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class ResourceManager {
    public String PackageName = "";
    public String TILES_PATH_HD = null;
    private static String baseUrl = null;
    public int MaxTileNum = 4;
    public int AddTileNum = 2;
    private String mRoute = "/data/data/";
    private LruCacheSave<String, Bitmap> cacheOfImages = null;
    protected ArrayList<String> nameInFS = new ArrayList();
    protected StringBuilder builder = new StringBuilder(40);
    public MapTileDownloader downloader = null;

    public static void setBaseUrl(String url) {
        baseUrl = url;
    }

    public ResourceManager(Context context, String packagename, MapTileDownloader downloader) {
        this.downloader = downloader;
        this.PackageName = packagename;
        this.TILES_PATH_HD = String.valueOf(this.mRoute) + this.PackageName + "/skttiles_hd";
        WindowManager wmgr = (WindowManager)context.getSystemService("window");
        int cacheSize = 0;
        int tileSize = 1024;
        int w = wmgr.getDefaultDisplay().getWidth();
        int h = wmgr.getDefaultDisplay().getHeight();
        double viewWidth = w < h ? h : w;
        double halfTileNum = Math.ceil(viewWidth / 1024.0);
        double tileNum = halfTileNum + halfTileNum + 1.0;
        cacheSize = (int)(1024.0 * tileNum * tileNum);
        this.cacheOfImages = new LruCacheSave<String, Bitmap>(cacheSize){

            protected int sizeOf(String key, Bitmap bitmap) {
                int byteCount = bitmap.getRowBytes() * bitmap.getHeight();
                return byteCount / 1024;
            }
        };
        this.deleteCacheTile();
    }

    public void deleteCacheTile() {
        this.removeTileImageFromCache();
        File parent_hd = new File(this.TILES_PATH_HD);
        if (parent_hd.isDirectory()) {
            if (parent_hd.listFiles() != null && parent_hd.listFiles().length > 0) {
                File[] fileArray = parent_hd.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    file.delete();
                    ++n2;
                }
            }
            parent_hd = null;
        }
        this.nameInFS.clear();
    }

    public void resetNameInFS(int type) {
        File file;
        int n;
        int n2;
        File[] fileArray;
        this.nameInFS.clear();
        File parent = null;
        File parent_hd = new File(this.TILES_PATH_HD);
        if (parent_hd.isDirectory()) {
            if (parent_hd.listFiles() != null && parent_hd.listFiles().length > 0) {
                fileArray = parent_hd.listFiles();
                n2 = fileArray.length;
                n = 0;
                while (n < n2) {
                    file = fileArray[n];
                    file.delete();
                    ++n;
                }
            }
            parent_hd = null;
        }
        if (!(parent = new File(this.TILES_PATH_HD)).isDirectory()) {
            parent.mkdirs();
        } else {
            if (parent.listFiles() != null && parent.listFiles().length > 0) {
                fileArray = parent.listFiles();
                n2 = fileArray.length;
                n = 0;
                while (n < n2) {
                    file = fileArray[n];
                    this.nameInFS.add(file.getName());
                    ++n;
                }
            }
            parent = null;
        }
    }

    public synchronized String calculateTileId(ITileOrigin map, int x, int y, int zoom) {
        this.builder.setLength(0);
        this.builder.append(zoom).append('_').append(x).append('_').append(y).append(map == null ? ".jpg" : map.getTileFormatData());
        return this.builder.toString();
    }

    public Bitmap getTileImageForMapAsync(String file, ITileOrigin map, int x, int y, int zoom, boolean loadFromInternetIfNeeded) {
        return this.getTileImageForMap(file, map, x, y, zoom, loadFromInternetIfNeeded, false, true);
    }

    protected Bitmap getTileImageForMap(String file, ITileOrigin map, int x, int y, int zoom, boolean loadFromInternetIfNeeded, boolean sync, boolean loadFromFs) {
        return this.getTileImageForMap(file, map, x, y, zoom, loadFromInternetIfNeeded, sync, loadFromFs, false);
    }

    protected synchronized Bitmap getTileImageForMap(String tileId, ITileOrigin map, int x, int y, int zoom, boolean loadFromInternetIfNeeded, boolean sync, boolean loadFromFs, boolean deleteBefore) {
        if (tileId == null) {
            tileId = this.calculateTileId(map, x, y, zoom);
        }
        if (this.cacheOfImages.getCache(tileId) == null) {
            String url = loadFromInternetIfNeeded ? map.getUrlLoadData(x, y, zoom) : null;
            MapTileDownloader mapTileDownloader = this.downloader;
            mapTileDownloader.getClass();
            MapTileDownloader.TileLoadDownloadRequest req = new MapTileDownloader.TileLoadDownloadRequest(mapTileDownloader, null, url, null, tileId, map, x, y, zoom, 0);
            if (sync) {
                return this.getRequestedImageTile(req);
            }
            return null;
        }
        return this.cacheOfImages.getCache(tileId);
    }

    private Bitmap getRequestedImageTile(MapTileDownloader.TileLoadDownloadRequest req) {
        if (req.tileId == null) {
            return null;
        }
        if (this.nameInFS.contains(req.tileId)) {
            req.filepath = String.valueOf(this.TILES_PATH_HD) + "/" + req.tileId;
            this.downloader.requestToFileDownload(req);
        } else if (this.cacheOfImages.getCache(req.tileId) == null && req.url != null) {
            this.downloader.downloadRequest(req);
        }
        return null;
    }

    public void insertImage(final String filename, final Bitmap bitmap) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<String> arrayList = ResourceManager.this.nameInFS;
                synchronized (arrayList) {
                    if (ResourceManager.this.nameInFS.size() > 30) {
                        try {
                            int i = 0;
                            while (i < 10) {
                                new File(String.valueOf(ResourceManager.this.TILES_PATH_HD) + "/" + ResourceManager.this.nameInFS.get(i)).delete();
                                ResourceManager.this.nameInFS.remove(i);
                                ++i;
                            }
                        }
                        catch (Exception i) {
                            // empty catch block
                        }
                    }
                    if (!ResourceManager.this.nameInFS.contains(filename)) {
                        try {
                            FileOutputStream out = new FileOutputStream(String.valueOf(ResourceManager.this.TILES_PATH_HD) + "/" + filename);
                            bitmap.compress(Bitmap.CompressFormat.PNG, 60, (OutputStream)out);
                            out.close();
                            ResourceManager.this.nameInFS.add(filename);
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTileImageFromCache(String tileId, Bitmap bmp) {
        try {
            LruCacheSave<String, Bitmap> lruCacheSave = this.cacheOfImages;
            synchronized (lruCacheSave) {
                if (this.cacheOfImages.getCache(tileId) == null) {
                    this.cacheOfImages.putCache(tileId, bmp);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeTileImageFromCache() {
        if (this.cacheOfImages.getSize() > 0) {
            this.cacheOfImages.allEvict();
        }
    }

    public Bitmap getTileImageFromCache(String file) {
        try {
            return this.cacheOfImages.getCache(file);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Bitmap getTileImageForMapSync(String file, ITileOrigin map, int x, int y, int zoom, boolean loadFromInternetIfNeeded) {
        return this.getTileImageForMap(file, map, x, y, zoom, loadFromInternetIfNeeded, true, true);
    }

    public class Traffice {
        private Bitmap tileBitmap;
        private long nTime;

        public Traffice(Bitmap tile, long time) {
            this.tileBitmap = tile;
            this.nTime = time;
        }

        public Bitmap getTrafficeTile() {
            return this.tileBitmap;
        }

        public long getloadTime() {
            return this.nTime;
        }
    }
}

