/*
 * Decompiled with CFR 0.152.
 */
package com.skt.Tmap;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.skt.Tmap.TMapLayer;
import com.skt.Tmap.TMapMarkerItem;
import com.skt.Tmap.TMapView;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class TMapMarkerItemLayer
implements TMapLayer {
    public Map<String, TMapMarkerItem> mMarkerItems = new LinkedHashMap<String, TMapMarkerItem>();
    public Map<String, TMapMarkerItem> mClusterItem = new LinkedHashMap<String, TMapMarkerItem>();
    private TMapView view = null;
    private DisplayMetrics dm = null;
    private int mDisplayWidth = 0;
    private boolean isRotate = true;
    private ArrayList<TMapMarkerItem> clickMarkeritem = new ArrayList();
    private Drawable info_box_tail = null;
    private LinearLayout popupLayout = null;
    private ImageView leftImage = null;
    private TextView textTitle = null;
    private TextView textSubTitle = null;
    private ImageView rightImage = null;
    public boolean bShowCallot = false;
    public String showcallot_id = "";
    private int xCallout = 0;
    private int yCallout = 0;
    private int wCallout = 0;
    private int hCallout = 0;
    private int nInfo_box_tail_width = 0;
    private int nInfo_box_tail_height = 0;
    private int fontTitleHeight = 0;
    private int fontSubTitleHeight = 0;
    private Context mContext = null;
    private int layoutResId = 0;
    private boolean mMoveMap = false;
    private boolean bAutoVisible = false;

    public TMapMarkerItemLayer(Context context) {
        this.mContext = context;
    }

    @Override
    public void initLayer(TMapView view) {
        this.view = view;
        this.dm = new DisplayMetrics();
        WindowManager wmgr = (WindowManager)view.getContext().getSystemService("window");
        wmgr.getDefaultDisplay().getMetrics(this.dm);
        this.mDisplayWidth = wmgr.getDefaultDisplay().getWidth();
        Bitmap bmp = this.makeBitmap("info_box_tail_bottom", true);
        this.info_box_tail = new BitmapDrawable(bmp);
        this.info_box_tail.setBounds(0, 0, this.info_box_tail.getMinimumWidth(), this.info_box_tail.getMinimumHeight());
        this.nInfo_box_tail_width = this.info_box_tail.getMinimumWidth();
        this.nInfo_box_tail_height = this.info_box_tail.getMinimumHeight();
        this.popupLayout = new LinearLayout(this.mContext);
        this.layoutResId = 100;
        Bitmap bmp_layoutback = this.makeBitmap("info_box", false);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        this.popupLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.popupLayout.setOrientation(0);
        this.popupLayout.setBackgroundDrawable((Drawable)new BitmapDrawable(bmp_layoutback));
        this.leftImage = new ImageView(this.mContext);
        params = new RelativeLayout.LayoutParams(-2, -2);
        this.leftImage.setLayoutParams((ViewGroup.LayoutParams)params);
        this.popupLayout.addView((View)this.leftImage);
        this.textTitle = new TextView(view.getContext());
        params = new RelativeLayout.LayoutParams(-2, -2);
        this.textTitle.setLayoutParams((ViewGroup.LayoutParams)params);
        this.textTitle.setTextColor(-1);
        this.textTitle.setTextSize(14.0f);
        this.textTitle.setSingleLine(true);
        this.textTitle.setEllipsize(TextUtils.TruncateAt.END);
        Paint.FontMetrics fm = this.textTitle.getPaint().getFontMetrics();
        this.fontTitleHeight = (int)Math.ceil(Math.abs(fm.bottom) + Math.abs(fm.top));
        this.textSubTitle = new TextView(view.getContext());
        params = new RelativeLayout.LayoutParams(-2, -2);
        this.textSubTitle.setLayoutParams((ViewGroup.LayoutParams)params);
        this.textSubTitle.setTextColor(-1);
        this.textSubTitle.setTextSize(12.0f);
        this.textSubTitle.setSingleLine(true);
        this.textSubTitle.setEllipsize(TextUtils.TruncateAt.END);
        fm = this.textSubTitle.getPaint().getFontMetrics();
        this.fontSubTitleHeight = (int)Math.ceil(Math.abs(fm.bottom) + Math.abs(fm.top));
        this.popupLayout.addView((View)this.textTitle);
        this.popupLayout.addView((View)this.textSubTitle);
        this.rightImage = new ImageView(this.mContext);
        params = new RelativeLayout.LayoutParams(-2, -2);
        this.rightImage.setLayoutParams((ViewGroup.LayoutParams)params);
        this.popupLayout.addView((View)this.rightImage);
        this.hCallout = this.fontTitleHeight + this.fontSubTitleHeight + this.dp2px(10.0f);
        this.bAutoVisible = true;
    }

    public Bitmap makeBitmap(String imgName, boolean isSizeUp) {
        Bitmap bitmap = null;
        AssetManager assetmanager = this.mContext.getResources().getAssets();
        try {
            InputStream is = assetmanager.open(String.valueOf(imgName) + ".png", 3);
            bitmap = BitmapFactory.decodeStream((InputStream)is);
            is.close();
        }
        catch (Exception is) {
            // empty catch block
        }
        if (isSizeUp) {
            int width = this.dp2px(bitmap.getWidth());
            int height = this.dp2px(bitmap.getHeight());
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        }
        return bitmap;
    }

    public int dp2px(float dp) {
        float density;
        if (this.dm == null) {
            this.dm = new DisplayMetrics();
            WindowManager wmgr = (WindowManager)this.view.getContext().getSystemService("window");
            wmgr.getDefaultDisplay().getMetrics(this.dm);
            this.mDisplayWidth = wmgr.getDefaultDisplay().getWidth();
        }
        if ((double)(density = this.dm.density) < 1.5) {
            density = 1.0f;
        }
        return (int)(density * dp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Canvas canvas, RectF TMapPointRect, boolean nightMode) {
        if (this.view.getEnableClustering()) {
            this.onClusterDraw(canvas);
            return;
        }
        try {
            Map<String, TMapMarkerItem> map = this.mMarkerItems;
            synchronized (map) {
                ArrayList<String> list = new ArrayList<String>(this.mMarkerItems.keySet());
                int x = 0;
                int y = 0;
                float xPos = 0.0f;
                float yPos = 0.0f;
                int nPos_x = 0;
                int nPos_y = 0;
                int nMarkerIconWidth = 0;
                int nMarkerIconHeight = 0;
                int marginX = 0;
                int marginY = 0;
                Rect rect = null;
                Bitmap icon = null;
                int i = 0;
                while (i < list.size()) {
                    try {
                        if (this.mMarkerItems.get(list.get(i)) != null && this.mMarkerItems.get(list.get(i)).getVisible() == 2) {
                            icon = this.mMarkerItems.get(list.get(i)).getIcon();
                            if (icon == null) {
                                icon = this.view.getDefaultIcon();
                            }
                            if (this.isRotate) {
                                x = this.view.getRotatedMapXForPoint(this.mMarkerItems.get((Object)list.get((int)i)).latitude, this.mMarkerItems.get((Object)list.get((int)i)).longitude);
                                y = this.view.getRotatedMapYForPoint(this.mMarkerItems.get((Object)list.get((int)i)).latitude, this.mMarkerItems.get((Object)list.get((int)i)).longitude);
                                xPos = this.mMarkerItems.get(list.get(i)).getPositionX();
                                yPos = this.mMarkerItems.get(list.get(i)).getPositionY();
                                nMarkerIconWidth = icon.getWidth();
                                nMarkerIconHeight = icon.getHeight();
                                nPos_x = (int)(xPos * (float)nMarkerIconWidth);
                                nPos_y = (int)(yPos * (float)nMarkerIconHeight);
                                marginX = nPos_x == 0 ? nMarkerIconWidth / 2 : nPos_x;
                                marginY = nPos_y == 0 ? nMarkerIconHeight / 2 : nPos_y;
                                canvas.save();
                                canvas.rotate(-this.view.getRotateData(), (float)this.view.getCenterPointX(), (float)this.view.getCenterPointY());
                                canvas.translate((float)(x - marginX), (float)(y - marginY));
                                if (!icon.isRecycled()) {
                                    canvas.drawBitmap(icon, 0.0f, 0.0f, null);
                                }
                                rect = new Rect();
                                rect.left = x - marginX;
                                rect.top = y - marginY;
                                rect.right = rect.left + nMarkerIconWidth;
                                rect.bottom = rect.top + nMarkerIconHeight;
                                this.mMarkerItems.get(list.get(i)).setRect(rect);
                                canvas.restore();
                                if (this.layoutResId != 0) {
                                    if (this.mMarkerItems.get(list.get(i)).getAutoCalloutVisible()) {
                                        if (this.bShowCallot) {
                                            if (this.mMarkerItems.get(list.get(i)).getID().equals(this.showcallot_id) && this.mMarkerItems.get(list.get(i)).getCanShowCallout()) {
                                                this.drawCallout(canvas, this.mMarkerItems.get(list.get(i)), x, y - marginY);
                                            }
                                        } else if (this.bAutoVisible) {
                                            this.drawCallout(canvas, this.mMarkerItems.get(list.get(i)), x, y - marginY);
                                        }
                                    } else if (this.bShowCallot && this.mMarkerItems.get(list.get(i)).getID().equals(this.showcallot_id) && this.mMarkerItems.get(list.get(i)).getCanShowCallout()) {
                                        this.drawCallout(canvas, this.mMarkerItems.get(list.get(i)), x, y - marginY);
                                    }
                                }
                            } else {
                                x = this.view.getMapXForPoint(this.mMarkerItems.get((Object)list.get((int)i)).longitude, this.mMarkerItems.get((Object)list.get((int)i)).latitude);
                                y = this.view.getMapYForPoint(this.mMarkerItems.get((Object)list.get((int)i)).longitude, this.mMarkerItems.get((Object)list.get((int)i)).latitude);
                                xPos = this.mMarkerItems.get(list.get(i)).getPositionX();
                                yPos = this.mMarkerItems.get(list.get(i)).getPositionY();
                                nMarkerIconWidth = icon.getWidth();
                                nMarkerIconHeight = icon.getHeight();
                                nPos_x = (int)(xPos * (float)nMarkerIconWidth);
                                nPos_y = (int)(yPos * (float)nMarkerIconHeight);
                                marginX = nPos_x == 0 ? nMarkerIconWidth / 2 : nPos_x;
                                marginY = nPos_y == 0 ? nMarkerIconHeight / 2 : nPos_y;
                                canvas.drawBitmap(icon, (float)x, (float)y, null);
                                rect = new Rect();
                                rect.left = x - marginX;
                                rect.top = y - marginY;
                                rect.right = rect.left + nMarkerIconWidth;
                                rect.bottom = rect.top + nMarkerIconHeight;
                                this.mMarkerItems.get(list.get(i)).setRect(rect);
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawCallout(Canvas canvas, TMapMarkerItem marker, int x, int y) {
        canvas.save();
        canvas.rotate(-this.view.getRotateData(), (float)this.view.getCenterPointX(), (float)this.view.getCenterPointY());
        int tx = x - this.nInfo_box_tail_width / 2;
        int ty = y - this.nInfo_box_tail_height - this.dp2px(2.0f);
        canvas.translate((float)tx, (float)ty);
        this.info_box_tail.draw(canvas);
        Bitmap bitmapleft_image = marker.getCalloutLeftImage();
        Bitmap bitmapright_image = marker.getCalloutRightButtonImage();
        String strMainTitle = marker.getCalloutTitle();
        String strSubTitle = marker.getCalloutSubTitle();
        this.textTitle.setText((CharSequence)strMainTitle);
        float mainTxtWidth = this.textTitle.getPaint().measureText(strMainTitle);
        float subTxtWidth = 0.0f;
        if (strSubTitle != null) {
            this.textSubTitle.setText((CharSequence)strSubTitle);
            subTxtWidth = this.textSubTitle.getPaint().measureText(strSubTitle);
        }
        int txtWidth = (int)(mainTxtWidth > subTxtWidth ? mainTxtWidth : subTxtWidth);
        int left_image_width = 0;
        int left_image_height = 0;
        int right_image_width = 0;
        int right_image_height = 0;
        int leftMargin = this.dp2px(7.0f);
        int rightMargin = 0;
        int margin = this.dp2px(10.0f);
        if (bitmapleft_image != null) {
            this.leftImage.setImageBitmap(bitmapleft_image);
            left_image_width = bitmapleft_image.getWidth();
            left_image_height = bitmapleft_image.getHeight();
            leftMargin = this.dp2px(3.0f);
            margin = this.dp2px(14.0f);
        }
        if (bitmapright_image != null) {
            this.rightImage.setImageBitmap(bitmapright_image);
            right_image_width = bitmapright_image.getWidth();
            right_image_height = bitmapright_image.getHeight();
            rightMargin = this.dp2px(3.0f);
        }
        this.wCallout = left_image_width + txtWidth + right_image_width + leftMargin + rightMargin + margin;
        if (this.wCallout > this.mDisplayWidth / 2) {
            this.wCallout = this.mDisplayWidth / 2;
        }
        int tx1 = -(this.wCallout / 2) + this.info_box_tail.getMinimumWidth() / 2;
        int ty1 = -this.hCallout + this.dp2px(4.0f);
        this.xCallout = tx + tx1;
        this.yCallout = ty + ty1;
        canvas.translate((float)tx1, (float)ty1);
        this.popupLayout.layout(0, 0, this.wCallout, this.hCallout);
        if (bitmapleft_image != null) {
            this.leftImage.layout(this.dp2px(7.0f), this.hCallout / 2 - left_image_height / 2, left_image_width, left_image_height + (this.hCallout / 2 - left_image_height / 2));
        }
        if (bitmapright_image != null) {
            this.rightImage.layout(this.wCallout - right_image_width - this.dp2px(7.0f), this.hCallout / 2 - right_image_height / 2, this.wCallout - this.dp2px(7.0f), right_image_height + (this.hCallout / 2 - right_image_height / 2));
        }
        int textWidth = this.wCallout - right_image_width - rightMargin - this.dp2px(7.0f);
        if (subTxtWidth < 1.0f) {
            this.textTitle.layout(left_image_width + leftMargin, this.hCallout / 2 - this.fontTitleHeight / 2, textWidth, this.hCallout);
        } else {
            this.textTitle.layout(left_image_width + leftMargin, this.hCallout / 2 - (this.fontTitleHeight + this.fontSubTitleHeight) / 2, textWidth, this.hCallout);
            this.textSubTitle.layout(left_image_width + this.dp2px(7.0f), this.fontTitleHeight + this.dp2px(2.0f), textWidth, this.hCallout);
        }
        this.popupLayout.draw(canvas);
        canvas.restore();
        int moveWith = 0;
        int moveHeight = 0;
        if (this.mMoveMap) {
            this.mMoveMap = false;
            if (this.xCallout < 0) {
                moveWith = this.xCallout - this.dp2px(10.0f);
            } else if (this.xCallout + this.wCallout > this.mDisplayWidth) {
                moveWith = this.wCallout - (this.mDisplayWidth - this.xCallout) + this.dp2px(10.0f);
            }
            if (this.yCallout < 0) {
                moveHeight = this.yCallout - this.dp2px(10.0f);
            }
            if (moveWith != 0 || moveHeight != 0) {
                this.view.moveTo(moveWith, moveHeight);
            }
        }
        Rect rect = new Rect();
        rect.left = this.xCallout + moveWith;
        rect.top = this.yCallout + moveHeight;
        rect.right = rect.left + this.wCallout;
        rect.bottom = rect.top + this.hCallout;
        marker.setCalloutRect(rect);
        if (bitmapright_image != null) {
            rect = new Rect();
            rect.left = this.xCallout + this.wCallout - right_image_width - this.dp2px(14.0f) + moveWith;
            rect.top = this.yCallout + moveHeight;
            rect.right = rect.left + right_image_width + this.dp2px(14.0f);
            rect.bottom = rect.top + this.hCallout;
            marker.setCalloutRightRect(rect);
        }
    }

    public void setRotate(boolean rotate) {
        this.isRotate = rotate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TMapMarkerItem> onClickEvent(PointF point) {
        this.clickMarkeritem.clear();
        int nClickIndex = -1;
        if (this.mMarkerItems.size() > 0) {
            int ex = (int)point.x;
            int ey = (int)point.y;
            Map<String, TMapMarkerItem> map = this.mMarkerItems;
            synchronized (map) {
                ArrayList<String> list = new ArrayList<String>(this.mMarkerItems.keySet());
                int i = 0;
                if (!this.view.getEnableClustering()) {
                    i = list.size() - 1;
                    while (i > -1) {
                        if (this.mMarkerItems.get(list.get(i)).getRect() != null && this.mMarkerItems.get(list.get(i)).getRect().contains(ex, ey)) {
                            this.clickMarkeritem.add(this.mMarkerItems.get(list.get(i)));
                            break;
                        }
                        --i;
                    }
                } else {
                    Map<String, TMapMarkerItem> map2 = this.mClusterItem;
                    synchronized (map2) {
                        ArrayList<String> alCluster = new ArrayList<String>(this.mClusterItem.keySet());
                        i = 0;
                        while (i < alCluster.size()) {
                            if (this.mClusterItem.get(list.get(i)).getRect() != null && this.mClusterItem.get(list.get(i)).getRect().contains(ex, ey)) {
                                nClickIndex = i;
                            }
                            ++i;
                        }
                        if (nClickIndex != -1) {
                            String strClickID = this.mClusterItem.get(alCluster.get(nClickIndex)).getID();
                            int x1 = 0;
                            int y1 = 0;
                            i = 0;
                            while (i < alCluster.size()) {
                                if (this.mClusterItem.get(alCluster.get(i)).getID().equals(strClickID)) {
                                    x1 = this.view.getRotatedMapXForPoint(this.mClusterItem.get((Object)alCluster.get((int)i)).latitude, this.mClusterItem.get((Object)alCluster.get((int)i)).longitude);
                                    y1 = this.view.getRotatedMapYForPoint(this.mClusterItem.get((Object)alCluster.get((int)i)).latitude, this.mClusterItem.get((Object)alCluster.get((int)i)).longitude);
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < list.size()) {
                                if (!this.mMarkerItems.get(list.get(i)).getID().equals(strClickID)) {
                                    int x2 = this.view.getRotatedMapXForPoint(this.mMarkerItems.get((Object)list.get((int)i)).latitude, this.mMarkerItems.get((Object)list.get((int)i)).longitude);
                                    int y2 = this.view.getRotatedMapYForPoint(this.mMarkerItems.get((Object)list.get((int)i)).latitude, this.mMarkerItems.get((Object)list.get((int)i)).longitude);
                                    int GridSizePx = 15;
                                    if (x1 >= x2 - 15 && x1 <= x2 + 15 && y1 >= y2 - 15 && y1 <= y2 + 15) {
                                        this.clickMarkeritem.add(this.mMarkerItems.get(list.get(i)));
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                }
            }
        }
        return this.clickMarkeritem;
    }

    @Override
    public void destroyTMapLayer() {
    }

    @Override
    public boolean onTouchEvent(PointF point) {
        return false;
    }

    @Override
    public boolean onLongPressEvent(PointF point) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<TMapMarkerItem> onLongPressEvent(PointF point, Object obj) {
        this.clickMarkeritem.clear();
        int nClickIndex = -1;
        if (this.mMarkerItems.size() > 0) {
            int ex = (int)point.x;
            int ey = (int)point.y;
            Map<String, TMapMarkerItem> map = this.mMarkerItems;
            synchronized (map) {
                ArrayList<String> list = new ArrayList<String>(this.mMarkerItems.keySet());
                int i = 0;
                if (!this.view.getEnableClustering()) {
                    i = list.size() - 1;
                    while (i > -1) {
                        if (this.mMarkerItems.get(list.get(i)).getRect() != null && this.mMarkerItems.get(list.get(i)).getRect().contains(ex, ey)) {
                            this.clickMarkeritem.add(this.mMarkerItems.get(list.get(i)));
                            break;
                        }
                        --i;
                    }
                } else {
                    i = 0;
                    while (i < list.size()) {
                        if (this.mMarkerItems.get(list.get(i)).getRect() != null && this.mMarkerItems.get(list.get(i)).getRect().contains(ex, ey)) {
                            this.clickMarkeritem.add(this.mMarkerItems.get(list.get(i)));
                            nClickIndex = i;
                        }
                        ++i;
                    }
                    if (nClickIndex != -1) {
                        String strClickID = this.mMarkerItems.get(list.get(nClickIndex)).getID();
                        Map<String, TMapMarkerItem> map2 = this.mClusterItem;
                        synchronized (map2) {
                            ArrayList<String> list1 = new ArrayList<String>(this.mClusterItem.keySet());
                            int x1 = 0;
                            int y1 = 0;
                            i = 0;
                            while (i < list1.size()) {
                                if (this.mClusterItem.get(list1.get(i)).getID().equals(strClickID)) {
                                    x1 = this.view.getRotatedMapXForPoint(this.mClusterItem.get((Object)list1.get((int)i)).latitude, this.mClusterItem.get((Object)list1.get((int)i)).longitude);
                                    y1 = this.view.getRotatedMapYForPoint(this.mClusterItem.get((Object)list1.get((int)i)).latitude, this.mClusterItem.get((Object)list1.get((int)i)).longitude);
                                }
                                ++i;
                            }
                            i = 0;
                            while (i < list.size()) {
                                if (!this.mMarkerItems.get(list.get(i)).getID().equals(strClickID)) {
                                    int x2 = this.view.getRotatedMapXForPoint(this.mMarkerItems.get((Object)list.get((int)i)).latitude, this.mMarkerItems.get((Object)list.get((int)i)).longitude);
                                    int y2 = this.view.getRotatedMapYForPoint(this.mMarkerItems.get((Object)list.get((int)i)).latitude, this.mMarkerItems.get((Object)list.get((int)i)).longitude);
                                    int GridSizePx = 15;
                                    if (x1 >= x2 - 15 && x1 <= x2 + 15 && y1 >= y2 - 15 && y1 <= y2 + 15) {
                                        this.clickMarkeritem.add(this.mMarkerItems.get(list.get(i)));
                                    }
                                }
                                ++i;
                            }
                        }
                    }
                }
            }
        }
        return this.clickMarkeritem;
    }

    @Override
    public boolean drawInScreenPixels() {
        return false;
    }

    public void removeCallot(TMapMarkerItem tMapMarkerItem) {
        if (this.showcallot_id != null && tMapMarkerItem != null && tMapMarkerItem.getID() != null && tMapMarkerItem.getID().equals(this.showcallot_id)) {
            this.showcallot_id = null;
            this.bShowCallot = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onSingleTapUp(PointF point) {
        String calloutid = null;
        this.mMoveMap = false;
        this.bAutoVisible = false;
        if (this.mMarkerItems.size() > 0) {
            int ex = (int)point.x;
            int ey = (int)point.y;
            Map<String, TMapMarkerItem> map = this.mMarkerItems;
            synchronized (map) {
                block15: {
                    block14: {
                        ArrayList<String> list;
                        block13: {
                            TMapMarkerItem item;
                            list = new ArrayList<String>(this.mMarkerItems.keySet());
                            if (!this.bShowCallot || this.showcallot_id == null || (item = this.view.getMarkerItemFromID(this.showcallot_id)).getCalloutRect() == null || !item.getCalloutRect().contains(ex, ey)) break block13;
                            if (item.getCalloutRightRect() != null && this.view.onCalloutRightButtonListener != null && item.getCalloutRightRect().contains(ex, ey)) {
                                this.view.onCalloutRightButtonListener.onCalloutRightButton(item);
                            }
                            return true;
                        }
                        int i = list.size() - 1;
                        while (i > -1) {
                            if (this.mMarkerItems.get(list.get(i)).getRect() != null && this.mMarkerItems.get(list.get(i)).getRect().contains(ex, ey)) {
                                calloutid = this.mMarkerItems.get(list.get(i)).getID();
                                break;
                            }
                            --i;
                        }
                        if (calloutid != null) break block14;
                        if (this.bShowCallot) {
                            this.bShowCallot = false;
                            this.showcallot_id = null;
                            this.view.postInvalidate();
                            return false;
                        }
                        break block15;
                    }
                    this.bShowCallot = true;
                    this.mMoveMap = true;
                    if (this.showcallot_id == null || !this.showcallot_id.equals(calloutid)) {
                        this.showcallot_id = calloutid;
                        TMapMarkerItem item = this.view.getMarkerItemFromID(calloutid);
                        this.view.bringMarkerToFront(item);
                    }
                    return true;
                }
            }
        }
        if (this.bShowCallot) {
            this.bShowCallot = false;
            this.showcallot_id = null;
            this.view.postInvalidate();
        }
        return false;
    }

    public void setInitCalloutitem() {
        this.bShowCallot = false;
        this.view.postInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClusterDraw(Canvas canvas) {
        try {
            Map<String, TMapMarkerItem> map = this.mMarkerItems;
            synchronized (map) {
                ArrayList<String> list = new ArrayList<String>(this.mMarkerItems.keySet());
                boolean bClustering = false;
                Bitmap icon = null;
                Map<String, TMapMarkerItem> map2 = this.mClusterItem;
                synchronized (map2) {
                    this.mClusterItem.clear();
                }
                int nClusterIndex = -1;
                Rect rect = null;
                int i = 0;
                while (i < list.size()) {
                    if (this.mMarkerItems.get(list.get(i)).getVisible() == 2) {
                        int marginY;
                        int marginX;
                        int nMarkerIconHeight;
                        int nMarkerIconWidth;
                        int nPos_y;
                        int nPos_x;
                        int y;
                        int x;
                        int x1 = this.view.getRotatedMapXForPoint(this.mMarkerItems.get((Object)list.get((int)i)).latitude, this.mMarkerItems.get((Object)list.get((int)i)).longitude);
                        int y1 = this.view.getRotatedMapYForPoint(this.mMarkerItems.get((Object)list.get((int)i)).latitude, this.mMarkerItems.get((Object)list.get((int)i)).longitude);
                        icon = this.mMarkerItems.get(list.get(i)).getIcon();
                        if (icon == null) {
                            icon = this.view.getDefaultIcon();
                        }
                        if (this.mMarkerItems.get(list.get(i)).getEnableClustering()) {
                            int j = i + 1;
                            while (j < list.size()) {
                                int x2 = this.view.getRotatedMapXForPoint(this.mMarkerItems.get((Object)list.get((int)j)).latitude, this.mMarkerItems.get((Object)list.get((int)j)).longitude);
                                int y2 = this.view.getRotatedMapYForPoint(this.mMarkerItems.get((Object)list.get((int)j)).latitude, this.mMarkerItems.get((Object)list.get((int)j)).longitude);
                                int GridSizePx = (int)(10.0f * (this.view.mDensity + 1.0f));
                                if (x2 >= 0 && y2 >= 0 && x1 >= x2 - GridSizePx && x1 <= x2 + GridSizePx && y1 >= y2 - GridSizePx && y1 <= y2 + GridSizePx) {
                                    nClusterIndex = j;
                                    bClustering = true;
                                    break;
                                }
                                ++j;
                            }
                            if (!bClustering) {
                                x = this.view.getRotatedMapXForPoint(this.mMarkerItems.get((Object)list.get((int)i)).latitude, this.mMarkerItems.get((Object)list.get((int)i)).longitude);
                                y = this.view.getRotatedMapYForPoint(this.mMarkerItems.get((Object)list.get((int)i)).latitude, this.mMarkerItems.get((Object)list.get((int)i)).longitude);
                                float xPos = this.mMarkerItems.get(list.get(i)).getPositionX();
                                float yPos = this.mMarkerItems.get(list.get(i)).getPositionY();
                                nPos_x = 0;
                                nPos_y = 0;
                                nMarkerIconWidth = 0;
                                nMarkerIconHeight = 0;
                                marginX = 0;
                                marginY = 0;
                                nMarkerIconWidth = icon.getWidth();
                                nMarkerIconHeight = icon.getHeight();
                                nPos_x = (int)(xPos * (float)nMarkerIconWidth);
                                nPos_y = (int)(yPos * (float)nMarkerIconHeight);
                                marginX = nPos_x == 0 ? nMarkerIconWidth / 2 : nPos_x;
                                marginY = nPos_y == 0 ? nMarkerIconHeight / 2 : nPos_y;
                                canvas.save();
                                canvas.rotate(-this.view.getRotateData(), (float)this.view.getCenterPointX(), (float)this.view.getCenterPointY());
                                canvas.translate((float)(x - marginX), (float)(y - marginY));
                                if (nClusterIndex == i) {
                                    canvas.drawBitmap(this.view.getClusteringeIcon(), 0.0f, 0.0f, null);
                                    Map<String, TMapMarkerItem> map3 = this.mClusterItem;
                                    synchronized (map3) {
                                        this.mClusterItem.put(this.mMarkerItems.get(list.get(i)).getID(), this.mMarkerItems.get(list.get(i)));
                                    }
                                } else {
                                    canvas.drawBitmap(icon, 0.0f, 0.0f, null);
                                }
                                canvas.restore();
                                rect = new Rect();
                                rect.left = x - marginX;
                                rect.top = y - marginY;
                                rect.right = rect.left + nMarkerIconWidth;
                                rect.bottom = rect.top + nMarkerIconHeight;
                                this.mMarkerItems.get(list.get(i)).setRect(rect);
                            }
                            bClustering = false;
                        } else if (!this.isRotate) {
                            x = this.view.getMapXForPoint(this.mMarkerItems.get((Object)list.get((int)i)).longitude, this.mMarkerItems.get((Object)list.get((int)i)).latitude);
                            y = this.view.getMapYForPoint(this.mMarkerItems.get((Object)list.get((int)i)).longitude, this.mMarkerItems.get((Object)list.get((int)i)).latitude);
                            float xPos = this.mMarkerItems.get(list.get(i)).getPositionX();
                            float yPos = this.mMarkerItems.get(list.get(i)).getPositionY();
                            nPos_x = 0;
                            nPos_y = 0;
                            nMarkerIconWidth = 0;
                            nMarkerIconHeight = 0;
                            marginX = 0;
                            marginY = 0;
                            nMarkerIconWidth = icon.getWidth();
                            nMarkerIconHeight = icon.getHeight();
                            nPos_x = (int)(xPos * (float)nMarkerIconWidth);
                            nPos_y = (int)(yPos * (float)nMarkerIconHeight);
                            marginX = nPos_x == 0 ? nMarkerIconWidth / 2 : nPos_x;
                            marginY = nPos_y == 0 ? nMarkerIconHeight / 2 : nPos_y;
                            canvas.drawBitmap(icon, (float)(x - marginX), (float)(y - marginY), null);
                            rect = new Rect();
                            rect.left = x - marginX;
                            rect.top = y - marginY;
                            rect.right = rect.left + nMarkerIconWidth;
                            rect.bottom = rect.top + nMarkerIconHeight;
                            this.mMarkerItems.get(list.get(i)).setRect(rect);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

