package com.example.admin.s20172300_1002_01;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.location.Location;
import android.location.LocationListener;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.util.Log;
import android.widget.LinearLayout;
import android.widget.Toast;

import com.skt.Tmap.TMapCircle;
import com.skt.Tmap.TMapData;
import com.skt.Tmap.TMapGpsManager;
import com.skt.Tmap.TMapMarkerItem;
import com.skt.Tmap.TMapPOIItem;
import com.skt.Tmap.TMapPoint;
import com.skt.Tmap.TMapPolyLine;
import com.skt.Tmap.TMapView;

import java.util.ArrayList;

public class MainActivity extends Activity implements TMapView.OnLongClickListenerCallback,
        LocationListener,TMapGpsManager.onLocationChangedCallback{
    private TMapView tMapView = null;
    TMapGpsManager gps = null;
    public static String mApiKey=null;
    private static final String TAG = "TestTmap";
    Bitmap icon1,icon2;
    TMapCircle tCircle;
    TMapData tMapData;
    TMapPoint point2;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        LinearLayout liner = (LinearLayout)findViewById(R.id.linear);
        tMapView = new TMapView(this);
        mApiKey="612ebcfa-7911-45ac-97c3-d7cff1b942f3";
        tMapView.setSKTMapApiKey(mApiKey);
        liner.addView(tMapView);
        setContentView(liner);

        gps=new TMapGpsManager(MainActivity.this);
        gps.setMinTime(1);
        gps.setMinDistance(1);
        gps.setProvider(gps.NETWORK_PROVIDER);
        gps.OpenGps();

        tMapData=new TMapData();
        icon1= BitmapFactory.decodeResource(getResources(),R.drawable.icon1);
        icon2= BitmapFactory.decodeResource(getResources(),R.drawable.icon2);

        point2 = new TMapPoint(tMapView.getLatitude(),tMapView.getLongitude());

        tMapView.setZoomLevel(16);
        tMapView.setIconVisibility(true);
        tMapView.setCompassMode(true);
        tMapView.setSightVisible(true);
        tMapView.setMapPosition(TMapView.POSITION_NAVI);
        tMapView.setTrackingMode(true);
    }

    @Override
    public void onLocationChanged(Location location) {

    }

    @Override
    public void onStatusChanged(String provider, int status, Bundle extras) {
        Toast.makeText(getBaseContext(),"StatusChanged",Toast.LENGTH_SHORT).show();
    }

    @Override
    public void onProviderEnabled(String provider) {
        Toast.makeText(getBaseContext(),"ProviderEnabled",Toast.LENGTH_SHORT).show();
    }

    @Override
    public void onProviderDisabled(String provider) {
        Toast.makeText(getBaseContext(),"ProviderDisabled",Toast.LENGTH_SHORT).show();
    }

    @Override
    public void onLocationChange(Location location) {
        tMapView.setCenterPoint(location.getLongitude(),location.getLatitude());
        tMapView.setLocationPoint(location.getLongitude(),location.getLatitude());

        TMapPoint point1 = tMapView.getCenterPoint();
        tMapView.setTMapPathIcon(icon1,icon2);
        //TMapPoint point2 = new TMapPoint(point1.getLatitude()+0.1, point1.getLongitude()+0.1);

        tMapData.findPathDataWithType(TMapData.TMapPathType.CAR_PATH,point1,point2,new TMapData.FindPathDataListenerCallback(){
            @Override
            public void onFindPathData(TMapPolyLine polyLine){
                polyLine.setLineWidth(20);
                polyLine.setOutLineColor(Color.LTGRAY);
                tMapView.addTMapPath(polyLine);
            }
        });
        tMapData.setResponseCodeInfoCallBack(new TMapData.OnResponseCodeInfoCallback() {
            @Override
            public void responseCodeInfo(String s, int i, String s1) {
                Log.d(TAG, Thread.currentThread().getStackTrace()[2].getFileName()+" / "+
                        Thread.currentThread().getStackTrace()[2].getMethodName()+" / "+
                        Thread.currentThread().getStackTrace()[2].getLineNumber()+" : API is "+s+" ResponseCode is "+i);
            }
        });
        CircleTMap();
    }
    private  void CircleTMap(){
        tCircle = new TMapCircle();
        tCircle.setRadius(100);
        tCircle.latitude= tMapView.getLatitude();
        tCircle.longitude= tMapView.getLongitude();

        tCircle.setAreaColor(Color.RED);
        tCircle.setLineColor(Color.RED);
        tCircle.setCircleWidth(5);
        tCircle.setLineAlpha(50);
        tCircle.setAreaAlpha(50);
        tCircle.setRadiusVisible(true);
        tMapView.addTMapCircle("TestCicle",tCircle);
    }

    @Override
    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        gps.CloseGps();
    }

    @Override
    public void onLongPressEvent(ArrayList<TMapMarkerItem> arrayList, ArrayList<TMapPOIItem> arrayList1, TMapPoint tMapPoint) {
        Toast.makeText(getBaseContext(),String.valueOf(tMapPoint.getLatitude())+", "+String.valueOf(tMapPoint.getLongitude()),Toast.LENGTH_SHORT).show();

        point2 = new TMapPoint(tMapPoint.getLatitude(),tMapPoint.getLongitude());

        Toast.makeText(getBaseContext(),"목적지 등록 되었어요!",Toast.LENGTH_SHORT);
    }
}
