/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class BinaryFloatAccessor
extends Accessor {
    static final int MAXLENGTH = 4;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Wed_Dec_02_19:13:26_PST_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    BinaryFloatAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        this.init(oracleStatement, 100, 100, s2, bl);
        this.initForDataAccess(n3, n2, null);
    }

    BinaryFloatAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        this.init(oracleStatement, 100, 100, s2, false);
        this.initForDescribe(100, n2, bl, n3, n4, n5, n6, n7, s2, null);
        int n8 = oracleStatement.maxFieldSize;
        if (n8 > 0 && (n2 == 0 || n8 < n2)) {
            n2 = n8;
        }
        this.initForDataAccess(0, n2, null);
    }

    void init(OracleStatement oracleStatement, int n2, int n3, int n4, short s2, int n5) throws SQLException {
        this.init(oracleStatement, n2, n3, s2, false);
        this.initForDataAccess(n5, n4, null);
    }

    void init(OracleStatement oracleStatement, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7, int n8, int n9, short s2) throws SQLException {
        this.init(oracleStatement, n2, n3, s2, false);
        this.initForDescribe(n2, n4, bl, n5, n6, n7, n8, n9, s2, null);
        int n10 = oracleStatement.maxFieldSize;
        if (n10 > 0 && (n4 == 0 || n10 < n4)) {
            n4 = n10;
        }
        this.initForDataAccess(0, n4, null);
    }

    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        if (n2 != 0) {
            this.externalType = n2;
        }
        this.internalTypeMaxLength = 4;
        if (n3 > 0 && n3 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n3;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    @Override
    float getFloat(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return 0.0f;
        }
        int n3 = this.columnIndex + this.byteLength * n2;
        int n4 = this.rowSpaceByte[n3];
        int n5 = this.rowSpaceByte[n3 + 1];
        int n6 = this.rowSpaceByte[n3 + 2];
        int n7 = this.rowSpaceByte[n3 + 3];
        if ((n4 & 0x80) != 0) {
            n4 &= 0x7F;
            n5 &= 0xFF;
            n6 &= 0xFF;
            n7 &= 0xFF;
        } else {
            n4 = ~n4 & 0xFF;
            n5 = ~n5 & 0xFF;
            n6 = ~n6 & 0xFF;
            n7 = ~n7 & 0xFF;
        }
        int n8 = n4 << 24 | n5 << 16 | n6 << 8 | n7;
        return Float.intBitsToFloat(n8);
    }

    @Override
    String getString(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            return Float.toString(this.getFloat(n2));
        }
        return null;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            return new Float(this.getFloat(n2));
        }
        return null;
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            return new Float(this.getFloat(n2));
        }
        return null;
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getBINARY_FLOAT(n2);
    }

    BINARY_FLOAT getBINARY_FLOAT(int n2) throws SQLException {
        BINARY_FLOAT bINARY_FLOAT = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            int n3 = this.columnIndex + this.byteLength * n2;
            byte[] byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
            bINARY_FLOAT = new BINARY_FLOAT(byArray);
        }
        return bINARY_FLOAT;
    }

    @Override
    NUMBER getNUMBER(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            return new NUMBER(this.getFloat(n2));
        }
        return null;
    }

    BigInteger getBigInteger(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            return new BigInteger(this.getString(n2));
        }
        return null;
    }

    @Override
    BigDecimal getBigDecimal(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            return new BigDecimal(this.getString(n2));
        }
        return null;
    }

    @Override
    byte getByte(int n2) throws SQLException {
        return (byte)this.getFloat(n2);
    }

    @Override
    short getShort(int n2) throws SQLException {
        return (short)this.getFloat(n2);
    }

    @Override
    int getInt(int n2) throws SQLException {
        return (int)this.getFloat(n2);
    }

    @Override
    long getLong(int n2) throws SQLException {
        return (long)this.getFloat(n2);
    }

    @Override
    double getDouble(int n2) throws SQLException {
        return this.getFloat(n2);
    }
}

