package com.jang.doc.controller;

import javax.annotation.Resource;
import javax.validation.Valid;

import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.jang.doc.model.User;
import com.jang.doc.service.UserService;

@Controller
public class JoinController {
	
	@Resource(name="userService")
	private UserService userService;

	@RequestMapping(value="/join.do", method=RequestMethod.GET)
	public String toUserEntryView(Model model) {
		model.addAttribute("user",new User());
		return "joinForm";
	}
	
	@RequestMapping(value="/checkid.do", method=RequestMethod.GET)
	public String dupCheckId(@RequestParam("userId") String userId, Model model) {
		String message = "";
		int reDiv = 0;
		try {
			User loginUser = this.userService.getUser(userId);
			message = "̹  ̵ Դϴ.";
			reDiv = 0;
			userId ="";
			
		}catch(EmptyResultDataAccessException e) {
			message = "  ̵ Դϴ.";
			reDiv = 1;
		}
		model.addAttribute("user",new User());
		model.addAttribute("message",message);
		model.addAttribute("reDiv",reDiv);
		model.addAttribute("userId",userId);
		return "joinForm";
		
	}
	
	@RequestMapping(value="/join.do", method = RequestMethod.POST)
	public String onSubmit(@Valid User user, BindingResult result, Model model) throws Exception{
		
		if(result.hasErrors()) {
			model.addAllAttributes(result.getModel());
			return "joinForm";
		}
		
		try {
			this.userService.insertUser(user);
			model.addAttribute("message","  ȸ ϷǾϴ.");
			model.addAttribute("user",user);
			return "joinSuccess";
		}catch(DataIntegrityViolationException e) {
			model.addAttribute("errMsg","ȸ Ϸ Ͽϴ.");
			return "joinForm";
		}
	}
}
