package com.jang.doc.controller;

import javax.annotation.Resource;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;

import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.jang.doc.model.User;
import com.jang.doc.service.UserService;

@Controller
public class LoginController {

	@Resource(name="userService")
	private UserService userService;

	@RequestMapping(value="/join.do", method=RequestMethod.GET)
	public String toUserEntryView(Model model) {
		model.addAttribute("user",new User());
		return "joinForm";
	}
	
	@RequestMapping(value="/checkid.do", method=RequestMethod.GET)
	public String dupCheckId(@RequestParam("userId") String userId, Model model) {
		String message = "";
		int reDiv = 0;
		try {
			User loginUser = this.userService.getUser(userId);
			message = "̹  ̵ Դϴ.";
			reDiv = 0;
			userId ="";
			
		}catch(EmptyResultDataAccessException e) {
			message = "  ̵ Դϴ.";
			reDiv = 1;
		}
		model.addAttribute("user",new User());
		model.addAttribute("message",message);
		model.addAttribute("reDiv",reDiv);
		model.addAttribute("userId",userId);
		return "joinForm";
		
	}
	
	@RequestMapping(value="/join.do", method = RequestMethod.POST)
	public String onSubmit(@Valid User user, BindingResult result, Model model) throws Exception{
		
		if(result.hasErrors()) {
			model.addAllAttributes(result.getModel());
			return "joinForm";
		}
		
		try {
			this.userService.insertUser(user);
			model.addAttribute("message","  ȸ ϷǾϴ.");
			model.addAttribute("user",user);
			return "joinSuccess";
		}catch(DataIntegrityViolationException e) {
			model.addAttribute("errMsg","ȸ Ϸ Ͽϴ.");
			return "joinForm";
		}
	}
	
	
	@RequestMapping(value="/login", method = RequestMethod.GET)
	public String gotoLoginView( Model model) {
		model.addAttribute("user", new User());
		return "loginForm";
	}
	
	@RequestMapping(value="/login", method = RequestMethod.POST)
	public String onSubmit (@ModelAttribute @Valid User user, BindingResult result, Model model, HttpSession session) {
		if(result.hasFieldErrors("id")||result.hasFieldErrors("pass")) {
			model.addAllAttributes(result.getModel());
			return "loginForm";
		}
		
		try {
			User loginUser = this.userService.getUser(user.getId());
			
			if(user.getPass().equals(loginUser.getPass())) {
				model.addAttribute("loginUser",loginUser);
				session.setAttribute("userId", loginUser.getId()); //ǿ 
				session.setAttribute("userName", loginUser.getName());
				return "loginSuccess";	// ϱ    
			}
			else {
				model.addAttribute("errMsg","н尡 ġ ʽϴ.");
				return "loginForm";
			}
			
		}
		catch (EmptyResultDataAccessException e) {
			model.addAttribute("errMsg","ڰ ϵǾ ʽϴ.");
			return "loginForm";
		}
	}
	
	@RequestMapping(value="/edit", method= RequestMethod.GET)
	public String toUserEditView(@RequestParam("userId") String userId, Model model) {
		try {
			User loginUser = this.userService.getUser(userId);
			model.addAttribute("user",loginUser);
			return "editForm";
		}catch(EmptyResultDataAccessException e) {
			model.addAttribute("user",new User());
			model.addAttribute("errMsg","ڰ ϵǾ ʽϴ.");
			return "loginForm";
		}
	}
	@RequestMapping(value="/edit", method = RequestMethod.POST)
	public String onSubmit2(@Valid User user, BindingResult result, Model model) throws Exception{
		if(result.hasErrors()) {
			model.addAllAttributes(result.getModel());
			return "editForm";
		}
		try {
			this.userService.updateUser(user);
			model.addAttribute("message", "    Ͽϴ.");
			model.addAttribute("user",user);
			return "joinSuccess";
		}catch(DataAccessException e) {
			model.addAttribute("errMsg","  Ͽϴ.");
			return "editForm";
		}
	}
	
	@RequestMapping("/logout.do")
	public String logout(HttpSession session) { 
		session.invalidate(); // 
		return "redirect:login.do"; //login.do url ٷ 
	}
	
	@RequestMapping(value="/findId.do", method=RequestMethod.GET)
	public String toUserFindId(Model model) {
		model.addAttribute("user",new User());
		return "findId";
	}
	
	@RequestMapping(value="/findId.do", method=RequestMethod.POST)
	public String onfindId(@RequestParam("name")String name, @RequestParam("email")String email, Model model,HttpSession session) {
		String message = "";
		int reDiv = 0;
		User loginUser = null;
		
		try {
			loginUser = this.userService.findId(name,email);
			
			message = "ϵ  Դϴ.";
			reDiv = 0;
			name ="";
			email = "";
			
		}catch(EmptyResultDataAccessException e) {
			message = "";
			reDiv = 1;
		}
		
		model.addAttribute("user", loginUser);
		model.addAttribute("message",message);
		model.addAttribute("reDiv",reDiv);
		model.addAttribute("name",name);
		model.addAttribute("email",email);
		session.setAttribute("name", loginUser.getName()); //ǿ 
		session.setAttribute("email", loginUser.getEmail());
		return "findIdSuccess";
		
	}
	

	
	
}
