package com.jang.biz.controller;

import java.util.List;

import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.jang.biz.model.Card;
import com.jang.biz.service.CardService;

@Controller(value="cardController")
public class CardController {

	@Autowired
	private CardService cardService;
	
	@RequestMapping(value="/list", method=RequestMethod.GET)
	public String list(Model model) throws Exception{
		List<Card> list = this.cardService.getCardList();
		model.addAttribute("list",list);
		return "cardList";
	}
	
	@RequestMapping(value="/toForm")
	public String form1(@RequestParam(value="bno", required=false, defaultValue="0") int bno, Model model) throws Exception{
		// 1.�뙆�씪誘명꽣 濡� bno瑜� 諛쏅뒗�뜲 媛믪씠 �뾾�쓣 寃쎌슦�뿉�뒗 0�씠 bno濡� �뱾�뼱媛꾨떎.
		//2. model 鍮� 媛�諛� �깮�꽦
		
		if(bno > 0) { // bno媛�  0�씠 �븘�땺 寃쎌슦�뿉�뒗 �깮�꽦�븷 �븣
			Card card= this.cardService.getCard(bno);
			//1. �쓽議닿�怨꾩＜�엯 -> cardService.getCard硫붿꽌�뱶�떎�뻾 (留ㅺ컻蹂��닔濡� bno)-> cardDao.getCard濡� �씠�룞
			model.addAttribute("commandUrl","editSave");
			model.addAttribute("card",card);
		}else {
			model.addAttribute("commandUrl","addSave");
			model.addAttribute("card",new Card());
		}
		return "cardView";
	}

	
	@RequestMapping(value="/addSave", method=RequestMethod.POST)
	public String add(@Valid Card card, BindingResult result, RedirectAttributes rea) throws Exception{
		// 1. �뤌�뿉�꽌�삩 �뙆�씪誘명꽣�뱾�쓽 �쑀�슚�꽦 寃��궗
		// 2. �쑀�슚�꽦 寃��궗 寃곌낵 result�뿉 �꽔湲�
		// 3. 由щ떎�씠�젆�듃 蹂��닔 �깮�꽦
		if(result.hasErrors()) {
			rea.addAllAttributes(result.getModel());
			//�쑀�슚�꽦 寃��궗 寃곌낵瑜� 由щ떎�씠�젆�듃 蹂��닔�뿉 �꽔湲�
			return "redirect:list";
		}
		// �쓽議닿�怨� �꽕�젙 �썑 cardService.addCard硫붿꽌�뱶媛� 留ㅺ컻蹂��닔濡� card �꽔怨� �떎�뻾
		// sql 寃곌낵媛� 1�씤 寃쎌슦�뒗 update媛� �꽦怨듯뻽�떎�뒗 嫄�
		if(this.cardService.addCard(card)==1) {
			rea.addFlashAttribute("message","�떊洹� �벑濡앸릺�뿀�뒿�땲�떎.");
			return "redirect:list";
		}else{
			rea.addFlashAttribute("message","�떊洹� �벑濡앹뿉 �떎�뙣");
			return "redirect:list";
		}
	}
	
	@RequestMapping(value="/editSave", method=RequestMethod.POST)
	public String edit(@Valid Card card, BindingResult result, RedirectAttributes rea) throws Exception{
		
		if(result.hasErrors()) {
			rea.addAllAttributes(result.getModel());
			return "cardView";
		}
		if(this.cardService.updateCard(card) == 1) {
			rea.addFlashAttribute("message","�닔�젙 �셿猷�.");
			return "redirect:list";
		}
		else {
			rea.addFlashAttribute("message","�닔�젙 �떎�뙣�븯���뒿�땲�떎. �솗�씤 �썑 �떎�떆 �떆�룄�븯�뿬 二쇱떗�떆�삤.");
			return "redirect:list";
		}
	}
	
	@RequestMapping(value="/delete.do", method=RequestMethod.POST)
	public String delete(@RequestParam(value="bno")int bno, RedirectAttributes rea) throws Exception{
		if(this.cardService.deleteCard(bno) == 1) {
			rea.addFlashAttribute("message","�궘�젣 �셿猷�.");
			return "redirect:list";
		}
		else {
			rea.addFlashAttribute("message","�궘�젣 �떎�뙣�븯���뒿�땲�떎. �솗�씤 �썑 �떎�떆 �떆�룄�븯�뿬 二쇱떗�떆�삤.");
			return "redirect:list";
		}
	}
	
	
	
	
	
	
	
}
