package com.jang.biz.dao;

import java.util.List;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

import com.jang.biz.model.Card;

@Repository("cardDao")
public class CardDaoImpl implements CardDao {
	
	private JdbcTemplate jdbcTemplate;
	private NamedParameterJdbcTemplate jdbcTemplate2;
	
	@Autowired
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
		this.jdbcTemplate2 = new NamedParameterJdbcTemplate(dataSource);
		
	}

	@Override
	public List<Card> getCardList() {
		String SQL = "select * from bcard order by bno asc";
		RowMapper<Card> mapper = new BeanPropertyRowMapper<Card>(Card.class);
		List<Card> cList = (List<Card>)this.jdbcTemplate.query(SQL, mapper);
		return cList;
	}

	@Override
	public Card getCard(int bno) {
		String SQL = "select * from bcard where bno = ?";
		RowMapper<Card> mapper = new BeanPropertyRowMapper<Card>(Card.class);
		return this.jdbcTemplate.queryForObject(SQL, mapper,bno);
	}

	@Override
	public int addCard(Card card) {
		String SQL = "INSERT INTO bcard (bno, bname, phone, description) VALUES(bno_seq.nextval, :bname, :phone, :description)";
		SqlParameterSource parameter = new BeanPropertySqlParameterSource(card);
		return this.jdbcTemplate2.update(SQL,parameter);
	}

	@Override
	public int updateCard(Card card) {
		String SQL = "update bcard set bname=:bname, phone=:phone, description=:description where bno=:bno";
		SqlParameterSource parameter = new BeanPropertySqlParameterSource(card);
		return this.jdbcTemplate2.update(SQL,parameter);
	}

	@Override
	public int deleteCard(int bno) {
		String SQL = "delete from bcard where bno=?";
		return this.jdbcTemplate.update(SQL,bno);
	}

}
