package com.jang.biz.mapper;

import java.util.List;

import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import com.jang.biz.model.Card;

@Repository(value="cardMapper")
public class CardMapper {

	@Autowired
	private SqlSessionTemplate sqlSession;
	
	public List<Card> getCardList(){
		return  sqlSession.selectList("com.jang.biz.mapper.CardMapper.getCardList");
	}
	
	public Card getCard(int bno) {
		return  sqlSession.selectOne("com.jang.biz.mapper.CardMapper.getCard", bno);
	}
	
	public int addCard(Card card) {
		return sqlSession.insert("com.jang.biz.mapper.CardMapper.addCard", card);
	}
	
	public int updateCard(Card card) {
		return  sqlSession.update("com.jang.biz.mapper.CardMapper.updateCard", card);
	}
	
	public int deleteCard(int bno) {
		return sqlSession.delete("com.jang.biz.mapper.CardMapper.deleteCard", bno);
	}
}
