package com.jang.doc.dao;

import javax.sql.DataSource;

import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

import com.jang.doc.model.User;

//@Repository("userDao")
public class UserDaoImpl implements UserDao {
	
	private JdbcTemplate jdbcTemplate;
	private NamedParameterJdbcTemplate jdbcTemplate2;
	
	//@Autowired
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
		this.jdbcTemplate2 = new NamedParameterJdbcTemplate(dataSource);
	}
	

	

	@Override
	public User getUser(String userId) {
		// TODO Auto-generated method stub
	
		String GETUSER_USERID = "Select * from member_tbl where id =?";
		RowMapper<User> mapper = new BeanPropertyRowMapper<User>(User.class);
		return this.jdbcTemplate.queryForObject(GETUSER_USERID, mapper, userId);
	}

	@Override
	public void updateUser(User user) {
		// TODO Auto-generated method stub
		String SQL_UP = "update member_tbl set pass=:pass, zip=:zip, addr1=:addr1, addr2=:addr2, "+"phone=:phone, email=:email where id=:id";
		SqlParameterSource parameterSource = new BeanPropertySqlParameterSource(user);
		this.jdbcTemplate2.update(SQL_UP, parameterSource);
	}

	@Override
	public void insertUser(User user) {
		// TODO Auto-generated method stub
		String SQL_INS = "Inset into member_tbl(no,id,pass,name,zip,addr1,addr2,phone,email)"+ " Values( seq_no.nextval, :Id, :pass, :Name, :zip, :addr1, :addr2, :phone, :email)";
		SqlParameterSource parameterSource = new BeanPropertySqlParameterSource(user);
		this.jdbcTemplate2.update(SQL_INS, parameterSource);
	}

}
