package com.jang.doc.controller;

import javax.annotation.Resource;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.jang.doc.model.User;
import com.jang.doc.service.UserService;

@Controller
public class EditController {

	@Resource(name = "userService")
	private UserService userService;
	
	@RequestMapping(value="/edit", method= RequestMethod.GET)
	public String toUserEditView(@RequestParam("userId") String userId, Model model) {
		try {
			User loginUser = this.userService.getUser(userId);
			model.addAttribute("user",loginUser);
			return "editForm";
		}catch(EmptyResultDataAccessException e) {
			model.addAttribute("user",new User());
			model.addAttribute("errMsg","ڰ ϵǾ ʽϴ.");
			return "loginForm";
		}
	}
}
