package com.jang.doc.controller;

import javax.annotation.Resource;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;

import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.jang.doc.model.User;
import com.jang.doc.service.UserService;

@Controller
public class LoginController {

	@Resource(name = "userService")	//@Autowired
	private UserService userService;
	
	@RequestMapping(value="/login", method = RequestMethod.GET)
	public String gotoLoginView( Model model) {
		model.addAttribute("user", new User());
		return "loginForm";
	}
	
	@RequestMapping(value="/login", method = RequestMethod.POST)
	public String onSubmit (@ModelAttribute @Valid User user, BindingResult result, Model model, HttpSession session) {
		if(result.hasFieldErrors("id")||result.hasFieldErrors("pass")) {
			model.addAllAttributes(result.getModel());
			return "loginForm";
		}
		
		try {
			User loginUser = this.userService.getUser(user.getId());
			
			if(user.getPass().equals(loginUser.getPass())) {
				model.addAttribute("loginUser",loginUser);
				session.setAttribute("userId", loginUser.getId());
				session.setAttribute("userName", loginUser.getName());
				return "loginSuccess";	// ϱ    
			}
			else {
				model.addAttribute("errMsg","н尡 ġ ʽϴ.");
				return "loginForm";
			}
			
		}
		catch (EmptyResultDataAccessException e) {
			model.addAttribute("errMsg","ڰ ϵǾ ʽϴ.");
			return "loginForm";
		}
	}
	
}
