package com.jang.doc.dao;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

import com.jang.doc.model.User;

@Repository("userDao")
public class UserDaoImpl implements UserDao {
	
	private JdbcTemplate jdbcTemplate;
	private NamedParameterJdbcTemplate jdbcTemplate2;
	
	@Autowired
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
		this.jdbcTemplate2 = new NamedParameterJdbcTemplate(dataSource);
	}
	

	@Override
	public User getUser(String userId) {
		String GETUSER_ID = "SELECT * FROM member_tb WHERE ID = ?";	//ġĶ  (ϰ Ҷ )
		RowMapper<User> mapper = new BeanPropertyRowMapper<User>(User.class);	// DTOü    
		return this.jdbcTemplate.queryForObject(GETUSER_ID, mapper, userId);	//queryxxx ޼ҵ尡 ִµ  𸣸 Object, Select 
	}

	@Override
	public void updateUser(User user) {
		String SQL_UP = "UPDATE member_tb SET pass=:pass, zip=:zip, addr1=:addr1, addr2=:addr2, "	//̸Ķ  (DTOü ̸ ƾ) 
				+"phone=:phone, email=:email WHERE id =:id";
		
		SqlParameterSource parameterSource = new BeanPropertySqlParameterSource(user);	//DTOü ڵ  ׸
		this.jdbcTemplate2.update(SQL_UP, parameterSource);	//SELECT  DML 

	}

	@Override
	public void insertUser(User user) {
		String SQL_INS = "INSERT INTO member_tb (no, id, pass, name, zip, addr1, addr2, phone, email)"
				+" VALUES( seq_no.nextval, :id, :pass, :name, :zip, :addr1, :addr2, :phone, :email)";
		
		SqlParameterSource parameterSource = new BeanPropertySqlParameterSource(user);	// ׸
		
		this.jdbcTemplate2.update(SQL_INS, parameterSource);	//update  ΰ 

	}

	@Override
	public void deleteUser(User user, User phone) {
		// TODO Auto-generated method stub

	}

}
