package com.jang.biz.controller;

import java.util.List;

import javax.annotation.Resource;
import javax.validation.Valid;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

import com.jang.biz.model.Card;
import com.jang.biz.service.CardService;

@Controller(value="cardController")
public class CardController {

	@Resource(name="cardService")
	private CardService cardService;
	
	@RequestMapping(value="/list", method=RequestMethod.GET)
	public String list(Model model) throws Exception{
		List<Card> list = this.cardService.getCardList();
		model.addAttribute("list",list);
		return "cardList";
	}
	
	@RequestMapping(value="/toForm")
	public String form1(@RequestParam(value="bno", required=false, defaultValue="0") int bno, Model model) throws Exception{
		// 1.파라미터 로 bno를 받는데 값이 없을 경우에는 0이 bno로 들어간다.
		//2. model 빈 가방 생성
		
		if(bno > 0) { // bno가  0이 아닐 경우에는 생성할 때
			Card card= this.cardService.getCard(bno);
			//1. 의존관계주입 -> cardService.getCard메서드실행 (매개변수로 bno)-> cardDao.getCard로 이동
			model.addAttribute("commandUrl","editSave");
			model.addAttribute("card",card);
		}else {
			model.addAttribute("commandUrl","addSave");
			model.addAttribute("card",new Card());
		}
		return "cardView";
	}

	
	@RequestMapping(value="/addSave", method=RequestMethod.POST)
	public String add(@Valid Card card, BindingResult result, RedirectAttributes rea) throws Exception{
		// 1. 폼에서온 파라미터들의 유효성 검사
		// 2. 유효성 검사 결과 result에 넣기
		// 3. 리다이렉트 변수 생성
		if(result.hasErrors()) {
			rea.addAllAttributes(result.getModel());
			//유효성 검사 결과를 리다이렉트 변수에 넣기
			return "redirect:list";
		}
		// 의존관계 설정 후 cardService.addCard메서드가 매개변수로 card 넣고 실행
		// sql 결과가 1인 경우는 update가 성공했다는 거
		if(this.cardService.addCard(card)==1) {
			rea.addFlashAttribute("message","신규 등록되었습니다.");
			return "redirect:list";
		}else{
			rea.addFlashAttribute("message","신규 등록에 실패");
			return "redirect:list";
		}
	}
	
	@RequestMapping(value="/editSave", method=RequestMethod.POST)
	public String edit(@Valid Card card, BindingResult result, RedirectAttributes rea) throws Exception{
		
		if(result.hasErrors()) {
			rea.addAllAttributes(result.getModel());
			return "cardView";
		}
		if(this.cardService.updateCard(card) == 1) {
			rea.addFlashAttribute("message","수정 완료.");
			return "redirect:list";
		}
		else {
			rea.addFlashAttribute("message","수정 실패하였습니다. 확인 후 다시 시도하여 주십시오.");
			return "redirect:list";
		}
	}
	
	@RequestMapping(value="/delete.do", method=RequestMethod.POST)
	public String delete(@RequestParam(value="bno")int bno, RedirectAttributes rea) throws Exception{
		if(this.cardService.deleteCard(bno) == 1) {
			rea.addFlashAttribute("message","삭제 완료.");
			return "redirect:list";
		}
		else {
			rea.addFlashAttribute("message","삭제 실패하였습니다. 확인 후 다시 시도하여 주십시오.");
			return "redirect:list";
		}
	}
	
	
	
	
	
	
	
}
