/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.optional.api.LuceneIndexDescriptor;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.analysis.bg.BulgarianAnalyzer;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.ga.IrishAnalyzer;
import org.apache.lucene.analysis.gl.GalicianAnalyzer;
import org.apache.lucene.analysis.hi.HindiAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.id.IndonesianAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.lv.LatvianAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.util.Version;

public abstract class LuceneUtils {
    public static final String TEXT_FIELD_NAME = "luceneTextField";
    private static HashMap<String, Class<? extends Analyzer>> _analyzerClasses = new HashMap();

    public static Version currentVersion() {
        Version version = null;
        for (Version version2 : Version.values()) {
            if (version2 == Version.LUCENE_CURRENT) continue;
            if (version == null) {
                version = version2;
                continue;
            }
            if (!version2.onOrAfter(version)) continue;
            version = version2;
        }
        return version;
    }

    public static Analyzer defaultAnalyzer() throws SQLException {
        return LuceneUtils.getAnalyzerForLocale(ConnectionUtil.getCurrentLCC().getDatabase().getLocale());
    }

    public static Analyzer getAnalyzerForLocale(Locale locale) throws SQLException {
        String string = locale.getLanguage();
        try {
            Class<? extends Analyzer> clazz = _analyzerClasses.get(string);
            if (clazz == null) {
                return LuceneUtils.standardAnalyzer();
            }
            Constructor<? extends Analyzer> constructor = clazz.getConstructor(Version.class);
            return constructor.newInstance(LuceneUtils.currentVersion());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw LuceneUtils.wrap(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw LuceneUtils.wrap(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw LuceneUtils.wrap(invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw LuceneUtils.wrap(noSuchMethodException);
        }
    }

    public static Analyzer standardAnalyzer() {
        return new StandardAnalyzer(LuceneUtils.currentVersion());
    }

    public static QueryParser defaultQueryParser(Version version, String[] stringArray, Analyzer analyzer) {
        return new MultiFieldQueryParser(version, stringArray, analyzer);
    }

    public static LuceneIndexDescriptor defaultIndexDescriptor() {
        return new DefaultIndexDescriptor();
    }

    private static void storeAnalyzerClass(Class<? extends Analyzer> clazz) {
        _analyzerClasses.put(LuceneUtils.getLanguageCode(clazz), clazz);
    }

    private static String getLanguageCode(Class<? extends Analyzer> clazz) {
        String string = clazz.getName();
        String string2 = string.substring(0, string.lastIndexOf("."));
        String string3 = string2.substring(string2.lastIndexOf(".") + 1, string2.length());
        return string3;
    }

    private static SQLException wrap(Throwable throwable) {
        return LuceneUtils.sqlException(StandardException.plainWrapException((Throwable)throwable));
    }

    private static SQLException sqlException(StandardException standardException) {
        return PublicAPI.wrapStandardException((StandardException)standardException);
    }

    static {
        LuceneUtils.storeAnalyzerClass(ArabicAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(ArmenianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(BasqueAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(BrazilianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(BulgarianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(CatalanAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(CzechAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(DanishAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(DutchAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(EnglishAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(FinnishAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(FrenchAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(GalicianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(GermanAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(GreekAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(HindiAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(HungarianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(IndonesianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(IrishAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(ItalianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(LatvianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(NorwegianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(PersianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(PortugueseAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(RomanianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(RussianAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(SpanishAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(SwedishAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(ThaiAnalyzer.class);
        LuceneUtils.storeAnalyzerClass(TurkishAnalyzer.class);
    }

    public static class DefaultIndexDescriptor
    implements LuceneIndexDescriptor {
        @Override
        public String[] getFieldNames() {
            return new String[]{LuceneUtils.TEXT_FIELD_NAME};
        }

        @Override
        public Analyzer getAnalyzer() throws SQLException {
            return LuceneUtils.defaultAnalyzer();
        }

        @Override
        public QueryParser getQueryParser() throws SQLException {
            return LuceneUtils.defaultQueryParser(LuceneUtils.currentVersion(), this.getFieldNames(), this.getAnalyzer());
        }
    }
}

