/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.db.dialogs.BaseDBEditorFactory;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.db.model.DBObjectPropertyNode;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ideimpl.db.explorer.model.BaseFolder;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.DBObjectFolder;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.ideimpl.db.explorer.model.PlSqlFragmentElement;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;

public class DBObjectFolderFactory {
    public static Element createRootFolder(DBObjectNode dBObjectNode, Context context) {
        return new SimpleRoot(dBObjectNode, context);
    }

    public static void update(Element element) {
        if (element instanceof DBExplorerElement) {
            ((DBExplorerElement)element).reset();
        }
    }

    public static void setErrors(final Element element, final List<Element> list) {
        if (element instanceof BaseFolder) {
            if (SwingUtilities.isEventDispatchThread()) {
                ((BaseFolder)element).setErrors(list);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((BaseFolder)element).setErrors(list);
                    }
                });
            }
        }
    }

    public static boolean canGoToDeclaration(Context context) {
        boolean bl = false;
        if (context.getView() instanceof ExplorerWindow) {
            Element element;
            Node node = context.getNode();
            if (node instanceof BaseDBObjectTextNode) {
                return DBObjectFolderFactory.getElementWeCanGoTo(context.getElement()) != null;
            }
            if (node instanceof DBObjectNode && !DBObjectNodeUtil.isOnlineNode((Object)node) && (element = DBObjectFolderFactory.getElementWeCanGoTo(context.getElement())) != null) {
                DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getEditFactory((DBObjectNode)((DBObjectNode)node));
                bl = dBEditorFactory != null;
            }
        }
        return bl;
    }

    public static void handleGoToDeclaration(Context context) {
        Element element;
        Node node = context.getNode();
        if (node instanceof DBObjectNode && (element = DBObjectFolderFactory.getElementWeCanGoTo(context.getElement())) != null) {
            DBEditorConfig dBEditorConfig = DBEditorConfig.newEditConfig((DBObjectNode)((DBObjectNode)node));
            DBObject dBObject = null;
            String string = null;
            if (element instanceof DBObjectNode) {
                dBObject = ((DBObjectNode)element).getDBObject();
            } else if (element instanceof DBObjectPropertyNode) {
                dBObject = ((DBObjectPropertyNode)element).getParentDBObject();
                string = ((DBObjectPropertyNode)element).getPropertyName();
            }
            if (dBObject != null && dBObject.getParent() != null) {
                dBEditorConfig.setChildObject(dBObject);
            }
            dBEditorConfig.setProperty(string);
            if (node instanceof BaseDBObjectTextNode) {
                BaseDBEditorFactory.showEditor((DBEditorConfig)dBEditorConfig);
            } else {
                DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getEditFactory((DBObjectNode)((DBObjectNode)node));
                if (dBEditorFactory != null) {
                    dBEditorFactory.launchDialog(dBEditorConfig);
                }
            }
        }
    }

    private static Element getElementWeCanGoTo(Element element) {
        Element element2 = null;
        if (element instanceof DBObjectNode || element instanceof DBObjectPropertyNode) {
            element2 = element;
        } else if (element instanceof BaseFolder) {
            element2 = DBObjectFolderFactory.getElementWeCanGoTo(((BaseFolder)element).getParentElement());
        }
        return element2;
    }

    private static class SimpleRoot
    extends BaseFolder {
        private DBObjectNode m_node;
        private Context m_context;
        private DBObjectFolder m_root;

        public SimpleRoot(DBObjectNode dBObjectNode, Context context) {
            this.m_node = dBObjectNode;
            this.m_context = context;
            this.setHelper(new ExplorerModelHelper(context));
        }

        @Override
        protected List<Element> createChildren(List<Element> list) {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            if (this.m_root == null) {
                this.m_root = this.m_node instanceof DBObjectPlSqlNode ? new PlSqlFragmentElement(this.m_node) : new DBObjectFolder(this.m_node);
            } else {
                this.m_root.setDBObjectNode(this.m_node);
            }
            this.getHelper().setRootFolder(this.m_root);
            arrayList.add(this.m_root);
            return arrayList;
        }

        public String getShortLabel() {
            return "root";
        }

        @Override
        public String getLongLabel() {
            return this.m_node.getLongLabel();
        }

        public Icon getIcon() {
            return this.m_node.getIcon();
        }

        @Override
        public String getToolTipText() {
            return this.m_node.getToolTipText();
        }

        @Override
        public Object getKey() {
            return this.m_node.getURL();
        }

        @Override
        protected DBObjectProvider useDBRunnable() {
            if (this.m_root != null) {
                return this.m_root.useDBRunnable();
            }
            return super.useDBRunnable();
        }
    }
}

