/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.highlight;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.linkconnector.IlvShapePath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import oracle.diagram.framework.highlight.HighlightHelper;
import oracle.diagram.framework.notification.Notification;
import oracle.diagram.framework.transformer.TransformerUtil;

public class DefaultHighlightHelper
implements HighlightHelper {
    private static final float BORDER_THICKNESS = 4.0f;
    private static final float CORNER_SIZE = 4.0f;
    private static final IlvRect M_TEMPRECT = new IlvRect();

    @Override
    public String getId() {
        return "oracle.diagram.framework.highlight.DefaultHighlightHelper";
    }

    @Override
    public void drawHighlighted(Graphics2D graphics2D, IlvManager mgr, IlvGraphic graphic, IlvRect highlightingBounds, IlvTransformer transformer) {
        Shape shape = this.createHighlighterShape(graphic, transformer);
        float borderThickness = TransformerUtil.getApplied(transformer, 4.0f);
        Stroke savedStroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(borderThickness));
        graphics2D.setPaint(Color.lightGray);
        graphics2D.draw(shape);
        graphics2D.setStroke(savedStroke);
    }

    protected Shape createHighlighterShape(IlvGraphic graphic, IlvTransformer t) {
        GeneralPath shape = new GeneralPath();
        if (graphic instanceof IlvShapePath) {
            PathIterator path = ((IlvShapePath)graphic).getShapePath(t);
            shape.append(path, false);
            return shape;
        }
        IlvRect r = this.calcHighlightingBounds(graphic, M_TEMPRECT);
        t.apply(r);
        shape.moveTo(r.x + 4.0f, r.y);
        shape.lineTo(r.x + r.width - 4.0f, r.y);
        shape.quadTo(r.x + r.width, r.y, r.x + r.width, r.y + 4.0f);
        shape.lineTo(r.x + r.width, r.y + r.height - 4.0f);
        shape.quadTo(r.x + r.width, r.y + r.height, r.x + r.width - 4.0f, r.y + r.height);
        shape.lineTo(r.x + 4.0f, r.y + r.height);
        shape.quadTo(r.x, r.y + r.height, r.x, r.y + r.height - 4.0f);
        shape.lineTo(r.x, r.y + 4.0f);
        shape.quadTo(r.x, r.y, r.x + 4.0f, r.y);
        return shape;
    }

    @Override
    public IlvRect calcHighlightingBounds(IlvGraphic graphic, IlvRect bounds) {
        IlvRect bBox = graphic.boundingBox();
        float border = 2.0f;
        bBox.setFrame((double)bBox.x, (double)bBox.y, (double)(bBox.width - border), (double)(bBox.height - border));
        if (bounds == null) {
            bounds = bBox;
        } else {
            bounds.setFrame((Rectangle2D)bBox);
        }
        return bounds;
    }

    @Override
    public boolean shouldHighlight(Notification notification, IlvGraphic graphic) {
        return false;
    }

    @Override
    public boolean shouldHighlightDefault(IlvGraphic graphic) {
        return true;
    }

    @Override
    public void willHighlightGraphic(IlvGraphic graphic) {
    }

    @Override
    public void willUnhighlightGraphic(IlvGraphic graphic) {
    }
}

