/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.interaction;

import ilog.views.IlvObjectInteractor;
import java.util.HashMap;
import java.util.Map;

public class DefaultObjectInteractorCache {
    private Map<String, IlvObjectInteractor> _defaultInteractors = new HashMap<String, IlvObjectInteractor>();
    private final String _packagePrefix;
    private final String[] _prefixes;

    public DefaultObjectInteractorCache(String packagePrefix, String ... prefixes) {
        this._packagePrefix = packagePrefix;
        String[] stringArray = this._prefixes = prefixes != null ? new String[prefixes.length] : null;
        if (prefixes != null) {
            System.arraycopy(prefixes, 0, this._prefixes, 0, prefixes.length);
        }
    }

    public final String getPackagePrefix() {
        return this._packagePrefix;
    }

    public IlvObjectInteractor getDefaultObjectInteractor(String defaultName) {
        if (defaultName.equals("Button") || defaultName.equals("Toggle")) {
            defaultName = "ilog.views.objectinteractor.IlvButtonInteractor";
        } else if (defaultName.equals("ilog.views.IlvButtonInteractor")) {
            defaultName = "ilog.views.objectinteractor.IlvButtonInteractor";
        } else if (defaultName.equals("ilog.views.IlvMoveObjectInteractor")) {
            defaultName = "ilog.views.objectinteractor.IlvMoveObjectInteractor";
        }
        IlvObjectInteractor i = this._defaultInteractors.get(defaultName);
        if (i != null) {
            return i;
        }
        if (defaultName.indexOf(36) != -1) {
            IlvObjectInteractor result = IlvObjectInteractor.Get((String)defaultName);
            this._defaultInteractors.put(defaultName, result);
            return result;
        }
        int index = defaultName.lastIndexOf(46);
        if (index != -1) {
            String className = defaultName.substring(index + 1);
            if (className.startsWith("Ilv")) {
                className = className.substring(3);
            }
            IlvObjectInteractor o = null;
            if (this._prefixes != null) {
                for (String prefix : this._prefixes) {
                    String clazzName;
                    if (className.startsWith(prefix) || (o = IlvObjectInteractor.Get((String)(clazzName = this.getPackagePrefix() + "." + prefix + className))) == null) continue;
                    this._defaultInteractors.put(clazzName, o);
                    break;
                }
            }
            if (o == null) {
                o = IlvObjectInteractor.Get((String)defaultName);
            }
            this._defaultInteractors.put(defaultName, o);
            return o;
        }
        IlvObjectInteractor result = IlvObjectInteractor.Get((String)defaultName);
        this._defaultInteractors.put(defaultName, result);
        return result;
    }
}

