/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.palette.interactor;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvRect;
import java.awt.Dimension;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.editor.JViewsEditor;
import oracle.diagram.framework.palette.PaletteTask;
import oracle.diagram.framework.palette.interactor.InteractorPaletteTask;
import oracle.diagram.framework.palette.interactor.MakeNodeInteractor;
import oracle.diagram.framework.palette.interactor.NodeItemFactory;
import oracle.ide.palette2.PaletteItem;

public abstract class AbstractNodeItemFactory
implements NodeItemFactory {
    private static final Dimension MIN_SIZE = new Dimension(30, 30);
    private static final Dimension PREFERRED_SIZE = new Dimension(120, 120);
    private final boolean _isGrapherMode;

    public AbstractNodeItemFactory(boolean isGrapherMode) {
        this._isGrapherMode = isGrapherMode;
    }

    @Override
    public PaletteTask createPaletteTask(DiagramContext context, PaletteItem item) {
        InteractorPaletteTask task = new InteractorPaletteTask(context, item);
        task.setInteractor(this.createInteractor(task));
        return task;
    }

    public abstract IlvGraphic createObject(IlvRect var1);

    protected IlvManagerViewInteractor createInteractor(PaletteTask task) {
        return new MakeNodeInteractor(task, this);
    }

    public final void initializeNewObject(JViewsEditor editor, PaletteItem item, IlvGraphic newGraphic) {
        throw new IllegalStateException("should be calling initializeNewObject(DiagramContext...)");
    }

    public final void initializeNewObject(JViewsEditor editor, IlvManagerView view, PaletteItem item, IlvGraphic context, IlvGraphic newGraphic) {
        throw new IllegalStateException("should be calling initializeNewObject(DiagramContext...)");
    }

    @Override
    public void initializeNewObject(DiagramContext diagramContext, PaletteItem item, IlvGraphic context, IlvGraphic newGraphic) {
    }

    public final void postCreateNewObject(JViewsEditor editor, PaletteItem item, IlvGraphic newGraphic, boolean isDefaultCreate) {
        throw new IllegalStateException("should be calling postCreateNewObject(DiagramContext...)");
    }

    public final void postCreateNewObject(JViewsEditor editor, IlvManagerView view, PaletteItem item, IlvGraphic context, IlvGraphic newGraphic, boolean isDefaultCreate) {
        throw new IllegalStateException("should be calling postCreateNewObject(DiagramContext...)");
    }

    @Override
    public void postCreateNewObject(DiagramContext diagramContext, PaletteItem item, IlvGraphic context, IlvGraphic newGraphic, boolean isDefaultCreate) {
    }

    @Override
    public boolean isGrapherMode() {
        return this._isGrapherMode;
    }

    @Override
    public Dimension getMinimumSize() {
        return MIN_SIZE;
    }

    @Override
    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    @Override
    public boolean isValidContext(PaletteItem paletteItem, IlvGraphic context) {
        return context instanceof IlvManager;
    }

    @Override
    public String getType(PaletteItem item) {
        return item.getName();
    }
}

