/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.preference;

import java.util.ArrayList;
import java.util.List;
import oracle.diagram.framework.preference.PreferenceDefinition;
import oracle.diagram.framework.preference.PreferenceStore;
import oracle.diagram.framework.preference.PreferenceStoreListener;
import oracle.diagram.framework.preference.event.PreferenceStoreEvent;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.util.Copyable;

public class PreferenceStoreHashStructureAdapter
extends HashStructureAdapter
implements PreferenceStore,
Copyable {
    private final HashStructure _hs;
    private final List<PreferenceStoreListener> _listeners = new ArrayList<PreferenceStoreListener>();

    public PreferenceStoreHashStructureAdapter(HashStructure hs) {
        super(hs);
        this._hs = hs;
    }

    @Override
    public void addPreferenceStoreListener(PreferenceStoreListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    @Override
    public void removePreferenceStoreListener(PreferenceStoreListener listener) {
        this._listeners.remove(listener);
    }

    @Override
    public boolean hasPreferenceValue(PreferenceDefinition preference) {
        return this._hs.containsKey(preference.getStorageKey());
    }

    @Override
    public Object getPreferenceValue(PreferenceDefinition preference) {
        if (!this.hasPreferenceValue(preference)) {
            return null;
        }
        return preference.getValueMarshaller().decodeValue(preference.getType(), this._hs.getString(preference.getStorageKey()));
    }

    @Override
    public Object setPreferenceValue(PreferenceDefinition preference, Object value) {
        Object oldValue = this.getPreferenceValue(preference);
        this._hs.putString(preference.getStorageKey(), preference.getValueMarshaller().encodeValue(value));
        this.firePreferenceChange(new PreferenceDefinition[]{preference}, new Object[]{oldValue}, new Object[]{value});
        return oldValue;
    }

    @Override
    public void setPreferenceValues(PreferenceDefinition[] preferences, Object[] values) {
        Object[] oldValues = new Object[values.length];
        for (int i = 0; i < preferences.length; ++i) {
            oldValues[i] = this.getPreferenceValue(preferences[i]);
            this._hs.putString(preferences[i].getStorageKey(), preferences[i].getValueMarshaller().encodeValue(values[i]));
        }
        this.firePreferenceChange(preferences, oldValues, values);
    }

    protected final void firePreferenceChange(PreferenceDefinition[] prefs, Object[] oldValues, Object[] newValues) {
        PreferenceStoreListener[] copy;
        PreferenceStoreEvent event = new PreferenceStoreEvent(this, prefs, oldValues, newValues);
        for (PreferenceStoreListener l : copy = this._listeners.toArray(new PreferenceStoreListener[this._listeners.size()])) {
            try {
                l.preferenceStoreChanged(event);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

