/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.composite.layout.IlvAttachmentLayout;
import ilog.views.graphic.composite.layout.IlvLayoutManager;
import ilog.views.linkconnector.IlvShapePath;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.PathIterator;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ContainerGraphic;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.OpenRectangleOutline;
import oracle.diagram.framework.graphic.SingleLineText;
import oracle.diagram.framework.graphic.layout.Anchor;
import oracle.diagram.framework.preference.VisualProperty;
import oracle.diagram.framework.selection.SubSelectionManager;

public abstract class AbstractHeaderGraphic
extends ContainerGraphic
implements IlvShapePath,
ExtendedGraphic,
VisualProperty {
    private OpenRectangleOutline m_outline;
    private Color m_fillColor = null;
    private Color m_lineColor = null;
    private Color m_fontColor = null;
    private Font m_font = null;
    private SingleLineText m_textShape = null;
    private Anchor _anchor;

    protected AbstractHeaderGraphic(String headerText, Anchor headerAnchor) {
        this.setLayout((IlvLayoutManager)new IlvAttachmentLayout());
        this.setTopLevel(false);
        this.m_outline = new OpenRectangleOutline(new IlvRect(0.0f, 0.0f, 10.0f, 10.0f));
        this.m_outline.setFillOn(true);
        this.m_outline.setGradientFillOn(false);
        this.m_outline.setThickness(1.0f);
        this.addContent(this.m_outline);
        SubSelectionManager.setSelectable(this.m_outline, false);
        this.setShapeFillColor(Color.WHITE);
        this.setShapeLineColor(Color.GREEN);
        this.m_textShape = SingleLineText.createEditableSingleLineText(headerText, false);
        this.m_textShape.setFont(this.m_textShape.getFont().deriveFont(1, 12.0f));
        this.m_textShape.setFontColor(Color.BLACK);
        SubSelectionManager.setSelectable((IlvGraphic)this.m_textShape, false);
        this._anchor = headerAnchor;
        this.addTextShape(this.m_textShape, this._anchor);
        this.setProperty("NonEllipsisShape", Boolean.TRUE);
    }

    public OpenRectangleOutline getOutline() {
        return this.m_outline;
    }

    public Anchor getTextAnchor() {
        return this._anchor;
    }

    protected abstract void addTextShape(SingleLineText var1, Anchor var2);

    public void setOpenBorders(boolean isTopOpen, boolean isLeftOpen, boolean isBottomOpen, boolean isRightOpen) {
        this.m_outline.setOpenBorders(isTopOpen, isLeftOpen, isBottomOpen, isRightOpen);
    }

    public SingleLineText getTextShape() {
        return this.m_textShape;
    }

    @Override
    public DimensionFloat getMinimumSize(DimensionFloat minimum) {
        IlvGraphic text = this.getChildren(1);
        IlvRect bbox = text.boundingBox(null);
        minimum.height = bbox.height + 2.0f * this.m_outline.getThickness();
        minimum.width = bbox.width + 2.0f * this.m_outline.getThickness();
        return minimum;
    }

    @Override
    public DimensionFloat getPreferedSize(DimensionFloat prefered) {
        IlvGraphic text = this.getChildren(1);
        IlvRect bbox = text.boundingBox(null);
        prefered.height = bbox.height + 2.0f * this.m_outline.getThickness();
        prefered.width = bbox.width + 2.0f * this.m_outline.getThickness();
        return prefered;
    }

    @Override
    public void draw(Graphics g, IlvTransformer t) {
        super.draw(g, t);
    }

    @Override
    protected void drawImpl(Graphics2D g2d, IlvRect clipRect, IlvTransformer tx) {
        Graphics2D g2dcopy = (Graphics2D)g2d.create();
        super.drawImpl(g2dcopy, clipRect, tx);
        g2dcopy.dispose();
        if (this.checkPartiallyDrawable(this.m_outline, clipRect, tx)) {
            this.m_outline.drawBorder(g2d, tx);
        }
    }

    public void moveResize(IlvRect size) {
        super.moveResize(size);
        this.m_outline.moveResize(size);
    }

    public void translate(float dx, float dy) {
        super.translate(dx, dy);
    }

    public void resize(float neww, float newh) {
        super.resize(neww, newh);
        this.m_outline.resize(neww, newh);
    }

    @Override
    public IlvRect boundingBox(IlvTransformer t) {
        return this.m_outline.boundingBox(t);
    }

    protected void setLineThicknessImpl(float thickness) {
        this.m_outline.setThickness(thickness);
        this.invalidate();
    }

    public Float getShapeLineThickness() {
        return Float.valueOf(this.m_outline.isBorderOn() ? this.m_outline.getThickness() : 0.0f);
    }

    public void setShapeLineThickness(float thickness) {
        if (thickness == 0.0f) {
            this.m_outline.setBorderOn(false);
            this.setLineThicknessImpl(1.0f);
        } else {
            this.m_outline.setVisible(true);
            this.setLineThicknessImpl(thickness);
        }
    }

    @Override
    public PathIterator getShapePath(IlvTransformer t) {
        return this.m_outline.getShapePath(t);
    }

    public void setFillOn(boolean value) {
        this.m_outline.setFillOn(value);
    }

    public boolean isFillOn() {
        return this.m_outline.isFillOn();
    }

    @Override
    public Color getShapeFillColor() {
        return this.m_fillColor;
    }

    @Override
    public void setShapeFillColor(Color color) {
        this.m_fillColor = color;
        this.m_outline.setBackground(this.m_fillColor);
    }

    @Override
    public Font getShapeFont() {
        return this.m_font;
    }

    @Override
    public void setShapeFont(Font font) {
        this.m_font = font;
        this.m_textShape.setFont(this.m_font);
    }

    @Override
    public Color getShapeLineColor() {
        return this.m_lineColor;
    }

    @Override
    public void setShapeLineColor(Color color) {
        this.m_lineColor = color;
        this.m_outline.setForeground(color);
    }

    @Override
    public Color getShapeFontColor() {
        return this.m_fontColor;
    }

    @Override
    public void setShapeFontColor(Color color) {
        this.m_fontColor = color;
        this.m_textShape.setFontColor(color);
    }
}

