/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvRectangle;
import java.util.List;
import oracle.diagram.framework.geom.DimensionFloat;
import oracle.diagram.framework.graphic.ExtendedGraphic;
import oracle.diagram.framework.graphic.OpenRectangleOutline;
import oracle.diagram.framework.graphic.layout.Anchor;
import oracle.diagram.framework.graphic.layout.Fill;
import oracle.diagram.framework.graphic.layout.ListConstraint;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.shape.SubShape;
import oracle.diagram.framework.swimlanes.graphic.AbstractHeaderGraphic;
import oracle.diagram.framework.swimlanes.graphic.ExtendedSwimlaneGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;
import oracle.diagram.framework.swimlanes.graphic.VerticalHeaderGraphic;
import oracle.diagram.framework.swimlanes.graphic.VerticalPoolGraphic;

public class VerticalSwimlaneGraphic
extends ExtendedSwimlaneGraphic
implements SubShape {
    public VerticalSwimlaneGraphic(IlvRect rect, String title, Anchor titleAnchor, SwimlaneGraphic pool) {
        super(rect);
        this.addSubComponents(title, titleAnchor, pool);
    }

    @Override
    protected void addSubComponents(String title, Anchor titleAnchor, SwimlaneGraphic pool) {
        this.setChildren(new IlvGraphic[]{this.getOutline()});
        if (title != null && titleAnchor != null) {
            AbstractHeaderGraphic oldHeader = this.getHeader();
            VerticalHeaderGraphic header = new VerticalHeaderGraphic(title, titleAnchor);
            if (oldHeader != null) {
                header.setShapeFillColor(oldHeader.getShapeFillColor());
                header.setShapeFont(oldHeader.getShapeFont());
                header.setShapeFontColor(oldHeader.getShapeFontColor());
                header.setShapeLineColor(oldHeader.getShapeLineColor());
                header.setShapeLineThickness(oldHeader.getShapeLineThickness().floatValue());
                header.setFillOn(oldHeader.isFillOn());
                OpenRectangleOutline oldOutline = header.getOutline();
                header.setOpenBorders(oldOutline.isTopOpen(), oldOutline.isLeftOpen(), oldOutline.isBottomOpen(), oldOutline.isRightOpen());
            } else {
                if (this.getShapeFillColor() != null) {
                    header.setShapeFillColor(this.getShapeFillColor());
                }
                if (this.getShapeFont() != null) {
                    header.setShapeFont(this.getShapeFont());
                }
                if (this.getShapeFontColor() != null) {
                    header.setShapeFontColor(this.getShapeFontColor());
                }
                if (this.getShapeLineColor() != null) {
                    header.setShapeLineColor(this.getShapeLineColor());
                }
                if (this.getShapeLineThickness() != null) {
                    header.setShapeLineThickness(this.getShapeLineThickness().floatValue());
                }
                header.setFillOn(false);
                header.setOpenBorders(this.getShapeLineThickness().floatValue() > 0.0f, true, true, true);
            }
            this.addContent(header, ListConstraint.create(titleAnchor, Fill.HORIZONTAL));
            SubSelectionManager.setSelectable((IlvGraphic)header, false);
            this.setHeader(header);
        } else {
            this.setHeader(null);
        }
        if (pool == null) {
            FillerShape filler = new FillerShape();
            this.addContent(filler, ListConstraint.create(Anchor.CENTER, Fill.BOTH, 1.0f));
            this.setPool(null);
        } else {
            this.addContent(pool, ListConstraint.create(Anchor.CENTER, Fill.BOTH, 1.0f));
            pool.setTopLevel(false);
            SubSelectionManager.setSelectable((IlvGraphic)pool, false);
            this.setPool(pool);
        }
    }

    @Override
    public int getFlowDirection() {
        return 8;
    }

    @Override
    public IlvRect getInteriorBoundingBox(IlvTransformer t) {
        IlvRect intRect = new IlvRect(super.getInteriorBoundingBox(t));
        IlvRect headerRect = this.getHeader().boundingBox(t);
        intRect.height -= headerRect.height;
        intRect.y += headerRect.height;
        return intRect;
    }

    @Override
    public boolean isLayoutCurrent() {
        if (this.getPool() != null) {
            return this.getPool().isLayoutCurrent();
        }
        DimensionFloat prefSize = this.getPreferedSize(new DimensionFloat());
        IlvRect bbox = this.boundingBox(null);
        return prefSize.width == bbox.width && bbox.height >= prefSize.height;
    }

    @Override
    public DimensionFloat getMinimumSize(DimensionFloat minimum) {
        DimensionFloat d = super.getMinimumSize(minimum);
        d.width = Math.max(d.width, 4.0f);
        if (this.getHeader() != null) {
            DimensionFloat d1 = this.getHeader().getTextShape().getMinimumSize(new DimensionFloat());
            d.width = Math.max(d.width, d1.width);
        }
        if (this.getPool() != null) {
            DimensionFloat d2 = this.getPool().getMinimumSize(new DimensionFloat());
            d.width = Math.max(d.width, d2.width);
        }
        return d;
    }

    @Override
    public DimensionFloat getMinimumSwimlaneSize(DimensionFloat minimum) {
        DimensionFloat dim = super.getMinimumSwimlaneSize(minimum);
        IlvRect r = this.computeContentsBBox();
        if (r != null) {
            dim.width = Math.max(dim.width, r.width);
        }
        if (this.getPool() != null) {
            DimensionFloat d2 = this.getPool().getMinimumSwimlaneSize(new DimensionFloat());
            dim.width = Math.max(dim.width, d2.width);
        }
        return dim;
    }

    @Override
    public DimensionFloat getPreferedSize(DimensionFloat prefered) {
        DimensionFloat d = this.getPool() != null ? this.getPool().getPreferedSize(prefered) : super.getPreferedSize(prefered);
        d.width = Math.max(d.width, 4.0f);
        return d;
    }

    @Override
    public void setPreferedSize(DimensionFloat prefered) {
        if (this.getPool() != null) {
            List<SwimlaneGraphic> lanes = ((VerticalPoolGraphic)this.getPool()).getLanes();
            int count = lanes.size();
            if (count == 0) {
                super.setPreferedSize(prefered);
            } else {
                float delta = prefered.width - this.getPool().getPreferedSize((DimensionFloat)new DimensionFloat()).width;
                SwimlaneGraphic lastLane = lanes.get(count - 1);
                DimensionFloat d = lastLane.getPreferedSize(new DimensionFloat());
                lastLane.setPreferedSize(new DimensionFloat(d.width + delta, d.height));
            }
        } else {
            super.setPreferedSize(prefered);
        }
    }

    private static class FillerShape
    extends IlvRectangle
    implements ExtendedGraphic {
        public FillerShape() {
            super(new IlvRect(0.0f, 0.0f, 1.0f, 1.0f), false, false);
            SubSelectionManager.setSelectable((IlvGraphic)this, false);
        }

        @Override
        public DimensionFloat getMinimumSize(DimensionFloat minimum) {
            return new DimensionFloat(1.0f, 1.0f);
        }

        @Override
        public DimensionFloat getPreferedSize(DimensionFloat prefered) {
            return new DimensionFloat(1.0f, 1.0f);
        }

        @Override
        public void doLayout() {
        }
    }
}

