/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.swimlanes.palette;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvRect;
import java.awt.Dimension;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.framework.graphic.layout.column.ColumnContainer;
import oracle.diagram.framework.graphic.layout.row.RowContainer;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.framework.palette.CreateDefaultNodeHandler;
import oracle.diagram.framework.palette.interactor.NodeItemFactory;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.framework.swimlanes.SwimlanesPlugin;
import oracle.diagram.framework.swimlanes.graphic.ExtendedSwimlaneGraphic;
import oracle.diagram.framework.swimlanes.graphic.PoolGraphic;
import oracle.diagram.framework.swimlanes.graphic.SwimlaneGraphic;
import oracle.ide.palette2.PaletteItem;

public class CreateDefaultNodeInSwimlaneHandler
extends CreateDefaultNodeHandler {
    public CreateDefaultNodeInSwimlaneHandler(DiagramContext context, PaletteItem item, NodeItemFactory factory) {
        super(context, item, factory);
    }

    @Override
    protected boolean createNode(IlvGraphic context) {
        IlvGraphic g;
        if (!(context instanceof SwimlaneGraphic)) {
            return super.createNode(context);
        }
        IlvManagerView view = this.getManagerView();
        NodeItemFactory factory = this.getFactory();
        Dimension d = factory.getPreferredSize();
        SwimlaneGraphic sg = (SwimlaneGraphic)context;
        IlvRect sgIntBBox = sg.getInteriorBoundingBox(null);
        IlvRect viewBBox = new IlvRect((float)view.getX(), (float)view.getY(), (float)view.getWidth(), (float)view.getHeight());
        view.getTransformer().inverse(viewBBox);
        if (sgIntBBox.intersects(viewBBox)) {
            sgIntBBox.intersection(viewBBox);
        }
        IlvRect r = new IlvRect(Math.max(sgIntBBox.x, sgIntBBox.x + sgIntBBox.width / 2.0f - (float)d.width / 2.0f), Math.max(sgIntBBox.y, sgIntBBox.y + sgIntBBox.height / 2.0f - (float)d.height / 2.0f), (float)d.width, (float)d.height);
        if (sg.getTopSwimlane().isAutoExpand()) {
            int flowDirection = sg.getFlowDirection();
            if (flowDirection == 8) {
                if (sgIntBBox.width <= r.width) {
                    float newWidth = r.width + 1.0f + 2.0f * sg.getShapeLineThickness().floatValue();
                    ColumnContainer container = (ColumnContainer)sg.getGraphicBag();
                    int index = container.getColumnGraphicIndex(sg);
                    container.resizeColumn(index, newWidth);
                }
            } else if (flowDirection == 2 && sgIntBBox.height <= r.height) {
                float newHeight = r.height + 1.0f + 2.0f * sg.getShapeLineThickness().floatValue();
                RowContainer container = (RowContainer)sg.getGraphicBag();
                int index = container.getRowGraphicIndex(sg);
                container.resizeRow(index, newHeight);
            }
        }
        if ((g = factory.createObject(r)) != null) {
            IlvManager mgr = ManagerUtil.getManager(context);
            factory.initializeNewObject(this.getDiagramContext(), this.getPaletteItem(), (IlvGraphic)mgr, g);
            if (mgr instanceof IlvGrapher && this.getFactory().isGrapherMode()) {
                ((IlvGrapher)mgr).addNode(g, true);
            } else {
                mgr.addObject(g, true);
            }
            SubSelectionManager.getInstance().deselectAll(mgr, true);
            mgr.setSelectionAdjusting(true);
            mgr.deSelectAll(true);
            mgr.setSelected(g, true, true);
            mgr.setSelectionAdjusting(false);
            factory.postCreateNewObject(this.getDiagramContext(), this.getPaletteItem(), (IlvGraphic)mgr, g, true);
        }
        return true;
    }

    @Override
    protected List<IlvGraphic> getValidContexts() {
        List<IlvGraphic> contexts = super.getValidContexts();
        SwimlanesPlugin plugin = this.getDiagramContext().getPlugin(SwimlanesPlugin.class);
        if (plugin == null || plugin.getTopSwimlane(this.getDiagramContext().getManagerView().getManager()) == null) {
            return contexts;
        }
        IlvManager topManager = this.getDiagramContext().getManagerView().getManager();
        SwimlaneGraphic topSwimlane = plugin.getTopSwimlane(topManager);
        LinkedList<IlvGraphic> swimlaneContexts = new LinkedList<IlvGraphic>();
        this.getSwimlanes(swimlaneContexts, topSwimlane, topSwimlane.isAutoExpand(), this.getFactory().getPreferredSize());
        if (swimlaneContexts.isEmpty()) {
            return contexts;
        }
        swimlaneContexts.addAll(contexts);
        if (swimlaneContexts.contains(topManager) && !this.isManagerValidContext(topManager)) {
            swimlaneContexts.remove(topManager);
        }
        return Collections.unmodifiableList(swimlaneContexts);
    }

    protected boolean isManagerValidContext(IlvManager mgr) {
        return this.getFactory().isValidContext(this.getPaletteItem(), (IlvGraphic)mgr);
    }

    private void getSwimlanes(List<IlvGraphic> swimlaneContexts, SwimlaneGraphic sg, boolean isAutoExpand, Dimension nodeSize) {
        if (sg instanceof PoolGraphic) {
            for (SwimlaneGraphic lane : ((PoolGraphic)sg).getLanes()) {
                this.getSwimlanes(swimlaneContexts, lane, isAutoExpand, nodeSize);
            }
        } else if (sg instanceof ExtendedSwimlaneGraphic) {
            ExtendedSwimlaneGraphic esg = (ExtendedSwimlaneGraphic)sg;
            if (esg.getPool() != null) {
                this.getSwimlanes(swimlaneContexts, esg.getPool(), isAutoExpand, nodeSize);
            } else if (this.isValidContext(esg, isAutoExpand, nodeSize)) {
                swimlaneContexts.add((IlvGraphic)esg);
            }
        } else if (this.isValidContext(sg, isAutoExpand, nodeSize)) {
            swimlaneContexts.add((IlvGraphic)sg);
        }
    }

    private boolean isValidContext(SwimlaneGraphic sg, boolean isAutoExpand, Dimension nodeSize) {
        if (!this.getFactory().isValidContext(this.getPaletteItem(), (IlvGraphic)sg)) {
            return false;
        }
        if (isAutoExpand) {
            return true;
        }
        IlvRect sgIntBBox = sg.getInteriorBoundingBox(null);
        int flow = sg.getFlowDirection();
        if (flow == 2 || flow == 1) {
            return sgIntBBox.height > (float)nodeSize.height;
        }
        if (flow == 8 || flow == 4) {
            return sgIntBBox.width > (float)nodeSize.width;
        }
        return false;
    }
}

