/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.undo;

import oracle.diagram.framework.undo.CompositeUndoableStep;
import oracle.diagram.framework.undo.UndoableStep;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.model.Node;

public class UndoableStepCommand
extends Command {
    private final CompositeUndoableStep _steps = new CompositeUndoableStep();
    private final Node[] _affectedNodes;
    private boolean _first = true;
    private boolean _causesDirty = true;
    private boolean _oldDirtyState = false;

    public UndoableStepCommand(String description) {
        this(Ide.findOrCreateCmdID((String)UndoableStepCommand.class.getName()), description);
    }

    public UndoableStepCommand(int cmdId, String description) {
        this(cmdId, 0, description);
    }

    public UndoableStepCommand(int cmdId, int type, String description) {
        this(cmdId, type, description, null);
    }

    public UndoableStepCommand(int cmdId, int type, String description, Node[] affectedNodes) {
        super(cmdId, type, description);
        if (affectedNodes != null) {
            this._affectedNodes = new Node[affectedNodes.length];
            System.arraycopy(affectedNodes, 0, this._affectedNodes, 0, affectedNodes.length);
        } else {
            this._affectedNodes = null;
        }
    }

    public int doit() throws Exception {
        if (this._first) {
            this._first = false;
            this._oldDirtyState = this.getDocumentDirtyState();
            if (this.isDirtyingCommand()) {
                this.setDocumentDirtyState(true);
            }
            return 0;
        }
        this._steps.redo();
        this._steps.performPostUndoRedoAction();
        if (this.isDirtyingCommand()) {
            this.setDocumentDirtyState(true);
        }
        return 0;
    }

    public int undo() throws Exception {
        super.undo();
        this._steps.undo();
        this._steps.performPostUndoRedoAction();
        if (this.isDirtyingCommand()) {
            this.setDocumentDirtyState(this._oldDirtyState);
        }
        return 0;
    }

    public void addUndoableStep(UndoableStep step) {
        if (!this._first) {
            throw new IllegalStateException("Unable to add an UndoableStep to an UndoableStepCommand which has already been submitted to the CommandProcessor");
        }
        this._steps.addUndoableStep(step);
    }

    public final Node[] getAffectedNodes() {
        return this._affectedNodes;
    }

    public final boolean isEmpty() {
        return !this._steps.hasSteps();
    }

    public final void setDirtyingCommand(boolean dirty) {
        this._causesDirty = dirty;
    }

    protected final boolean isDirtyingCommand() {
        return this._causesDirty;
    }

    protected final boolean isInitialExecution() {
        return this._first;
    }

    protected void setDocumentDirtyState(boolean dirty) {
        this.getContext().getNode().markDirty(dirty);
    }

    protected boolean getDocumentDirtyState() {
        return this.getContext().getNode().isDirty();
    }
}

