/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.accessibility;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.sdm.IlvSDMEngine;
import java.util.Enumeration;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.accessibility.NavigateContextMenuBuilder;
import oracle.diagram.framework.accessibility.NavigateContextMenuPlugin;
import oracle.diagram.framework.selection.SubSelectionManager;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;

public class DefaultSDMNavigateContextMenuPlugin
extends AbstractPlugin
implements NavigateContextMenuPlugin {
    private final boolean _subSel;
    private final NavigateContextMenuBuilder _builder = this.createBuilder();

    public DefaultSDMNavigateContextMenuPlugin(boolean useSubSelection) {
        this._subSel = useSubSelection;
    }

    @Override
    public void addNavigateMenu(ContextMenu menu) {
        IlvManagerView view;
        Context context = menu.getContext();
        IlvManagerView ilvManagerView = view = context.getView() instanceof DiagramView ? ((DiagramView)context.getView()).getActiveManagerView() : null;
        if (view != null) {
            Object selectedObject;
            IlvSDMEngine engine = SDMDiagramContextUtil.getSDMEngine(view);
            IlvManager mgr = view.getManager();
            Enumeration selectedObjects = engine.getSelectedObjects();
            Object v1 = selectedObject = selectedObjects == null || !selectedObjects.hasMoreElements() ? null : selectedObjects.nextElement();
            if (selectedObjects.hasMoreElements()) {
                return;
            }
            IlvGraphic singleSelection = null;
            if (this._subSel) {
                IlvGraphicEnumeration e = SubSelectionManager.getInstance().getSelectedSubObjects(mgr);
                if (e.hasMoreElements() && selectedObject != null) {
                    return;
                }
                if (e.hasMoreElements()) {
                    singleSelection = e.nextElement();
                    if (e.hasMoreElements()) {
                        return;
                    }
                }
            }
            if (singleSelection == null && selectedObject != null) {
                singleSelection = engine.getGraphic(selectedObject, false);
            }
            if (singleSelection != null) {
                this.getBuilder().buildAndAddNavigateMenu(menu, singleSelection);
            }
        }
    }

    protected final NavigateContextMenuBuilder getBuilder() {
        return this._builder;
    }

    protected NavigateContextMenuBuilder createBuilder() {
        return new NavigateContextMenuBuilder();
    }
}

