/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.accessibility;

import ilog.views.IlvGraphic;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvManagerView;
import ilog.views.sdm.IlvSDMEngine;
import javax.swing.Icon;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.framework.accessibility.PresentableGraphicPlugin;
import oracle.diagram.framework.graphic.GraphicDescriptor;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.ide.Context;
import oracle.ide.model.Node;

public class DefaultSDMPresentableGraphicPlugin
extends AbstractPlugin
implements PresentableGraphicPlugin {
    private DiagramContext _context;
    private static final String _NAME_PROPERTY = "name";

    public DefaultSDMPresentableGraphicPlugin(DiagramContext context) {
        this._context = context;
    }

    @Override
    public GraphicDescriptor getGraphicDescriptor(IlvGraphic graphic) {
        IlvManagerView view = this.getManagerView();
        IlvSDMEngine engine = SDMDiagramContextUtil.getSDMEngine(this.getDiagramContext());
        Object obj = engine.getObject(graphic);
        String name = null;
        if (obj != null) {
            name = (String)engine.getModel().getObjectProperty(obj, this.getNamePropertyName());
        } else if (obj == null && graphic == view.getManager()) {
            Node node;
            Context ctxt = this.getDiagramContext().getPlugin(IdeContextPlugin.class).getContext();
            Node node2 = node = ctxt != null ? ctxt.getNode() : null;
            if (node != null) {
                name = node.getShortLabel();
            }
        }
        if (name == null && graphic instanceof IlvLabelInterface) {
            name = ((IlvLabelInterface)graphic).getLabel();
        }
        if (name == null && obj != null) {
            name = obj.toString();
        }
        return new DefaultGraphicDescriptor(name, null, null);
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    protected final IlvManagerView getManagerView() {
        return this._context.getManagerView();
    }

    protected String getNamePropertyName() {
        return _NAME_PROPERTY;
    }

    private static class DefaultGraphicDescriptor
    implements GraphicDescriptor {
        private String _name;
        private Icon _icon;
        private String _type;

        public DefaultGraphicDescriptor(String name, Icon icon, String type) {
            this._name = name;
            this._icon = icon;
            this._type = type;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Icon getIcon() {
            return this._icon;
        }

        @Override
        public String getType() {
            return this._type;
        }
    }
}

