/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.datatransfer;

import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class SDMTransferable
implements Transferable,
ClipboardOwner {
    public static final DataFlavor DEFAULT_FLAVOR = new DataFlavor(SDMTransferable.class, "defaultSDMTransferable");
    private final DataFlavor[] _flavors;
    private final IlvSDMEngine _engine;

    public SDMTransferable(IlvSDMEngine engine) {
        this(engine, DEFAULT_FLAVOR);
    }

    public SDMTransferable(IlvSDMEngine engine, DataFlavor flavor) {
        this._engine = engine;
        this._flavors = new DataFlavor[]{flavor};
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this._flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(this._flavors[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        IlvSDMEngine engine = this.getEngine();
        IlvSDMModel model = engine.getModel();
        Vector<Object> objects = new Vector<Object>(64);
        Enumeration e = engine.getSelectedObjects();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            objects.add(obj);
            if (!model.isLink(obj)) continue;
            objects.add(model.getFrom(obj));
            objects.add(model.getTo(obj));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            engine.getXMLConnector().writeXML(model, (OutputStream)new BufferedOutputStream(baos), objects.elements(), null);
            baos.flush();
            String string = baos.toString();
            return string;
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    protected IlvSDMEngine getEngine() {
        return this._engine;
    }
}

