/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import oracle.diagram.sdm.graphic.SDMCompositeNode;

public class SDMIndexedLabelCompositeNode
extends SDMCompositeNode {
    private String _label;
    private final int _index;

    public SDMIndexedLabelCompositeNode() {
        this(0);
    }

    public SDMIndexedLabelCompositeNode(int index) {
        this._index = index;
    }

    @Override
    public void setLabel(String label) {
        this._label = label;
        IlvGraphic[] children = this.getChildren();
        if (children != null && children.length > this._index) {
            this.updateLabel(children[this._index], label);
        }
    }

    @Override
    public String getLabel() {
        IlvLabelInterface li;
        IlvGraphic[] children = this.getChildren();
        if (children != null && children.length > this._index && (li = (IlvLabelInterface)children[this._index]) != null) {
            this._label = li.getLabel();
            return li.getLabel();
        }
        return this._label;
    }

    public int addChild(IlvGraphic g) {
        int i = super.addChild(g);
        if (i == this._index) {
            this.updateLabel(g, this._label);
        }
        return i;
    }

    public void setChildren(int i, IlvGraphic g) {
        super.setChildren(i, g);
        if (i == this._index) {
            this.updateLabel(g, this._label);
        }
    }

    public void setChildren(IlvGraphic[] children) {
        super.setChildren(children);
        if (children != null && children.length > this._index) {
            this.updateLabel(children[this._index], this._label);
        }
    }

    protected void updateLabel(IlvGraphic g, String label) {
        if (g instanceof IlvLabelInterface) {
            ((IlvLabelInterface)g).setLabel(label);
        }
    }

    public IlvRect getLabelBBox(IlvTransformer tx) {
        IlvLabelInterface li;
        IlvGraphic[] children = this.getChildren();
        if (children != null && children.length > this._index && (li = (IlvLabelInterface)children[this._index]) != null) {
            return li.getLabelBBox(tx);
        }
        return null;
    }

    public boolean supportMultiline() {
        IlvLabelInterface li;
        IlvGraphic[] children = this.getChildren();
        if (children != null && children.length > this._index && (li = (IlvLabelInterface)children[this._index]) != null) {
            return li.supportMultiline();
        }
        return false;
    }
}

