/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.inspector;

import ilog.views.IlvGrapher;
import ilog.views.IlvManagerView;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import ilog.views.sdm.event.SDMPropertyChangeEvent;
import ilog.views.sdm.event.SDMPropertyChangeListener;
import java.util.List;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.diagram.core.context.DiagramView;
import oracle.diagram.framework.inspector.AbstractDiagramContextPropertyModel;
import oracle.diagram.framework.preference.PreferenceDefinition;
import oracle.diagram.sdm.undo.SDMUndoUtil;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.inspector.PropertySetCommand;
import oracle.ide.model.Observer;

public class SDMDiagramContextPropertyModel
extends AbstractDiagramContextPropertyModel {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(final Object data, final int row, final int col) {
        final Context ideContext = this.getContext();
        Object id = this.getValueAt(row, this.getColumnIndex(COLUMN_ID));
        if (id instanceof PreferenceDefinition) {
            IlvManagerView view = ((DiagramView)ideContext.getProperty("oracle.diagram.inspector.ActiveInspectedView")).getActiveManagerView();
            IlvSDMEngine engine = IlvSDMEngine.getSDMEngine((IlvGrapher)((IlvGrapher)view.getManager()));
            IlvSDMModel model = engine.getModel();
            CommandProcessor.getInstance().beginTrans(((PreferenceDefinition)id).getNLSName());
            try {
                SDMUndoUtil.captureModelUndo(ideContext, model, new Runnable(){

                    @Override
                    public void run() {
                        SDMDiagramContextPropertyModel.this.invokePropertySetCommand(ideContext, data, row, col);
                    }
                });
            }
            finally {
                CommandProcessor.getInstance().endTrans();
            }
        } else {
            this.invokePropertySetCommand(ideContext, data, row, col);
        }
    }

    @Override
    protected Command createCommandImpl(SelectionModel model, Object id, Object data, int row, int col) {
        return id != null ? new PropertySetCommand(model, id, col, data) : null;
    }

    protected void invokePropertySetCommand(Context context, Object data, int row, int col) {
        Command cmd = this.createCommand(data, row, col);
        cmd.setContext(context);
        if (cmd != null) {
            try {
                cmd.doit();
            }
            catch (Exception ex) {
                FeedbackManager.reportException((Throwable)ex);
            }
        }
    }

    @Override
    protected AbstractDiagramContextPropertyModel.EventCoalesce createEventCoalesce(List subjects) {
        return new SDMDiagramEventCoalesce(subjects);
    }

    private class SDMDiagramEventCoalesce
    extends AbstractDiagramContextPropertyModel.EventCoalesce
    implements SDMPropertyChangeListener {
        private boolean _updated;
        private IlvSDMModel _model;

        public SDMDiagramEventCoalesce(List subjects) {
            super(subjects);
            this._updated = false;
        }

        @Override
        public void attach(Observer observer) {
            if (this.getObservers().isEmpty() && SDMDiagramContextPropertyModel.this.getContext() != null) {
                IlvManagerView view = ((DiagramView)SDMDiagramContextPropertyModel.this.getContext().getProperty("oracle.diagram.inspector.ActiveInspectedView")).getActiveManagerView();
                IlvSDMEngine engine = IlvSDMEngine.getSDMEngine((IlvGrapher)((IlvGrapher)view.getManager()));
                IlvSDMModel model = engine.getModel();
                model.addSDMPropertyChangeListener((SDMPropertyChangeListener)this);
                this._model = model;
            }
            super.attach(observer);
        }

        @Override
        public void detach(Observer observer) {
            super.detach(observer);
            if (this._model != null) {
                this._model.removeSDMPropertyChangeListener((SDMPropertyChangeListener)this);
            }
        }

        public void propertyChanged(SDMPropertyChangeEvent event) {
            this.restartTimer();
        }
    }
}

