/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.interaction;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvObjectInteractorContext;
import ilog.views.IlvPoint;
import ilog.views.IlvSelection;
import ilog.views.sdm.IlvSDMEngine;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.context.IdeContextPlugin;
import oracle.diagram.core.interaction.CoreSelectInteractor;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.accessibility.NavigationKeyListener;
import oracle.diagram.framework.action.Actions;
import oracle.diagram.framework.graphic.GraphicUtils;
import oracle.diagram.framework.interaction.DefaultObjectInteractorCache;
import oracle.diagram.framework.interaction.InPlaceEditPlugin;
import oracle.diagram.framework.menu.DiagramContextMenuPlugin;
import oracle.diagram.framework.readonly.ReadOnlyUtil;
import oracle.diagram.sdm.interaction.SDMLinkReconnectInteractor;
import oracle.diagram.sdm.interaction.SDMObjectInteractorContextAdapter;
import oracle.diagram.sdm.interaction.SDMSelectInteractorMoveSelection;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;

public class SDMSelectInteractor
extends CoreSelectInteractor {
    private static final String UNDO_CLASS_PREFIX = "UndoableSDM";
    private static final String RO_CLASS_PREFIX = "ReadOnlySDM";
    private DefaultObjectInteractorCache _defaultInteractors = new DefaultObjectInteractorCache(SDMSelectInteractor.class.getPackage().getName(), "UndoableSDM", "ReadOnlySDM");
    private final SDMObjectInteractorContextAdapter _sdmSelectionObjectInteractorContext = new SDMObjectInteractorContextAdapter();
    private final SDMObjectInteractorContextAdapter _sdmGraphicObjectInteractorContext = new SDMObjectInteractorContextAdapter();

    public SDMSelectInteractor() {
        this.addKeyListener(new NavigationKeyListener());
    }

    public boolean isMoveAllowed() {
        return super.isMoveAllowed() && !ReadOnlyUtil.isPermanentReadOnlyContext(this.getDiagramContext());
    }

    public boolean isEditionAllowed() {
        return super.isEditionAllowed() && !ReadOnlyUtil.isPermanentReadOnlyContext(this.getDiagramContext());
    }

    protected final DiagramContext getDiagramContext() {
        IlvManagerView view = this.getManagerView();
        if (view == null) {
            throw new IllegalStateException("Interactor is not attached to a view");
        }
        return DiagramContext.getDiagramContext(view);
    }

    @Override
    protected void showContextMenu(MouseEvent event) {
        DiagramContextMenuPlugin dcmp = PluginUtil.getPlugin(this.getDiagramContext(), DiagramContextMenuPlugin.class);
        if (dcmp != null) {
            dcmp.showContextMenu(event);
        }
    }

    protected IlvGraphic getSingleSelection(IlvManager mgr) {
        IlvSDMEngine engine = this.getEngine();
        Enumeration e = engine.getSelectedObjects();
        if (e.hasMoreElements()) {
            Object sel = e.nextElement();
            if (!e.hasMoreElements()) {
                return engine.getGraphic(sel, true);
            }
        }
        return null;
    }

    @Override
    protected int getMainSelectionCount(IlvManager mgr) {
        IlvSDMEngine engine = this.getEngine();
        int count = 0;
        Enumeration e = engine.getSelectedObjects();
        while (e.hasMoreElements()) {
            e.nextElement();
            ++count;
        }
        return count;
    }

    @Override
    protected boolean hasSingleSelection(IlvManager mgr) {
        IlvSDMEngine engine = this.getEngine();
        Enumeration e = engine.getSelectedObjects();
        if (e.hasMoreElements()) {
            e.nextElement();
            return !e.hasMoreElements();
        }
        return false;
    }

    @Override
    protected boolean performInPlaceEdit(IlvManager mgr, IlvGraphic hit, IlvGraphic subHit, IlvPoint point, MouseEvent event) {
        if (hit instanceof IlvLabelInterface && this.hasSingleSelection(mgr) && GraphicUtils.isWithinLabel(hit, point, this.getManagerView())) {
            return this.performInPlaceEdit(mgr, hit, point);
        }
        return false;
    }

    protected boolean performInPlaceEdit(IlvManager mgr, IlvGraphic g, IlvPoint p) {
        InPlaceEditPlugin plugin = PluginUtil.getPlugin(this.getManagerView(), InPlaceEditPlugin.class);
        if (plugin != null) {
            return plugin.performInPlaceEdit(mgr, g, null);
        }
        return false;
    }

    @Override
    protected IlvManagerViewInteractor getLinkReconnectInteractor() {
        return new SDMLinkReconnectInteractor(this);
    }

    @Override
    protected IlvManagerViewInteractor getMoveSelectionInteractor() {
        return new SDMSelectInteractorMoveSelection(this);
    }

    @Override
    protected boolean performEdit(IlvManager mgr, IlvGraphic hitObj, IlvGraphic subHitObj) {
        IdeAction action = IdeAction.find((int)Actions.CMD_EDIT_PROPERTIES);
        if (action != null) {
            Context context = this.getContext();
            action.updateAction(context);
            if (action.isEnabled()) {
                try {
                    action.performAction(context);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected Context getContext() {
        return this.getDiagramContext().getPlugin(IdeContextPlugin.class).getContext();
    }

    @Override
    protected IlvObjectInteractor getDefaultObjectInteractor(String defaultName) {
        return this._defaultInteractors.getDefaultObjectInteractor(defaultName);
    }

    public final IlvSDMEngine getEngine() {
        return IlvSDMEngine.getSDMEngine((IlvGrapher)((IlvGrapher)this.getManager()));
    }

    @Override
    protected IlvObjectInteractorContext getObjectInteractorContext(IlvGraphic obj, IlvGraphicBag bag) {
        IlvObjectInteractorContext result = super.getObjectInteractorContext(obj, bag);
        SDMObjectInteractorContextAdapter a = obj instanceof IlvSelection ? this._sdmSelectionObjectInteractorContext : this._sdmGraphicObjectInteractorContext;
        a.setProxiedContext(result);
        a.setIdeContext(this.getContext());
        a.setEngine(this.getEngine());
        a.setView(this.getManagerView());
        return a;
    }

    @Override
    protected void clearInteractives() {
        super.clearInteractives();
        this._sdmSelectionObjectInteractorContext.dispose();
        this._sdmGraphicObjectInteractorContext.dispose();
    }
}

