/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.palette.common;

import ilog.views.IlvGraphic;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.IlvSDMModel;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.accessibility.ADACreateLink;
import oracle.diagram.framework.accessibility.NavigableGraphicPlugin;
import oracle.diagram.framework.accessibility.PresentableGraphicPlugin;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.diagram.sdm.palette.interactor.MakeSDMLinkInteractor;
import oracle.ide.palette2.PaletteItem;

public class CreateDefaultSDMLinkHandler
extends ADACreateLink {
    private final DiagramContext _context;
    private final PaletteItem _item;

    public CreateDefaultSDMLinkHandler(DiagramContext context, PaletteItem item) {
        this._context = context;
        this._item = item;
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    protected final IlvManagerView getManagerView() {
        return this.getDiagramContext().getManagerView();
    }

    protected final PaletteItem getPaletteItem() {
        return this._item;
    }

    @Override
    protected boolean createLink(IlvGraphic src, IlvGraphic target) {
        IlvManagerViewInteractor i = this.getManagerView().getInteractor();
        if (i != null && i instanceof MakeSDMLinkInteractor) {
            MakeSDMLinkInteractor makeSDMLinkInteractor = (MakeSDMLinkInteractor)i;
            return makeSDMLinkInteractor.createLink(src, target) != null;
        }
        return false;
    }

    @Override
    protected List<IlvGraphic> getValidSources() {
        return this.getValidConnectionGraphics(null);
    }

    @Override
    protected List<IlvGraphic> getValidTargets(IlvGraphic source) {
        return this.getValidConnectionGraphics(source);
    }

    @Override
    protected IlvGraphic getInitialSelection() {
        IlvManager mgr = this.getManagerView().getManager();
        int count = mgr.getSelectedObjectsCount(true);
        if (count == 1) {
            return mgr.getSelectedObjects(true).nextElement();
        }
        return null;
    }

    @Override
    protected String getType() {
        return this.getPaletteItem().getName();
    }

    @Override
    protected NavigableGraphicPlugin getNavigableGraphicPlugin(IlvGraphic g) {
        return PluginUtil.getPlugin(this.getDiagramContext(), g, NavigableGraphicPlugin.class);
    }

    @Override
    protected PresentableGraphicPlugin getPresentableGraphicPlugin(IlvGraphic g) {
        return PluginUtil.getPlugin(this.getDiagramContext(), g, PresentableGraphicPlugin.class);
    }

    protected boolean isValidConnectionGraphic(IlvGraphic graphic, IlvGraphic src) {
        IlvManagerViewInteractor i = this.getManagerView().getInteractor();
        if (i != null && i instanceof MakeSDMLinkInteractor) {
            MakeSDMLinkInteractor makeSDMLinkInteractor = (MakeSDMLinkInteractor)i;
            return src == null ? makeSDMLinkInteractor.isValidSource(graphic) : makeSDMLinkInteractor.isValidDestination(src, graphic);
        }
        return false;
    }

    private void processPossibleConnectionGraphic(IlvSDMEngine engine, IlvSDMModel model, Vector<IlvGraphic> valid, Object obj, IlvGraphic src) {
        IlvGraphic graphic = engine.getGraphic(obj, false);
        if (this.isValidConnectionGraphic(graphic, src)) {
            valid.add(graphic);
        }
        Enumeration e = model.getChildren(obj);
        while (e != null && e.hasMoreElements()) {
            Object child = e.nextElement();
            this.processPossibleConnectionGraphic(engine, model, valid, child, src);
        }
    }

    private List<IlvGraphic> getValidConnectionGraphics(IlvGraphic src) {
        IlvSDMEngine engine = SDMDiagramContextUtil.getSDMEngine(this.getManagerView());
        IlvSDMModel model = engine.getModel();
        Vector<IlvGraphic> valid = new Vector<IlvGraphic>();
        Enumeration e = model.getObjects();
        while (e != null && e.hasMoreElements()) {
            Object obj = e.nextElement();
            this.processPossibleConnectionGraphic(engine, model, valid, obj, src);
        }
        return Collections.unmodifiableList(this.sortByName(valid));
    }
}

