/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.selection;

import java.util.Enumeration;
import java.util.LinkedHashSet;
import oracle.diagram.core.context.DiagramContext;
import oracle.diagram.core.plugin.AbstractPlugin;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginManager;
import oracle.diagram.framework.selection.DiagramIdeSelectionPlugin;
import oracle.diagram.sdm.context.SDMDiagramContextUtil;
import oracle.ide.model.Element;

public abstract class AbstractSDMDiagramIdeSelectionPlugin
extends AbstractPlugin
implements DiagramIdeSelectionPlugin {
    private static final Element[] EMPTY = new Element[0];
    private final DiagramContext _context;
    private Element[] _cachedSelection = EMPTY;
    private Element[] _cachedInspectorSelection = EMPTY;
    private int _disabled = 0;

    public AbstractSDMDiagramIdeSelectionPlugin(DiagramContext context) {
        this._context = context;
    }

    @Override
    public final Element[] getInspectorSelection() {
        return this._cachedInspectorSelection;
    }

    @Override
    public final Element[] getSelection() {
        return this._cachedSelection;
    }

    @Override
    public final void fetchSelectionFromUI() {
        LinkedHashSet<Element> selected = new LinkedHashSet<Element>();
        LinkedHashSet<Element> inspectorSelected = new LinkedHashSet<Element>();
        boolean hasSelection = false;
        Enumeration sel = SDMDiagramContextUtil.getSDMEngine(this.getDiagramContext()).getSelectedObjects();
        while (sel.hasMoreElements()) {
            Element[] tmpInsp;
            hasSelection = true;
            Object o = sel.nextElement();
            Element[] tmpSel = this.getSDMObjectSelection(o);
            if (tmpSel != null && tmpSel.length > 0) {
                for (Element el : tmpSel) {
                    selected.add(el);
                }
            }
            if ((tmpInsp = this.getSDMObjectInspectorSelection(o)) == null || tmpInsp.length <= 0) continue;
            for (Element el : tmpInsp) {
                inspectorSelected.add(el);
                if (tmpSel != null && tmpSel.length != 0) continue;
                selected.add(el);
            }
        }
        if (!hasSelection) {
            Element[] root = this.getSDMObjectInspectorSelection(null);
            if (root != null && root.length != 0) {
                this._cachedSelection = EMPTY;
                this._cachedInspectorSelection = root;
            } else {
                this._cachedSelection = EMPTY;
                this._cachedInspectorSelection = EMPTY;
            }
            return;
        }
        this._cachedSelection = selected != null ? selected.toArray(new Element[selected.size()]) : EMPTY;
        this._cachedInspectorSelection = inspectorSelected != null ? inspectorSelected.toArray(new Element[inspectorSelected.size()]) : EMPTY;
    }

    protected final DiagramContext getDiagramContext() {
        return this._context;
    }

    protected abstract Element[] getSDMObjectSelection(Object var1);

    protected Element[] getSDMObjectInspectorSelection(Object sdmObject) {
        return null;
    }

    @Override
    public void detach(PluginManager pluginManager, Class<? extends Plugin> pluginType) {
        super.detach(pluginManager, pluginType);
        this._cachedSelection = null;
        this._cachedInspectorSelection = null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            ++this._disabled;
        } else if (this._disabled > 0) {
            --this._disabled;
        } else {
            throw new IllegalStateException("error: Mismatch between setEnabled(true) and setEnabled(false) calls");
        }
    }

    @Override
    public boolean isEnabled() {
        return this._disabled == 0;
    }
}

